/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.apiwrapper.cli.VeracodeCommand;
import com.veracode.http.Credentials;
import com.veracode.jenkins.plugin.VeracodeAction;
import com.veracode.jenkins.plugin.args.UploadAndScanArgs;
import com.veracode.jenkins.plugin.data.ProxyBlock;
import com.veracode.jenkins.plugin.data.ScanHistory;
import com.veracode.jenkins.plugin.utils.FileUtil;
import com.veracode.jenkins.plugin.utils.FormValidationUtil;
import com.veracode.jenkins.plugin.utils.RemoteScanUtil;
import com.veracode.jenkins.plugin.utils.StringUtil;
import com.veracode.jenkins.plugin.utils.WrapperUtil;
import com.veracode.jenkins.plugin.utils.XmlUtil;
import com.veracode.util.lang.StringUtility;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class VeracodePipelineRecorder
extends Recorder
implements SimpleBuildStep {
    @DataBoundSetter
    public final String applicationName;
    @DataBoundSetter
    public final String criticality;
    @DataBoundSetter
    public final String sandboxName;
    @DataBoundSetter
    public final String scanName;
    @DataBoundSetter
    public final boolean waitForScan;
    @DataBoundSetter
    public final Integer timeout;
    private Boolean deleteIncompleteScan;
    @DataBoundSetter
    public String deleteIncompleteScanLevel;
    @DataBoundSetter
    public final boolean createProfile;
    @DataBoundSetter
    public final String teams;
    @DataBoundSetter
    public final boolean createSandbox;
    @DataBoundSetter
    public final boolean timeoutFailsJob;
    @DataBoundSetter
    public final boolean canFailJob;
    @DataBoundSetter
    public final boolean debug;
    @DataBoundSetter
    public final boolean copyRemoteFiles;
    @DataBoundSetter
    public final String uploadIncludesPattern;
    @DataBoundSetter
    public final String uploadExcludesPattern;
    @DataBoundSetter
    public final String scanIncludesPattern;
    @DataBoundSetter
    public final String scanExcludesPattern;
    @DataBoundSetter
    public final String fileNamePattern;
    @DataBoundSetter
    public final String replacementPattern;
    @DataBoundSetter
    public final String vid;
    @DataBoundSetter
    public final String vkey;
    @DataBoundSetter
    public final boolean useProxy;
    @DataBoundSetter
    public final String pHost;
    @DataBoundSetter
    public final String pPort;
    @DataBoundSetter
    public final String pUser;
    @DataBoundSetter
    public final String pPassword;
    private static String inclusive = "vosp-api-wrappers-java*.jar";
    private static String execJarFile = "VeracodeJavaAPI";
    private static String regex = "(vosp-api-wrappers).*?(.jar)";

    @DataBoundConstructor
    public VeracodePipelineRecorder(String applicationName, String criticality, String sandboxName, String scanName, boolean waitForScan, int timeout, String deleteIncompleteScanLevel, boolean createProfile, String teams, boolean createSandbox, boolean timeoutFailsJob, boolean canFailJob, boolean debug, String uploadIncludesPattern, String uploadExcludesPattern, String scanIncludesPattern, String scanExcludesPattern, String fileNamePattern, String replacementPattern, boolean copyRemoteFiles, boolean useProxy, String pHost, String pPort, String pUser, String pPassword, String vid, String vkey) {
        this.applicationName = applicationName;
        this.criticality = criticality;
        this.sandboxName = sandboxName;
        this.scanName = scanName;
        this.timeoutFailsJob = timeoutFailsJob;
        this.waitForScan = waitForScan;
        this.timeout = waitForScan && timeout > 0 ? Integer.valueOf(timeout) : null;
        this.deleteIncompleteScanLevel = deleteIncompleteScanLevel;
        this.createProfile = createProfile;
        this.teams = teams;
        this.createSandbox = createSandbox;
        this.canFailJob = canFailJob;
        this.debug = debug;
        this.copyRemoteFiles = copyRemoteFiles;
        this.uploadIncludesPattern = StringUtility.getEmptyIfNull((String)uploadIncludesPattern);
        this.uploadExcludesPattern = StringUtility.getEmptyIfNull((String)uploadExcludesPattern);
        this.scanIncludesPattern = scanIncludesPattern;
        this.scanExcludesPattern = scanExcludesPattern;
        this.fileNamePattern = fileNamePattern;
        this.replacementPattern = replacementPattern;
        this.vid = vid;
        this.vkey = vkey;
        this.useProxy = useProxy;
        this.pHost = useProxy ? pHost : null;
        this.pPort = useProxy ? pPort : null;
        this.pUser = useProxy ? pUser : null;
        this.pPassword = useProxy ? pPassword : null;
    }

    public Boolean getDeleteIncompleteScan() {
        return this.deleteIncompleteScan;
    }

    @DataBoundSetter
    public void setDeleteIncompleteScan(Boolean deleteIncompleteScan) {
        this.deleteIncompleteScan = deleteIncompleteScan;
        this.deleteIncompleteScanLevel = deleteIncompleteScan != null ? deleteIncompleteScan.toString() : null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream ps = listener.getLogger();
        ps.println("------------------------------------------------------------------------");
        ps.println("Upload and Scan with Veracode Pipeline");
        ps.println("------------------------------------------------------------------------");
        EnvVars envVars = run.getEnvironment(listener);
        UploadAndScanArgs.setEnvVars(envVars, run.getDisplayName(), run.getParent().getFullDisplayName());
        String uploadincludePattern = envVars.expand(this.uploadIncludesPattern);
        String uploadexcludePattern = envVars.expand(this.uploadExcludesPattern);
        if (this.debug) {
            ps.println("\r\n[Debug mode is on]\r\n");
            ps.println(String.format("Can Fail Job: %s%n", this.canFailJob));
            if (this.timeout != null) {
                ps.println(String.format("Timeout: %s%n", this.timeout));
            }
            try {
                Method method = VeracodeCommand.class.getDeclaredMethod("getVersionString", new Class[0]);
                method.setAccessible(true);
                String version = (String)method.invoke(null, new Object[0]);
                if (!StringUtil.isNullOrEmpty(version)) {
                    ps.println(String.format("Version information:%n%s", version));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                ps.println("Could not retrieve API wrapper's version information.");
            }
            try {
                String location = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toString();
                if (!StringUtil.isNullOrEmpty(location)) {
                    ps.println("\r\nHPI location: ");
                    location = location.replace("file:/", "");
                    listener.hyperlink("file://" + location, location);
                }
            }
            catch (Exception e) {
                ps.println("\r\nCould not retrieve hpi file's directory.");
            }
        }
        boolean isRemoteWorkspace = workspace.isRemote();
        if (this.debug) {
            ps.println(String.format("%n%nProcessing files in [%s] workspace: ", isRemoteWorkspace ? "remote" : "local"));
            String workspaceDir = workspace.getRemote();
            workspaceDir = workspaceDir.replace("\\", "/");
            listener.hyperlink("file://" + workspaceDir, workspaceDir);
        }
        String[] uploadAndScanFilePaths = null;
        File localWorkspaceDir = null;
        try {
            block57: {
                if (isRemoteWorkspace) {
                    if (this.debug) {
                        if (!this.copyRemoteFiles) {
                            ps.print(String.format("%n%nPerforming scan from [remote] workspace?%n%s", !this.copyRemoteFiles));
                            ps.print("\n");
                        } else {
                            ps.print(String.format("%n%nPerforming scan [local] workspace after copying remote files?%n%s", this.copyRemoteFiles));
                            ps.print("\n");
                        }
                    }
                    if (this.copyRemoteFiles) {
                        localWorkspaceDir = new File(run.getParent().getRootDir(), "temp-veracode-local-workspace");
                        if (this.debug) {
                            ps.print("\r\n\r\nAttempting to copy remote files to [local] workspace:\r\n");
                            String p = localWorkspaceDir.getCanonicalPath().replace("\\", "/");
                            listener.hyperlink("file://" + p, p);
                        }
                        try {
                            boolean dirCreated;
                            if (localWorkspaceDir.exists()) {
                                FileUtil.deleteDirectory(localWorkspaceDir);
                            }
                            if (!(dirCreated = localWorkspaceDir.mkdir())) {
                                ps.print("\r\n\r\nFailed to create temporary local workspace.\r\n");
                                if (this.canFailJob) {
                                    run.setResult(Result.FAILURE);
                                }
                            }
                            FilePath localWorkspaceFilePath = new FilePath(localWorkspaceDir);
                            workspace.copyRecursiveTo(uploadincludePattern, uploadexcludePattern, localWorkspaceFilePath);
                            uploadAndScanFilePaths = FileUtil.getStringFilePaths(localWorkspaceFilePath.list(uploadincludePattern, uploadexcludePattern));
                        }
                        catch (Exception e) {
                            String msg = e.getMessage();
                            ps.print("\r\n\r\nFailed to copy remote files to the [local] workspace:\r\n" + e.getClass().getName() + (msg != null ? ": " + msg : "") + "\r\n\r\n");
                            if (isRemoteWorkspace && this.copyRemoteFiles) {
                                try {
                                    if (localWorkspaceDir != null && localWorkspaceDir.exists()) {
                                        FileUtil.deleteDirectory(localWorkspaceDir);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (run.getResult() == Result.FAILURE) {
                                throw new AbortException();
                            }
                            return;
                        }
                    }
                    if (this.copyJarRemoteBuild(workspace, listener)) {
                        if (!this.runScanFromRemote(run, workspace, listener, ps) && this.canFailJob) {
                            run.setResult(Result.FAILURE);
                        }
                    } else if (this.canFailJob) {
                        ps.println("Could not copy Veracode libs");
                        run.setResult(Result.FAILURE);
                    }
                    return;
                }
                uploadAndScanFilePaths = FileUtil.getStringFilePaths(workspace.list(uploadincludePattern, uploadexcludePattern));
                if (this.debug) {
                    ps.print("\r\n\r\nBuilding arguments. ");
                }
                boolean autoApplicationName = false;
                boolean autoScanName = false;
                boolean createAutoApplicationDescription = false;
                String str_timeout = "";
                if (this.timeout != null) {
                    str_timeout = Integer.toString(this.timeout);
                }
                UploadAndScanArgs uploadAndScanArguments = UploadAndScanArgs.newUploadAndScanArgs(false, autoApplicationName, createAutoApplicationDescription, autoScanName, this.createSandbox, this.createProfile, this.teams, this.useProxy, this.vid, this.vkey, run.getDisplayName(), run.getParent().getFullDisplayName(), this.applicationName, this.sandboxName, this.scanName, this.criticality, this.scanIncludesPattern, this.scanExcludesPattern, this.fileNamePattern, this.replacementPattern, this.pHost, this.pPort, this.pUser, this.pPassword, workspace, run.getEnvironment(listener), str_timeout, this.deleteIncompleteScanLevel, this.debug, uploadAndScanFilePaths);
                if (this.debug) {
                    ps.println(String.format("Calling wrapper with arguments:%n%s%n", Arrays.toString(uploadAndScanArguments.getMaskedArguments())));
                }
                try {
                    VeracodeCommand.VeracodeParser parser = new VeracodeCommand.VeracodeParser();
                    parser.setOutputWriter(ps);
                    parser.setErrorWriter(ps);
                    parser.throwExceptions(true);
                    parser.setScanCompleteTimeout(this.timeout != null ? this.timeout.toString() : null);
                    int retCode = parser.parse(uploadAndScanArguments.getArguments());
                    try {
                        if (null != this.timeout) {
                            if (4 == retCode || 0 == retCode) {
                                this.getScanResults(run, listener, autoApplicationName);
                            } else {
                                run.addAction((Action)new VeracodeAction());
                            }
                        }
                    }
                    catch (Exception e) {
                        ps.println();
                        ps.println(String.format("Ran into problem when generating scan results in Jenkins. Error: [%s, %s]", e.getClass().getSimpleName(), e.getMessage()));
                        e.printStackTrace(ps);
                    }
                    finally {
                        if (retCode != 0 && this.canFailJob) {
                            ps.println();
                            ps.println("Error- Returned code from wrapper:" + retCode);
                            run.setResult(Result.FAILURE);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.canFailJob) break block57;
                    run.setResult(Result.FAILURE);
                }
            }
            ps.println();
            return;
        }
        finally {
            if (isRemoteWorkspace && this.copyRemoteFiles) {
                try {
                    if (localWorkspaceDir != null && localWorkspaceDir.exists()) {
                        FileUtil.deleteDirectory(localWorkspaceDir);
                    }
                }
                catch (Exception exception) {}
            }
            if (run.getResult() == Result.FAILURE) {
                throw new AbortException();
            }
        }
    }

    public PipelineDescriptorImpl getDescriptor() {
        return (PipelineDescriptorImpl)super.getDescriptor();
    }

    private boolean copyJarFiles(Node node, FilePath local, FilePath remote, PrintStream ps) throws Exception {
        boolean bRet;
        block2: {
            bRet = false;
            try {
                local.copyRecursiveTo(inclusive, null, remote);
                FilePath[] files = remote.list(inclusive);
                String jarName = files[0].getRemote();
                FilePath oldJar = new FilePath(node.getChannel(), jarName);
                String newJarName = jarName.replaceAll(regex, execJarFile + "$2");
                FilePath newjarFilePath = new FilePath(node.getChannel(), newJarName);
                oldJar.copyToWithPermission(newjarFilePath);
                bRet = true;
            }
            catch (RuntimeException ex) {
                if (!this.canFailJob) break block2;
                ps.print("Failed to copy the veracode java-wrapper libaries\n");
            }
        }
        return bRet;
    }

    private boolean copyJarRemoteBuild(FilePath workspace, TaskListener listener) {
        boolean bRet;
        block15: {
            bRet = false;
            PrintStream ps = listener.getLogger();
            boolean copyRemoteFiles = this.copyRemoteFiles;
            boolean isRemoteWorkspace = workspace.isRemote();
            if (isRemoteWorkspace && !copyRemoteFiles) {
                Computer comp = workspace.toComputer();
                if (comp == null) {
                    throw new RuntimeException("Cannot locate the remote workspace.");
                }
                Node node = comp.getNode();
                if (node == null) {
                    throw new RuntimeException("Cannot locate the remote node.");
                }
                try {
                    FilePath[] files;
                    FilePath localWorkspaceFilePath = FileUtil.getLocalWorkspaceFilepath();
                    FilePath remoteVeracodeFilePath = RemoteScanUtil.getRemoteVeracodePath(node);
                    if (remoteVeracodeFilePath == null) {
                        throw new RuntimeException("Cannot retrieve the remote file path.");
                    }
                    if (!remoteVeracodeFilePath.exists()) {
                        if (this.debug) {
                            ps.println("Making remote dir");
                        }
                        remoteVeracodeFilePath.mkdirs();
                    }
                    if ((files = remoteVeracodeFilePath.list(inclusive)).length == 0) {
                        bRet = this.copyJarFiles(node, localWorkspaceFilePath, remoteVeracodeFilePath, ps);
                    } else {
                        String oldjarName;
                        int oldVersion;
                        FilePath[] newfiles = localWorkspaceFilePath.list(inclusive);
                        String newjarName = newfiles[0].getRemote();
                        int newVersion = RemoteScanUtil.getJarVersion(newjarName);
                        if (newVersion > (oldVersion = RemoteScanUtil.getJarVersion(oldjarName = files[0].getRemote()))) {
                            if (this.debug) {
                                ps.println("Newer veracode library version, copying it to remote machine");
                            }
                            remoteVeracodeFilePath.deleteContents();
                            bRet = this.copyJarFiles(node, localWorkspaceFilePath, remoteVeracodeFilePath, ps);
                        } else {
                            String jarName = files[0].getRemote();
                            String newJarName = jarName.replaceAll(regex, execJarFile + "$2");
                            FilePath newjarFilePath = new FilePath(node.getChannel(), newJarName);
                            if (newjarFilePath.exists()) {
                                bRet = true;
                            }
                        }
                    }
                    break block15;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (this.canFailJob) {
                        ps.println(ex.getMessage());
                    }
                    break block15;
                }
            }
            bRet = true;
        }
        return bRet;
    }

    private boolean runScanFromRemote(Run<?, ?> run, FilePath workspace, TaskListener listener, PrintStream ps) throws IOException, InterruptedException {
        boolean bRet;
        block17: {
            bRet = false;
            boolean autoApplicationName = false;
            boolean autoScanName = true;
            boolean createAutoApplicationDescription = false;
            Computer comp = workspace.toComputer();
            if (comp == null) {
                throw new RuntimeException("Cannot locate the remote workspace.");
            }
            Node node = comp.getNode();
            if (node == null) {
                throw new RuntimeException("Cannot locate the remote node.");
            }
            FilePath remoteVeracodeFilePath = RemoteScanUtil.getRemoteVeracodePath(node);
            if (remoteVeracodeFilePath == null) {
                throw new RuntimeException("Cannot retrieve the remote file path.");
            }
            String jarFilePath = remoteVeracodeFilePath.getRemote();
            String remoteworkspace = workspace.getRemote();
            String sep = RemoteScanUtil.getPathSeparator(remoteworkspace);
            EnvVars envVars = run.getEnvironment(listener);
            UploadAndScanArgs.setEnvVars(envVars, run.getDisplayName(), run.getParent().getFullDisplayName());
            String uploadincludePattern = envVars.expand(this.uploadIncludesPattern);
            String uploadexcludePattern = envVars.expand(this.uploadExcludesPattern);
            try {
                Proc proc;
                int retcode;
                String[] uploadAndScanFilePaths = FileUtil.getStringFilePaths(workspace.list(uploadincludePattern, uploadexcludePattern));
                String str_timeout = "";
                if (this.timeout != null) {
                    str_timeout = Integer.toString(this.timeout);
                }
                UploadAndScanArgs uploadAndScanArguments = UploadAndScanArgs.newUploadAndScanArgs(true, autoApplicationName, createAutoApplicationDescription, autoScanName, this.createSandbox, this.createProfile, this.teams, this.useProxy, this.vid, this.vkey, run.getDisplayName(), run.getParent().getFullDisplayName(), this.applicationName, this.sandboxName, this.scanName, this.criticality, this.scanIncludesPattern, this.scanExcludesPattern, this.fileNamePattern, this.replacementPattern, this.pHost, this.pPort, this.pUser, this.pPassword, workspace, run.getEnvironment(listener), str_timeout, this.deleteIncompleteScanLevel, this.debug, uploadAndScanFilePaths);
                String jarPath = jarFilePath + sep + execJarFile + ".jar";
                String cmd = "java -jar " + jarPath;
                String[] cmds = uploadAndScanArguments.getArguments();
                StringBuilder result = new StringBuilder();
                result.append(cmd);
                for (String _cmd : cmds) {
                    _cmd = RemoteScanUtil.formatParameterValue(_cmd);
                    result.append(" " + _cmd);
                }
                ArgumentListBuilder command = new ArgumentListBuilder();
                command.addTokenized(result.toString());
                List remoteCmd = command.toList();
                int iSize = remoteCmd.size();
                Integer[] iPos = RemoteScanUtil.getMaskPosition(remoteCmd);
                int iPosPassword = iPos[0];
                int iPosKey = iPos[1];
                int iPosProxyPassword = iPos[2];
                Launcher launcher = node.createLauncher(listener);
                Launcher.ProcStarter procStart = new Launcher.ProcStarter(launcher);
                boolean[] masks = new boolean[iSize];
                for (int i = 0; i < iSize; ++i) {
                    if (iPosPassword != -1) {
                        if (iPosPassword != i) continue;
                        masks[i] = true;
                        continue;
                    }
                    if (iPosKey != -1) {
                        if (iPosKey != i) continue;
                        masks[i] = true;
                        continue;
                    }
                    if (iPosProxyPassword != -1) {
                        if (iPosProxyPassword != i) continue;
                        masks[i] = true;
                        continue;
                    }
                    masks[i] = false;
                }
                procStart = procStart.pwd(workspace).cmds(command).masks(masks).stdout(listener).quiet(true);
                if (this.debug) {
                    procStart.quiet(false);
                    ps.print("\nInvoking the following command in remote workspace:\n");
                }
                if ((retcode = (proc = launcher.launch(procStart)).join()) != 0 && this.canFailJob) {
                    ps.print("\r\n\r\nError- Returned code from wrapper:" + retcode + "\r\n\n");
                } else {
                    bRet = true;
                }
                try {
                    if (null == this.timeout) break block17;
                    if (4 == retcode || 0 == retcode) {
                        this.getScanResults(run, listener, autoApplicationName);
                        break block17;
                    }
                    run.addAction((Action)new VeracodeAction());
                }
                catch (Exception e) {
                    ps.println();
                    ps.println(String.format("Ran into problem when generating scan results in Jenkins. Error: [%s, %s]", e.getClass().getSimpleName(), e.getMessage()));
                    e.printStackTrace(ps);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!this.canFailJob) break block17;
                ps.print("\r\n\r\n" + ex.getMessage());
            }
        }
        return bRet;
    }

    private void getScanResults(Run<?, ?> run, TaskListener listener, boolean autoApplicationName) throws Exception {
        ProxyBlock proxy = null;
        if (this.useProxy) {
            proxy = new ProxyBlock(this.pHost, this.pPort, this.pUser, this.pPassword);
        }
        EnvVars envVars = run.getEnvironment(listener);
        UploadAndScanArgs.setEnvVars(envVars, run.getDisplayName(), run.getParent().getFullDisplayName());
        String appName = this.applicationName;
        if (!StringUtil.isNullOrEmpty(appName)) {
            appName = envVars.expand(appName);
        } else if (autoApplicationName) {
            appName = (String)envVars.get((Object)"projectname");
        }
        String resolvedSandboxName = !StringUtil.isNullOrEmpty(this.sandboxName) ? envVars.expand(this.sandboxName) : this.sandboxName;
        try {
            String buildInfoXML = WrapperUtil.getBuildInfo(appName, resolvedSandboxName, this.vid, this.vkey, proxy);
            String buildId = XmlUtil.parseBuildId(buildInfoXML);
            String detailedReportXML = WrapperUtil.getDetailedReport(buildId, this.vid, this.vkey, proxy);
            ScanHistory scanHistory = XmlUtil.newScanHistory(buildInfoXML, detailedReportXML, run);
            Credentials credentials = Credentials.create((String)this.vid, (String)this.vkey);
            String xmlApiHost = credentials.getRegion().getXmlApiHost();
            run.addAction((Action)new VeracodeAction(scanHistory, xmlApiHost));
        }
        catch (Exception e) {
            run.addAction((Action)new VeracodeAction());
            throw e;
        }
    }

    private final int getTimeout() {
        return Integer.parseInt(FormValidationUtil.formatTimeout(String.valueOf(this.timeout)));
    }

    @Symbol(value={"veracode"})
    @Extension
    public static final class PipelineDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final String PostBuildActionDisplayText = "Upload and Scan with Veracode Pipeline";
        private static final String[] deleteIncompleteScanLevels = new String[]{"0", "1", "2"};

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return false;
        }

        public String getDisplayName() {
            return PostBuildActionDisplayText;
        }

        public ListBoxModel doFillDeleteIncompleteScanLevelItems(@QueryParameter(value="deleteIncompleteScanLevel") String deleteIncompleteScanLevel) {
            ListBoxModel items = new ListBoxModel();
            for (String level : deleteIncompleteScanLevels) {
                items.add((Object)new ListBoxModel.Option(level, level, level.equals(deleteIncompleteScanLevel)));
            }
            return items;
        }
    }
}

