/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.http.Credentials;
import com.veracode.jenkins.plugin.VeracodeAction;
import com.veracode.jenkins.plugin.args.UploadAndScanArgs;
import com.veracode.jenkins.plugin.data.CredentialsBlock;
import com.veracode.jenkins.plugin.data.ProxyBlock;
import com.veracode.jenkins.plugin.data.ScanHistory;
import com.veracode.jenkins.plugin.utils.EncryptionUtil;
import com.veracode.jenkins.plugin.utils.FileUtil;
import com.veracode.jenkins.plugin.utils.FormValidationUtil;
import com.veracode.jenkins.plugin.utils.RemoteScanUtil;
import com.veracode.jenkins.plugin.utils.StringUtil;
import com.veracode.jenkins.plugin.utils.WrapperUtil;
import com.veracode.jenkins.plugin.utils.XmlUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class VeracodeNotifier
extends Notifier {
    private final String _appname;
    private final boolean _createprofile;
    private final String _teams;
    private final String _criticality;
    private final String _sandboxname;
    private final boolean _createsandbox;
    private final String _version;
    private final String _uploadincludespattern;
    private final String _uploadexcludespattern;
    private final String _scanincludespattern;
    private final String _scanexcludespattern;
    private final String _filenamepattern;
    private final String _replacementpattern;
    private final CredentialsBlock _credentials;
    private final boolean _waitforscan;
    private String _timeout;
    private final String deleteIncompleteScan;

    public String getAppname() {
        return EncryptionUtil.decrypt(this._appname);
    }

    public boolean getCreateprofile() {
        return this._createprofile;
    }

    public String getTeams() {
        return this.getCreateprofile() ? EncryptionUtil.decrypt(this._teams) : null;
    }

    public String getCriticality() {
        return EncryptionUtil.decrypt(this._criticality);
    }

    public String getSandboxname() {
        return EncryptionUtil.decrypt(this._sandboxname);
    }

    public boolean getCreatesandbox() {
        return this._createsandbox;
    }

    public String getVersion() {
        return EncryptionUtil.decrypt(this._version);
    }

    public String getUploadincludespattern() {
        return EncryptionUtil.decrypt(this._uploadincludespattern);
    }

    public String getUploadexcludespattern() {
        return EncryptionUtil.decrypt(this._uploadexcludespattern);
    }

    public String getScanincludespattern() {
        return EncryptionUtil.decrypt(this._scanincludespattern);
    }

    public String getScanexcludespattern() {
        return EncryptionUtil.decrypt(this._scanexcludespattern);
    }

    public String getFilenamepattern() {
        return EncryptionUtil.decrypt(this._filenamepattern);
    }

    public String getReplacementpattern() {
        return EncryptionUtil.decrypt(this._replacementpattern);
    }

    public CredentialsBlock getCredentials() {
        return this._credentials;
    }

    public boolean getWaitForScan() {
        return this._waitforscan;
    }

    public String getTimeout() {
        return this.getWaitForScan() ? EncryptionUtil.decrypt(this._timeout) : null;
    }

    public String getDeleteIncompleteScan() {
        if (this.deleteIncompleteScan.equals("false")) {
            return "0";
        }
        if (this.deleteIncompleteScan.equals("true")) {
            return "1";
        }
        return this.deleteIncompleteScan;
    }

    public String getVid() {
        return EncryptionUtil.decrypt(this._credentials != null ? this._credentials.getVid() : null);
    }

    public String getVkey() {
        return EncryptionUtil.decrypt(this._credentials != null ? this._credentials.getVkey() : null);
    }

    public VeracodeDescriptor getDescriptor() {
        return (VeracodeDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        boolean bRet;
        block14: {
            bRet = false;
            boolean debug = this.getDescriptor().getDebug();
            PrintStream ps = listener.getLogger();
            FilePath workspace = build.getWorkspace();
            if (workspace == null) {
                ps.print("\r\n\r\nFailed to locate the build workspace.\r\n");
                return !this.getDescriptor().getFailbuild();
            }
            boolean copyRemoteFiles = this.getDescriptor().getCopyremotefiles();
            boolean isRemoteWorkspace = workspace.isRemote();
            if (isRemoteWorkspace && !copyRemoteFiles) {
                try {
                    FilePath[] files;
                    FilePath localWorkspaceFilePath = FileUtil.getLocalWorkspaceFilepath();
                    FilePath remoteVeracodeFilePath = RemoteScanUtil.getRemoteVeracodePath(build);
                    if (!remoteVeracodeFilePath.exists()) {
                        if (debug) {
                            ps.println("Making remote dir");
                        }
                        remoteVeracodeFilePath.mkdirs();
                    }
                    if ((files = remoteVeracodeFilePath.list("vosp-api-wrappers-java*.jar")).length == 0) {
                        bRet = FileUtil.copyJarFiles(build, localWorkspaceFilePath, remoteVeracodeFilePath, ps);
                    } else {
                        String oldjarName;
                        int oldVersion;
                        FilePath[] newfiles = localWorkspaceFilePath.list("vosp-api-wrappers-java*.jar");
                        String newjarName = newfiles[0].getRemote();
                        int newVersion = RemoteScanUtil.getJarVersion(newjarName);
                        if (newVersion > (oldVersion = RemoteScanUtil.getJarVersion(oldjarName = files[0].getRemote()))) {
                            if (debug) {
                                ps.println("Newer veracode library version, copying it to remote machine");
                            }
                            remoteVeracodeFilePath.deleteContents();
                            bRet = FileUtil.copyJarFiles(build, localWorkspaceFilePath, remoteVeracodeFilePath, ps);
                        } else {
                            String jarName = files[0].getRemote();
                            String newJarName = jarName.replaceAll("(vosp-api-wrappers).*?(.jar)", "VeracodeJavaAPI$2");
                            Node node = build.getBuiltOn();
                            if (node == null) {
                                ps.print("\r\n\r\nFailed to locate the build node.\r\n");
                                return !this.getDescriptor().getFailbuild();
                            }
                            FilePath newjarFilePath = new FilePath(node.getChannel(), newJarName);
                            if (newjarFilePath.exists()) {
                                bRet = true;
                            }
                        }
                    }
                    break block14;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (this.getDescriptor().getFailbuild()) {
                        ps.print(ex.getMessage());
                    }
                    break block14;
                }
            }
            bRet = true;
        }
        return bRet;
    }

    /*
     * Exception decompiling
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 65[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @DataBoundConstructor
    public VeracodeNotifier(String appname, boolean createprofile, String teams, String criticality, String sandboxname, boolean createsandbox, String version, String filenamepattern, String replacementpattern, String uploadincludespattern, String uploadexcludespattern, String scanincludespattern, String scanexcludespattern, boolean waitForScan, String timeout, String deleteIncompleteScan, CredentialsBlock credentials) {
        this._appname = appname;
        this._createprofile = createprofile;
        this._teams = teams;
        this._criticality = criticality;
        this._sandboxname = sandboxname;
        this._createsandbox = createsandbox;
        this._version = version;
        this._uploadincludespattern = uploadincludespattern;
        this._uploadexcludespattern = uploadexcludespattern;
        this._scanincludespattern = scanincludespattern;
        this._scanexcludespattern = scanexcludespattern;
        this._filenamepattern = filenamepattern;
        this._replacementpattern = replacementpattern;
        this._waitforscan = waitForScan;
        this._timeout = this._waitforscan ? FormValidationUtil.formatTimeout(timeout) : null;
        this.deleteIncompleteScan = deleteIncompleteScan;
        this._credentials = credentials;
    }

    private boolean runScanFromRemote(AbstractBuild<?, ?> build, BuildListener listener, PrintStream ps, boolean bDebug) throws IOException, InterruptedException {
        boolean bRet;
        block14: {
            bRet = false;
            EnvVars envar = build.getEnvironment((TaskListener)listener);
            UploadAndScanArgs.setEnvVars(envar, build.getDisplayName(), build.getProject().getDisplayName());
            String uploadincludePattern = envar.expand(this.getUploadincludespattern());
            String uploadexcludePattern = envar.expand(this.getUploadexcludespattern());
            Node node = build.getBuiltOn();
            if (node == null) {
                ps.print("\r\n\r\nFailed to locate the build node.\r\n");
                return !this.getDescriptor().getFailbuild();
            }
            FilePath remoteVeracodeFilePath = RemoteScanUtil.getRemoteVeracodePath(build);
            String jarFilePath = remoteVeracodeFilePath.getRemote();
            FilePath workspace = build.getWorkspace();
            if (workspace == null) {
                ps.print("\r\n\r\nFailed to locate the build workspace.\r\n");
                return !this.getDescriptor().getFailbuild();
            }
            String remoteworkspace = workspace.getRemote();
            String sep = RemoteScanUtil.getPathSeparator(remoteworkspace);
            FilePath remoteworkspaceFilePath = new FilePath(node.getChannel(), remoteworkspace);
            try {
                Proc proc;
                int retcode;
                String[] uploadAndScanFilePaths = FileUtil.getStringFilePaths(remoteworkspaceFilePath.list(uploadincludePattern, uploadexcludePattern));
                UploadAndScanArgs uploadAndScanArguments = UploadAndScanArgs.newUploadAndScanArgs(this, build, build.getEnvironment((TaskListener)listener), uploadAndScanFilePaths, true);
                String jarPath = jarFilePath + sep + "VeracodeJavaAPI" + ".jar";
                String cmd = "java -jar " + jarPath;
                String[] cmds = uploadAndScanArguments.getArguments();
                StringBuilder result = new StringBuilder();
                result.append(cmd);
                for (String _cmd : cmds) {
                    _cmd = RemoteScanUtil.formatParameterValue(_cmd);
                    result.append(" " + _cmd);
                }
                ArgumentListBuilder command = new ArgumentListBuilder();
                command.addTokenized(result.toString());
                List remoteCmd = command.toList();
                int iSize = remoteCmd.size();
                Integer[] iPos = RemoteScanUtil.getMaskPosition(remoteCmd);
                int iPosKey = iPos[0];
                int iPosProxyPassword = iPos[1];
                Launcher launcher = node.createLauncher((TaskListener)listener);
                Launcher.ProcStarter procStart = new Launcher.ProcStarter(launcher);
                boolean[] masks = new boolean[iSize];
                for (int i = 0; i < iSize; ++i) {
                    if (iPosKey != -1) {
                        if (iPosKey != i) continue;
                        masks[i] = true;
                        continue;
                    }
                    if (iPosProxyPassword != -1) {
                        if (iPosProxyPassword != i) continue;
                        masks[i] = true;
                        continue;
                    }
                    masks[i] = false;
                }
                procStart = procStart.pwd(workspace).cmds(command).masks(masks).stdout((TaskListener)listener).quiet(true);
                if (bDebug) {
                    procStart.quiet(false);
                    ps.print("\nInvoking the following command in remote workspace:\n");
                }
                if ((retcode = (proc = launcher.launch(procStart)).join()) != 0 && this.getDescriptor().getFailbuild()) {
                    ps.print("\r\n\r\nError- Returned code from wrapper:" + retcode + "\r\n\n");
                } else {
                    bRet = true;
                }
                try {
                    if (!this.getWaitForScan()) break block14;
                    if (4 == retcode || 0 == retcode) {
                        this.getScanResults(build, listener);
                        break block14;
                    }
                    build.addAction((Action)new VeracodeAction());
                }
                catch (Exception e) {
                    ps.println();
                    ps.println(String.format("Ran into problem when generating scan results in Jenkins. Error: [%s, %s]", e.getClass().getSimpleName(), e.getMessage()));
                    e.printStackTrace(ps);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!this.getDescriptor().getFailbuild()) break block14;
                ps.print(ex.getMessage());
            }
        }
        return bRet;
    }

    private void getScanResults(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String sandboxName;
        String key;
        String id;
        VeracodeDescriptor descriptor = this.getDescriptor();
        if (this.getCredentials() == null) {
            id = descriptor.getGvid();
            key = descriptor.getGvkey();
        } else {
            id = this.getVid();
            key = this.getVkey();
        }
        ProxyBlock proxy = null;
        if (descriptor.getProxy()) {
            proxy = new ProxyBlock(descriptor.getPhost(), descriptor.getPport(), descriptor.getPuser(), descriptor.getPpassword());
        }
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        UploadAndScanArgs.setEnvVars(envVars, build.getDisplayName(), build.getProject().getDisplayName());
        String appName = this.getAppname();
        if (!StringUtil.isNullOrEmpty(appName)) {
            appName = envVars.expand(appName);
        } else if (descriptor.getAutoappname()) {
            appName = (String)envVars.get((Object)"projectname");
        }
        if (!StringUtil.isNullOrEmpty(id)) {
            id = envVars.expand(id);
        }
        if (!StringUtil.isNullOrEmpty(key)) {
            key = envVars.expand(key);
        }
        if (!StringUtil.isNullOrEmpty(sandboxName = this.getSandboxname())) {
            sandboxName = envVars.expand(sandboxName);
        }
        try {
            String buildInfoXML = WrapperUtil.getBuildInfo(appName, sandboxName, id, key, proxy);
            String buildId = XmlUtil.parseBuildId(buildInfoXML);
            String detailedReportXML = WrapperUtil.getDetailedReport(buildId, id, key, proxy);
            ScanHistory scanHistory = XmlUtil.newScanHistory(buildInfoXML, detailedReportXML, build);
            Credentials credentials = Credentials.create((String)id, (String)key);
            String xmlApiHost = credentials.getRegion().getXmlApiHost();
            build.addAction((Action)new VeracodeAction(scanHistory, xmlApiHost));
        }
        catch (Exception e) {
            build.addAction((Action)new VeracodeAction());
            throw e;
        }
    }

    @Extension
    public static final class VeracodeDescriptor
    extends BuildStepDescriptor<Publisher> {
        private static final String PostBuildActionDisplayText = "Upload and Scan with Veracode";
        private static final String vidDisplayName = "API ID";
        private static final String vkeyDisplayName = "API Key";
        private static final String vidIHelpTextName = "ID";
        private static final String vkeyIHelpTextName = "key";
        private static final String appNameDisplayName = "Application Name";
        private static final String versionDisplayName = "Scan Name";
        private static final String filenamePatternDisplayName = "Filename Pattern";
        private static final String replacementPatternDisplayName = "Replacement Pattern";
        private static final String[] criticalityDisplayNames = new String[]{"Very High", "High", "Medium", "Low", "Very Low"};
        private static final String[] deleteIncompleteScanLevels = new String[]{"0", "1", "2"};
        private String gvid;
        private String gvkey;
        private String gvuser;
        private String gvpassword;
        private boolean failbuild = true;
        private boolean copyremotefiles;
        private boolean autoappname;
        private boolean autodescription;
        private boolean autoversion;
        private boolean debug;
        private boolean proxy;
        private String phost;
        private String pport;
        private String puser;
        private String ppassword;

        public String getGvid() {
            if (this.gvid != null) {
                return EncryptionUtil.decrypt(this.gvid);
            }
            return EncryptionUtil.decrypt(this.gvuser);
        }

        public String getGvkey() {
            if (this.gvkey != null) {
                return EncryptionUtil.decrypt(this.gvkey);
            }
            return EncryptionUtil.decrypt(this.gvpassword);
        }

        public boolean getFailbuild() {
            return this.failbuild;
        }

        public boolean getCopyremotefiles() {
            return this.copyremotefiles;
        }

        public boolean getAutoappname() {
            return this.autoappname;
        }

        public boolean getAutodescription() {
            return this.autodescription;
        }

        public boolean getAutoversion() {
            return this.autoversion;
        }

        public boolean getDebug() {
            return this.debug;
        }

        public boolean getProxy() {
            return this.proxy;
        }

        public String getPhost() {
            return EncryptionUtil.decrypt(this.phost);
        }

        public String getPport() {
            return EncryptionUtil.decrypt(this.pport);
        }

        public String getPuser() {
            return EncryptionUtil.decrypt(this.puser);
        }

        public String getPpassword() {
            return EncryptionUtil.decrypt(this.ppassword);
        }

        public FormValidation doTestConnection(@QueryParameter(value="gvid") String gv_id, @QueryParameter(value="gvkey") String gv_key, @QueryParameter(value="proxy") boolean _proxy, @QueryParameter(value="phost") String p_host, @QueryParameter(value="pport") String p_port, @QueryParameter(value="puser") String p_user, @QueryParameter(value="ppassword") String p_password) {
            return FormValidationUtil.checkConnection(gv_id, gv_key, _proxy ? new ProxyBlock(p_host, p_port, p_user, p_password) : null);
        }

        public FormValidation doCheckGvid(@QueryParameter(value="gvid") String gv_id, @QueryParameter(value="gvkey") String gv_key) throws IOException, ServletException {
            return FormValidationUtil.checkMutuallyInclusiveFields(gv_id, gv_key, vidDisplayName, vkeyDisplayName, vkeyIHelpTextName);
        }

        public FormValidation doCheckGvkey(@QueryParameter(value="gvid") String gv_id, @QueryParameter(value="gvkey") String gv_key) throws IOException, ServletException {
            return FormValidationUtil.checkMutuallyInclusiveFields(gv_key, gv_id, vkeyDisplayName, vidDisplayName, vidIHelpTextName);
        }

        public FormValidation doCheckVid(@QueryParameter(value="vid") String v_id, @QueryParameter(value="vkey") String v_key) throws IOException, ServletException {
            boolean hasJobCredentials = !StringUtil.isNullOrEmpty(v_id) && !StringUtil.isNullOrEmpty(v_key);
            boolean hasGlobalCredentials = this.hasGlobalCredentials();
            if (hasGlobalCredentials) {
                if (hasJobCredentials) {
                    return FormValidation.warning((String)"These Veracode API credentials override the global Veracode API credentials.");
                }
                if (!this.hasValidCredentials(v_id, v_key)) {
                    return FormValidationUtil.checkFields(v_id, v_key, vidDisplayName, vkeyDisplayName, vkeyIHelpTextName);
                }
                return FormValidationUtil.checkMutuallyInclusiveFields(v_id, v_key, vidDisplayName, vkeyDisplayName, vkeyIHelpTextName);
            }
            return FormValidationUtil.checkFields(v_id, v_key, vidDisplayName, vkeyDisplayName, vkeyIHelpTextName);
        }

        public FormValidation doCheckVkey(@QueryParameter(value="vid") String v_id, @QueryParameter(value="vkey") String v_key) throws IOException, ServletException {
            boolean hasJobCredentials = !StringUtil.isNullOrEmpty(v_id) && !StringUtil.isNullOrEmpty(v_key);
            boolean hasGlobalCredentials = this.hasGlobalCredentials();
            if (hasGlobalCredentials) {
                if (hasJobCredentials) {
                    return FormValidation.warning((String)"These Veracode API credentials override the global Veracode API credentials.");
                }
                if (!this.hasValidCredentials(v_id, v_key)) {
                    return FormValidationUtil.checkFields(v_key, v_id, vkeyDisplayName, vidDisplayName, vidIHelpTextName);
                }
                return FormValidationUtil.checkMutuallyInclusiveFields(v_key, v_id, vkeyDisplayName, vidDisplayName, vidIHelpTextName);
            }
            return FormValidationUtil.checkFields(v_key, v_id, vkeyDisplayName, vidDisplayName, vidIHelpTextName);
        }

        public FormValidation doCheckAppname(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtil.isNullOrEmpty(value) && !this.getAutoappname()) {
                return FormValidation.error((String)String.format("%s is required.", appNameDisplayName));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersion(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtil.isNullOrEmpty(value) && !this.getAutoversion()) {
                return FormValidation.error((String)String.format("%s is required.", versionDisplayName));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFilenamepattern(@QueryParameter(value="filenamepattern") String filename_pattern, @QueryParameter(value="replacementpattern") String replacement_pattern) throws IOException, ServletException {
            return FormValidationUtil.checkMutuallyInclusiveFields(filename_pattern, replacement_pattern, filenamePatternDisplayName, replacementPatternDisplayName, null);
        }

        public FormValidation doCheckReplacementpattern(@QueryParameter(value="filenamepattern") String filename_pattern, @QueryParameter(value="replacementpattern") String replacement_pattern) throws IOException, ServletException {
            return FormValidationUtil.checkMutuallyInclusiveFields(replacement_pattern, filename_pattern, replacementPatternDisplayName, filenamePatternDisplayName, null);
        }

        public FormValidation doCheckTimeout(@QueryParameter(value="timeout") String timeout) {
            if (!StringUtil.isNullOrEmpty(timeout)) {
                try {
                    Integer.parseInt(timeout);
                }
                catch (NumberFormatException nfe) {
                    return FormValidation.error((String)String.format("%s is not a valid number.", timeout));
                }
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCriticalityItems(@QueryParameter(value="criticality") String criticality) {
            ListBoxModel items = new ListBoxModel();
            for (String s : criticalityDisplayNames) {
                items.add((Object)new ListBoxModel.Option(s, s.replace(" ", ""), s.replace(" ", "").equals(criticality)));
            }
            return items;
        }

        public ListBoxModel doFillDeleteIncompleteScanItems(@QueryParameter(value="deleteIncompleteScan") String deleteIncompleteScan) {
            ListBoxModel items = new ListBoxModel();
            for (String level : deleteIncompleteScanLevels) {
                items.add((Object)new ListBoxModel.Option(level, level, level.equals(deleteIncompleteScan)));
            }
            return items;
        }

        public String getDisplayName() {
            return VeracodeDescriptor.getPostBuildActionDisplayText();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Map credMap = (Map)formData.get("credentials");
            if (credMap != null) {
                credMap.put("vid", EncryptionUtil.encrypt((String)credMap.get("vid")));
                credMap.put("vkey", EncryptionUtil.encrypt((String)credMap.get("vkey")));
                formData.put("credentials", (Object)credMap);
            }
            return (Publisher)super.newInstance(req, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            try {
                EncryptionUtil.encrypt(req, formData);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
            try {
                this.initInstanceFields(formData);
                this.saveSensitiveFormFields(req);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.save();
            return super.configure(req, formData);
        }

        public boolean hasGlobalCredentials() {
            return !StringUtil.isNullOrEmpty(this.getGvid()) && !StringUtil.isNullOrEmpty(this.getGvkey());
        }

        private void initInstanceFields(JSONObject formData) {
            this.gvid = formData.getString("gvid");
            this.gvkey = formData.getString("gvkey");
            this.gvuser = formData.containsKey((Object)"gvuser") ? formData.getString("gvuser") : null;
            this.gvpassword = formData.containsKey((Object)"gvpassword") ? formData.getString("gvpassword") : null;
            this.failbuild = formData.getBoolean("failbuild");
            this.copyremotefiles = formData.getBoolean("copyremotefiles");
            this.autoappname = formData.getBoolean("autoappname");
            this.autodescription = formData.getBoolean("autodescription");
            this.autoversion = formData.getBoolean("autoversion");
            this.debug = formData.getBoolean("debug");
            this.proxy = formData.getBoolean("proxy");
            this.phost = formData.getString("phost");
            this.pport = formData.getString("pport");
            this.puser = formData.getString("puser");
            this.ppassword = formData.getString("ppassword");
        }

        private void saveSensitiveFormFields(StaplerRequest req) throws ServletException {
            req.getSubmittedForm().put("gvkey", (Object)this.gvkey);
            req.getSubmittedForm().put("gvid", (Object)this.gvid);
            req.getSubmittedForm().put("ppassword", (Object)this.ppassword);
            req.getSubmittedForm().put("puser", (Object)this.puser);
            req.getSubmittedForm().put("pport", (Object)this.pport);
            req.getSubmittedForm().put("phost", (Object)this.phost);
        }

        public boolean hasValidCredentials(String id, String key) {
            return !StringUtil.isNullOrEmpty(id) && StringUtil.isNullOrEmpty(key);
        }

        public VeracodeDescriptor() {
            super(VeracodeNotifier.class);
            this.load();
        }

        public static String getPostBuildActionDisplayText() {
            return PostBuildActionDisplayText;
        }
    }
}

