/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.jenkins.plugin.VeracodeNotifier;
import com.veracode.jenkins.plugin.common.DAAdapterService;
import com.veracode.jenkins.plugin.data.CredentialsBlock;
import com.veracode.jenkins.plugin.data.ProxyBlock;
import com.veracode.jenkins.plugin.utils.EncryptionUtil;
import com.veracode.jenkins.plugin.utils.FormValidationUtil;
import com.veracode.jenkins.plugin.utils.StringUtil;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DynamicAnalysisStartNotifier
extends Notifier {
    private final String analysisName;
    private final int maximumDuration;
    private final boolean failBuildAsScanFailed;
    private final CredentialsBlock credentials;
    private boolean isGlobalCredentialsEnabled;

    @DataBoundConstructor
    public DynamicAnalysisStartNotifier(String analysisName, int maximumDuration, boolean failBuildAsScanFailed, CredentialsBlock credentials) {
        this.analysisName = analysisName;
        this.maximumDuration = maximumDuration;
        this.failBuildAsScanFailed = failBuildAsScanFailed;
        this.credentials = credentials;
        this.isGlobalCredentialsEnabled = credentials == null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        DynamicAnalysisStartDescriptor descriptor = this.getDescriptor();
        descriptor.updateFromGlobalConfiguration();
        String apiID = this.getCredentials() != null ? this.getVid() : descriptor.getGvid();
        String apiKey = this.getCredentials() != null ? this.getVkey() : descriptor.getGvkey();
        ProxyBlock proxyBlock = null;
        if (descriptor.isProxyEnabled()) {
            proxyBlock = new ProxyBlock(descriptor.getPhost(), descriptor.getPport(), descriptor.getPuser(), descriptor.getPpassword());
        }
        DAAdapterService daAdapterService = new DAAdapterService();
        return daAdapterService.resubmitDynamicAnalysis((Run<?, ?>)build, build.getWorkspace(), (TaskListener)listener, this.getAnalysisName(), this.getMaximumDuration(), this.isFailBuildAsScanFailed(), apiID, apiKey, descriptor.isDebugEnabled(), proxyBlock);
    }

    public DynamicAnalysisStartDescriptor getDescriptor() {
        return (DynamicAnalysisStartDescriptor)super.getDescriptor();
    }

    public String getAnalysisName() {
        return EncryptionUtil.decrypt(this.analysisName);
    }

    public int getMaximumDuration() {
        return this.maximumDuration;
    }

    public boolean isFailBuildAsScanFailed() {
        return this.failBuildAsScanFailed;
    }

    public boolean isGlobalCredentialsEnabled() {
        return this.isGlobalCredentialsEnabled;
    }

    public CredentialsBlock getCredentials() {
        return this.credentials;
    }

    public String getVid() {
        return EncryptionUtil.decrypt(this.credentials != null ? this.credentials.getVid() : null);
    }

    public String getVkey() {
        return EncryptionUtil.decrypt(this.credentials != null ? this.credentials.getVkey() : null);
    }

    @Extension
    public static class DynamicAnalysisStartDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String gvid;
        private String gvkey;
        private boolean debugEnabled;
        private boolean proxyEnabled;
        private String phost;
        private String pport;
        private String puser;
        private String ppassword;

        public DynamicAnalysisStartDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return "Resubmit Veracode Dynamic Analysis";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String maximumDuration = formData.getString("maximumDuration");
            formData.put("maximumDuration", StringUtil.isNullOrEmpty(maximumDuration) ? Integer.valueOf(72) : maximumDuration);
            Map credMap = (Map)formData.get("credentials");
            if (credMap != null) {
                credMap.put("vid", EncryptionUtil.encrypt((String)credMap.get("vid")));
                credMap.put("vkey", EncryptionUtil.encrypt((String)credMap.get("vkey")));
                formData.put("credentials", (Object)credMap);
            }
            return (Publisher)super.newInstance(req, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.updateFromGlobalConfiguration();
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckAnalysisName(@QueryParameter String analysisName) throws IOException, ServletException {
            return FormValidationUtil.checkAnalysisName(analysisName);
        }

        public FormValidation doCheckMaximumDuration(@QueryParameter String maximumDuration) throws IOException, ServletException {
            return FormValidationUtil.checkMaximumDuration(maximumDuration);
        }

        public FormValidation doCheckVid(@QueryParameter(value="vid") String vid, @QueryParameter(value="vkey") String vkey) throws IOException, ServletException {
            return FormValidationUtil.checkApiId(vid, vkey, this.hasGlobalApiIdKeyCredentials());
        }

        public FormValidation doCheckVkey(@QueryParameter(value="vid") String vid, @QueryParameter(value="vkey") String vkey) throws IOException, ServletException {
            return FormValidationUtil.checkApiKey(vid, vkey, this.hasGlobalApiIdKeyCredentials());
        }

        private void updateFromGlobalConfiguration() {
            VeracodeNotifier.VeracodeDescriptor globalVeracodeDescriptor = (VeracodeNotifier.VeracodeDescriptor)Jenkins.getInstance().getDescriptor(VeracodeNotifier.class);
            if (globalVeracodeDescriptor != null) {
                this.gvid = globalVeracodeDescriptor.getGvid();
                this.gvkey = globalVeracodeDescriptor.getGvkey();
                this.debugEnabled = globalVeracodeDescriptor.getDebug();
                this.proxyEnabled = globalVeracodeDescriptor.getProxy();
                this.phost = globalVeracodeDescriptor.getPhost();
                this.pport = globalVeracodeDescriptor.getPport();
                this.puser = globalVeracodeDescriptor.getPuser();
                this.ppassword = globalVeracodeDescriptor.getPpassword();
            }
        }

        public String getGvid() {
            return this.gvid;
        }

        public String getGvkey() {
            return this.gvkey;
        }

        public boolean isDebugEnabled() {
            return this.debugEnabled;
        }

        public boolean isProxyEnabled() {
            return this.proxyEnabled;
        }

        public String getPhost() {
            return this.phost;
        }

        public String getPport() {
            return this.pport;
        }

        public String getPuser() {
            return this.puser;
        }

        public String getPpassword() {
            return this.ppassword;
        }

        public boolean hasGlobalApiIdKeyCredentials() {
            return !StringUtil.isNullOrEmpty(this.getGvid()) && !StringUtil.isNullOrEmpty(this.getGvkey());
        }
    }
}

