/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.util.http;

import com.veracode.util.http.ClientHttpRequest;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class WebClient {
    private URLConnection connection;
    public Proxy proxy;
    public Map<String, String> headers = new HashMap<String, String>();
    public Map<String, Object> queryString = new HashMap<String, Object>();

    public String downloadString(String uriString) throws IOException {
        URL url = new URL(uriString);
        this.setUpURLConnection(url);
        return this.consumeResponse();
    }

    public String uploadFile(String uriString, String filePath) throws IOException {
        URL url = new URL(uriString);
        this.setUpURLConnection(url);
        this.addFile(filePath);
        return this.consumeResponse();
    }

    public String downloadDataString(String uriString) throws IOException {
        URL url = new URL(String.valueOf(uriString) + this.getURLEncodedQueryString());
        this.setUpURLConnection(url);
        return new String(this.consumeResponseBytes(), "UTF-8");
    }

    public byte[] downloadData(String uriString) throws IOException {
        URL url = new URL(String.valueOf(uriString) + this.getURLEncodedQueryString());
        this.setUpURLConnection(url);
        return this.consumeResponseBytes();
    }

    public void setProxy(String host, int port, final String username, final String password) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        if (username != null && password != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
    }

    protected void setUpURLConnection(URL url) throws IOException {
        this.connection = this.proxy != null ? url.openConnection(this.proxy) : url.openConnection();
        if (this.headers != null && this.headers.size() > 0) {
            for (Map.Entry<String, String> pair : this.headers.entrySet()) {
                String key = pair.getKey();
                String value = pair.getValue();
                if (key == null || value == null) continue;
                this.connection.setRequestProperty(key, value);
            }
        }
    }

    protected void addFile(String filePath) {
        if (this.queryString != null && filePath != null) {
            this.queryString.put("file", new File(filePath));
        }
    }

    protected String getURLEncodedQueryString() {
        String urlQueryString = "";
        if (this.queryString != null && this.queryString.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, Object> pair : this.queryString.entrySet()) {
                String key = pair.getKey();
                String value = (String)pair.getValue();
                if (key == null || value == null) continue;
                builder.append(builder.length() == 0 ? (char)'?' : '&');
                builder.append(String.valueOf(key) + "=" + this.urlEncode(value));
            }
            urlQueryString = builder.toString();
        }
        return urlQueryString;
    }

    protected String urlEncode(String urlParam) {
        String encoded = "";
        try {
            encoded = URLEncoder.encode(urlParam, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encoded;
    }

    protected String consumeResponse() throws IOException {
        try (InputStream is = null;){
            is = ClientHttpRequest.post(this.connection, this.queryString);
            String string = this.consumeResponse(is);
            return string;
        }
    }

    protected String consumeResponse(InputStream is) throws IOException {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            String current = null;
            while ((current = reader.readLine()) != null) {
                builder.append(String.valueOf(current) + "\n");
            }
            String string = builder.toString();
            return string;
        }
    }

    protected byte[] consumeResponseBytes() throws IOException {
        try (InputStream is = null;){
            is = this.connection.getInputStream();
            byte[] byArray = this.consumeResponseBytes(is);
            return byArray;
        }
    }

    protected byte[] consumeResponseBytes(InputStream is) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] bytes = new byte[16384];
        int x = 0;
        while ((x = is.read(bytes, 0, bytes.length)) != -1) {
            stream.write(bytes, 0, x);
        }
        stream.flush();
        return stream.toByteArray();
    }
}

