/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser.util;

public final class StringUtility {
    public static final String EMPTY = "";
    public static final String NEWLINE = "\r\n";

    public static boolean isNullOrEmpty(String input) {
        return input == null || EMPTY.equals(input);
    }

    public static String getNullIfEmpty(String input) {
        return EMPTY.equals(input) ? null : input;
    }

    public static String repeatChar(char character, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be non-negative");
        }
        char[] c = new char[count];
        int x = 0;
        while (x < count) {
            c[x] = character;
            ++x;
        }
        return new String(c);
    }

    public static String padRight(String input, int totalWidth) {
        if (totalWidth < 0) {
            throw new IllegalArgumentException("Total Width must be non-negative.");
        }
        if (totalWidth == 0) {
            return input;
        }
        String format = String.format("%%%ds", -totalWidth);
        return String.format(format, input);
    }

    public static String padLeft(String input, int totalWidth) {
        if (totalWidth < 0) {
            throw new IllegalArgumentException("Total Width must be non-negative.");
        }
        if (totalWidth == 0) {
            return input;
        }
        String format = String.format("%%%ds", totalWidth);
        return String.format(format, input);
    }

    public static int compare(String str1, String str2, boolean ignoreCase) {
        int result = 0;
        if (str1 != null) {
            result = str2 != null ? (ignoreCase ? str1.compareToIgnoreCase(str2) : str1.compareTo(str2)) : 1;
        } else if (str2 != null) {
            result = -1;
        }
        return result;
    }

    public static String join(String separator, String[] value) {
        if (value != null) {
            if (separator == null) {
                separator = EMPTY;
            }
            boolean addSeparator = false;
            StringBuilder builder = new StringBuilder();
            String[] stringArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (addSeparator) {
                    builder.append(separator);
                }
                if (s != null) {
                    builder.append(s);
                }
                addSeparator = true;
                ++n2;
            }
            return builder.toString();
        }
        throw new IllegalArgumentException("Attempted to join the elements of a null String array.");
    }

    public static byte[] getBytes(String input, String charSet) {
        byte[] bytes = null;
        if (input != null) {
            try {
                bytes = input.getBytes(charSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bytes;
    }

    private StringUtility() {
    }
}

