/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser.core;

import com.veracode.parser.CommandLineParserSettings;
import com.veracode.parser.annotations.Option;
import com.veracode.parser.core.AttributeMemberPair;
import com.veracode.parser.core.OptionInfo;
import com.veracode.parser.exceptions.ParseException;
import com.veracode.parser.options.CommandLineOptionsBase;
import com.veracode.parser.util.ReflectionUtil;
import com.veracode.parser.util.StringUtility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;

final class OptionInfoMap {
    private CommandLineOptionsBase _options;
    private CommandLineParserSettings _settings;
    private Hashtable<String, String> _nameMap;
    private Hashtable<String, OptionInfo> _nameOptionInfoMap;

    public CommandLineOptionsBase getOptions() {
        return this._options;
    }

    public void setOptions(CommandLineOptionsBase options) {
        this._options = options;
    }

    public CommandLineParserSettings getSettings() {
        return this._settings;
    }

    public void setSettings(CommandLineParserSettings settings) {
        this._settings = settings;
    }

    public Hashtable<String, String> getNameMap() {
        return this._nameMap;
    }

    public void setNameMap(Hashtable<String, String> nameMap) {
        this._nameMap = nameMap;
    }

    public Hashtable<String, OptionInfo> getNameOptionInfoMap() {
        return this._nameOptionInfoMap;
    }

    public void setNameOptionInfoMap(Hashtable<String, OptionInfo> nameOptionInfoMap) {
        this._nameOptionInfoMap = nameOptionInfoMap;
    }

    public OptionInfo get(String key) {
        OptionInfo option = null;
        if (this._nameOptionInfoMap.containsKey(key)) {
            option = this._nameOptionInfoMap.get(key);
        } else if (this._nameMap.containsKey(key)) {
            String optionKey = this._nameMap.get(key);
            option = this._nameOptionInfoMap.get(optionKey);
        }
        return option;
    }

    public void set(String key, OptionInfo value) {
        this._nameOptionInfoMap.put(key, value);
        if (value.hasBothNames()) {
            this._nameMap.put(value.getLongName(), value.getShortName());
        }
    }

    private void preInitialize() {
        for (OptionInfo option : this._nameOptionInfoMap.values()) {
            option.preInitialize();
        }
    }

    private OptionInfoMap(CommandLineOptionsBase options, CommandLineParserSettings settings, int capacity) {
        if (settings == null) {
            throw new ParseException(new IllegalArgumentException("Settings is mandatory.\r\nParameter name: settings"));
        }
        this._options = options;
        this._settings = settings;
        this._nameMap = new Hashtable(capacity);
        this._nameOptionInfoMap = new Hashtable(capacity * 2);
    }

    static OptionInfoMap createMap(CommandLineOptionsBase options, CommandLineParserSettings settings) {
        OptionInfoMap optionsMap = OptionInfoMap.createFieldsMap(options, settings);
        if (optionsMap != null) {
            optionsMap.preInitialize();
        }
        return optionsMap;
    }

    private static OptionInfoMap createFieldsMap(CommandLineOptionsBase options, CommandLineParserSettings settings) {
        ArrayList<AttributeMemberPair<Option, Field>> list = ReflectionUtil.retrieveMemberList(options);
        if (list != null) {
            OptionInfoMap optionsMap = new OptionInfoMap(options, settings, list.size());
            for (AttributeMemberPair<Option, Field> pair : list) {
                if (pair == null || pair.getLeft() == null) continue;
                String uniqueName = null;
                if (!StringUtility.isNullOrEmpty(pair.getLeft().shortName())) {
                    uniqueName = pair.getLeft().shortName();
                } else if (!StringUtility.isNullOrEmpty(pair.getLeft().longName())) {
                    uniqueName = pair.getLeft().longName();
                }
                if (uniqueName == null) {
                    throw new ParseException("Invalid Operation.");
                }
                optionsMap.set(uniqueName, new OptionInfo(options, pair.getLeft(), pair.getRight()));
            }
            return optionsMap;
        }
        return null;
    }
}

