/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.wrappers;

import com.veracode.apiwrapper.AbstractAPIWrapper;
import com.veracode.util.http.HttpUtility;
import java.io.IOException;
import java.util.HashMap;

public final class UploadAPIWrapper
extends AbstractAPIWrapper {
    private static final String BEGIN_PRESCAN_URI = "https://analysiscenter.veracode.com/api/4.0/beginprescan.do";
    private static final String BEGIN_SCAN_URI = "https://analysiscenter.veracode.com/api/4.0/beginscan.do";
    private static final String CREATE_APP_URI = "https://analysiscenter.veracode.com/api/4.0/createapp.do";
    private static final String CREATE_BUILD_URI = "https://analysiscenter.veracode.com/api/4.0/createbuild.do";
    private static final String DELETE_APP_URI = "https://analysiscenter.veracode.com/api/4.0/deleteapp.do";
    private static final String DELETE_BUILD_URI = "https://analysiscenter.veracode.com/api/4.0/deletebuild.do";
    private static final String GET_APP_INFO_URI = "https://analysiscenter.veracode.com/api/4.0/getappinfo.do";
    private static final String GET_APP_LIST_URI = "https://analysiscenter.veracode.com/api/4.0/getapplist.do";
    private static final String GET_BUILD_INFO_URI = "https://analysiscenter.veracode.com/api/4.0/getbuildinfo.do";
    private static final String GET_BUILD_LIST_URI = "https://analysiscenter.veracode.com/api/4.0/getbuildlist.do";
    private static final String GET_FILE_LIST_URI = "https://analysiscenter.veracode.com/api/4.0/getfilelist.do";
    private static final String GET_POLICY_LIST_URI = "https://analysiscenter.veracode.com/api/4.0/getpolicylist.do";
    private static final String GET_PRESCAN_RESULTS_URI = "https://analysiscenter.veracode.com/api/4.0/getprescanresults.do";
    private static final String GET_VENDOR_LIST_URI = "https://analysiscenter.veracode.com/api/4.0/getvendorlist.do";
    private static final String REMOVE_FILE_URI = "https://analysiscenter.veracode.com/api/4.0/removefile.do";
    private static final String UPDATE_APP_URI = "https://analysiscenter.veracode.com/api/4.0/updateapp.do";
    private static final String UPDATE_BUILD_URI = "https://analysiscenter.veracode.com/api/4.0/updatebuild.do";
    private static final String UPLOAD_FILE_URI = "https://analysiscenter.veracode.com/api/4.0/uploadfile.do";

    public String beginPreScan(String app_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(BEGIN_PRESCAN_URI);
    }

    public String beginScan(String app_id, String modules, String scan_all_top_level_modules) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (modules != null) {
            queryString.put("modules", HttpUtility.urlEncode(modules));
        }
        if (scan_all_top_level_modules != null) {
            queryString.put("scan_all_top_level_modules", HttpUtility.urlEncode(scan_all_top_level_modules));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(BEGIN_SCAN_URI);
    }

    public String createApp(String app_name, String business_criticality) throws IOException {
        return this.createApp(app_name, null, null, business_criticality, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public String createApp(String app_name, String description, String vendor_id, String business_criticality, String policy, String business_unit, String business_owner, String business_owner_email, String teams, String origin, String industry, String app_type, String deployment_type, String web_application, String archer_app_name, String tags) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_name != null) {
            queryString.put("app_name", HttpUtility.urlEncode(app_name));
        }
        if (description != null) {
            queryString.put("description", HttpUtility.urlEncode(description));
        }
        if (vendor_id != null) {
            queryString.put("vendor_id", HttpUtility.urlEncode(vendor_id));
        }
        if (business_criticality != null) {
            queryString.put("business_criticality", HttpUtility.urlEncode(business_criticality));
        }
        if (policy != null) {
            queryString.put("policy", HttpUtility.urlEncode(policy));
        }
        if (business_unit != null) {
            queryString.put("business_unit", HttpUtility.urlEncode(business_unit));
        }
        if (business_owner != null) {
            queryString.put("business_owner", HttpUtility.urlEncode(business_owner));
        }
        if (business_owner_email != null) {
            queryString.put("business_owner_email", HttpUtility.urlEncode(business_owner_email));
        }
        if (teams != null) {
            queryString.put("teams", HttpUtility.urlEncode(teams));
        }
        if (origin != null) {
            queryString.put("origin", HttpUtility.urlEncode(origin));
        }
        if (industry != null) {
            queryString.put("industry", HttpUtility.urlEncode(industry));
        }
        if (app_type != null) {
            queryString.put("app_type", HttpUtility.urlEncode(app_type));
        }
        if (deployment_type != null) {
            queryString.put("deployment_type", HttpUtility.urlEncode(deployment_type));
        }
        if (web_application != null) {
            queryString.put("web_application", HttpUtility.urlEncode(web_application));
        }
        if (archer_app_name != null) {
            queryString.put("archer_app_name", HttpUtility.urlEncode(archer_app_name));
        }
        if (tags != null) {
            queryString.put("tags", HttpUtility.urlEncode(tags));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(CREATE_APP_URI);
    }

    public String createBuild(String app_id, String version) throws IOException {
        return this.createBuild(app_id, version, null, null, null, null, null);
    }

    public String createBuild(String app_id, String version, String platform, String platform_id, String lifecycle_stage, String lifecycle_stage_id, String launch_date) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (version != null) {
            queryString.put("version", HttpUtility.urlEncode(version));
        }
        if (platform != null) {
            queryString.put("platform", HttpUtility.urlEncode(platform));
        }
        if (platform_id != null) {
            queryString.put("platform_id", HttpUtility.urlEncode(platform_id));
        }
        if (lifecycle_stage != null) {
            queryString.put("lifecycle_stage", HttpUtility.urlEncode(lifecycle_stage));
        }
        if (lifecycle_stage_id != null) {
            queryString.put("lifecycle_stage_id", HttpUtility.urlEncode(lifecycle_stage_id));
        }
        if (launch_date != null) {
            queryString.put("launch_date", HttpUtility.urlEncode(launch_date));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(CREATE_BUILD_URI);
    }

    public String deleteApp(String app_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(DELETE_APP_URI);
    }

    public String deleteBuild(String app_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(DELETE_BUILD_URI);
    }

    public String getAppInfo(String app_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_APP_INFO_URI);
    }

    public String getAppList() throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_APP_LIST_URI);
    }

    public String getBuildInfo(String app_id) throws IOException {
        return this.getBuildInfo(app_id, null);
    }

    public String getBuildInfo(String app_id, String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_BUILD_INFO_URI);
    }

    public String getBuildList(String app_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_BUILD_LIST_URI);
    }

    public String getFileList(String app_id) throws IOException {
        return this.getFileList(app_id, null);
    }

    public String getFileList(String app_id, String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_FILE_LIST_URI);
    }

    public String getPolicyList() throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_POLICY_LIST_URI);
    }

    public String getPreScanResults(String app_id) throws IOException {
        return this.getPreScanResults(app_id, null);
    }

    public String getPreScanResults(String app_id, String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_PRESCAN_RESULTS_URI);
    }

    public String getVendorList() throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_VENDOR_LIST_URI);
    }

    public String removeFile(String app_id, String file_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (file_id != null) {
            queryString.put("file_id", HttpUtility.urlEncode(file_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(REMOVE_FILE_URI);
    }

    public String updateApp(String app_id, String business_criticality) throws IOException {
        return this.updateApp(app_id, null, null, business_criticality, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public String updateApp(String app_id, String app_name, String description, String business_criticality, String policy, String business_unit, String business_owner, String business_owner_email, String teams, String origin, String industry, String app_type, String deployment_type, String archer_app_name, String tags, String custom_field_name, String custom_field_value) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (app_name != null) {
            queryString.put("app_name", HttpUtility.urlEncode(app_name));
        }
        if (description != null) {
            queryString.put("description", HttpUtility.urlEncode(description));
        }
        if (business_criticality != null) {
            queryString.put("business_criticality", HttpUtility.urlEncode(business_criticality));
        }
        if (policy != null) {
            queryString.put("policy", HttpUtility.urlEncode(policy));
        }
        if (business_unit != null) {
            queryString.put("business_unit", HttpUtility.urlEncode(business_unit));
        }
        if (business_owner != null) {
            queryString.put("business_owner", HttpUtility.urlEncode(business_owner));
        }
        if (business_owner_email != null) {
            queryString.put("business_owner_email", HttpUtility.urlEncode(business_owner_email));
        }
        if (teams != null) {
            queryString.put("teams", HttpUtility.urlEncode(teams));
        }
        if (origin != null) {
            queryString.put("origin", HttpUtility.urlEncode(origin));
        }
        if (industry != null) {
            queryString.put("industry", HttpUtility.urlEncode(industry));
        }
        if (app_type != null) {
            queryString.put("app_type", HttpUtility.urlEncode(app_type));
        }
        if (deployment_type != null) {
            queryString.put("deployment_type", HttpUtility.urlEncode(deployment_type));
        }
        if (archer_app_name != null) {
            queryString.put("archer_app_name", HttpUtility.urlEncode(archer_app_name));
        }
        if (tags != null) {
            queryString.put("tags", HttpUtility.urlEncode(tags));
        }
        if (custom_field_name != null) {
            queryString.put("custom_field_name", HttpUtility.urlEncode(custom_field_name));
        }
        if (custom_field_value != null) {
            queryString.put("custom_field_value", HttpUtility.urlEncode(custom_field_value));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(UPDATE_APP_URI);
    }

    public String updateBuild(String app_id) throws IOException {
        return this.updateBuild(app_id, null, null, null, null);
    }

    public String updateBuild(String app_id, String build_id, String version, String lifecycle_stage, String launch_date) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        if (version != null) {
            queryString.put("version", HttpUtility.urlEncode(version));
        }
        if (lifecycle_stage != null) {
            queryString.put("lifecycle_stage", HttpUtility.urlEncode(lifecycle_stage));
        }
        if (launch_date != null) {
            queryString.put("launch_date", HttpUtility.urlEncode(launch_date));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(UPDATE_BUILD_URI);
    }

    public String uploadFile(String app_id, String file) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.uploadFile(UPLOAD_FILE_URI, file);
    }

    String uploadFileAsync(String app_id, String file) throws IOException {
        return this.uploadFile(app_id, file);
    }
}

