/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.cli;

import com.veracode.apiwrapper.AbstractAPIWrapper;
import com.veracode.apiwrapper.wrappers.AdminAPIWrapper;
import com.veracode.apiwrapper.wrappers.ArcherAPIWrapper;
import com.veracode.apiwrapper.wrappers.MitigationAPIWrapper;
import com.veracode.apiwrapper.wrappers.ResultsAPIWrapper;
import com.veracode.apiwrapper.wrappers.UploadAPIWrapper;
import com.veracode.parser.CommandLineParser;
import com.veracode.parser.CommandLineParserSettings;
import com.veracode.parser.annotations.Option;
import com.veracode.parser.exceptions.ParseException;
import com.veracode.parser.options.CommandLineOptionsBase;
import com.veracode.util.lang.StringUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class VeracodeCommand {
    private static PrintStream logWriter;

    private static String beginPreScan(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.beginPreScan(options._app_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String beginScan(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.beginScan(options._app_id, options._modules, APICallText.Reader.toString(options._scan_all_top_level_modules));
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String createApp(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.createApp(options._app_name, options._description, options._vendor_id, APICallText.Reader.toString(options._business_criticality), options._policy, options._business_unit, options._business_owner, options._business_owner_email, options._teams, APICallText.Reader.toString(options._origin), APICallText.Reader.toString(options._industry), APICallText.Reader.toString(options._app_type), APICallText.Reader.toString(options._deployment_type), APICallText.Reader.toString(options._web_application), options._archer_app_name, options._tags);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String createBuild(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.createBuild(options._app_id, options._version, APICallText.Reader.toString(options._platform), options._platform_id, APICallText.Reader.toString(options._lifecycle_stage), options._lifecycle_stage_id, options._launch_date);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String deleteApp(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.deleteApp(options._app_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String deleteBuild(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.deleteBuild(options._app_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getAppInfo(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.getAppInfo(options._app_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getAppList(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.getAppList();
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getBuildInfo(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.getBuildInfo(options._app_id, options._build_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getBuildList(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.getBuildList(options._app_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getFileList(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.getFileList(options._app_id, options._build_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getPolicyList(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.getPolicyList();
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getPreScanResults(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.getPreScanResults(options._app_id, options._build_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getVendorList(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.getVendorList();
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String removeFile(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.removeFile(options._app_id, options._file_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String updateApp(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.updateApp(options._app_id, options._app_name, options._description, APICallText.Reader.toString(options._business_criticality), options._policy, options._business_unit, options._business_owner, options._business_owner_email, options._teams, APICallText.Reader.toString(options._origin), APICallText.Reader.toString(options._industry), APICallText.Reader.toString(options._app_type), APICallText.Reader.toString(options._deployment_type), options._archer_app_name, options._tags, options._custom_field_name, options._custom_field_value);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String updateBuild(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.updateBuild(options._app_id, options._build_id, options._version, APICallText.Reader.toString(options._lifecycle_stage), options._launch_date);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String uploadFile(Options options, boolean printReport) throws Exception {
        UploadAPIWrapper uploadAPIWrapper = VeracodeCommand.getUploadAPIWrapper(options);
        String result = uploadAPIWrapper.uploadFile(options._app_id, options._file[0].toString());
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String detailedReport(Options options, boolean printReport) throws Exception {
        ResultsAPIWrapper resultsAPIWrapper = VeracodeCommand.getResultsAPIWrapper(options);
        String result = resultsAPIWrapper.detailedReport(options._build_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static byte[] detailedReportPdf(Options options, boolean printReport) throws Exception {
        ResultsAPIWrapper resultsAPIWrapper = VeracodeCommand.getResultsAPIWrapper(options);
        byte[] result = resultsAPIWrapper.detailedReportPdf(options._build_id);
        if (printReport) {
            VeracodeCommand.printReport(result, options);
        }
        return result;
    }

    private static String getAppBuilds(Options options, boolean printReport) throws Exception {
        ResultsAPIWrapper resultsAPIWrapper = VeracodeCommand.getResultsAPIWrapper(options);
        String result = resultsAPIWrapper.getAppBuilds();
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getCallStacks(Options options, boolean printReport) throws Exception {
        ResultsAPIWrapper resultsAPIWrapper = VeracodeCommand.getResultsAPIWrapper(options);
        String result = resultsAPIWrapper.getCallStacks(options._build_id, options._flaw_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String summaryReport(Options options, boolean printReport) throws Exception {
        ResultsAPIWrapper resultsAPIWrapper = VeracodeCommand.getResultsAPIWrapper(options);
        String result = resultsAPIWrapper.summaryReport(options._build_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static byte[] summaryReportPdf(Options options, boolean printReport) throws Exception {
        ResultsAPIWrapper resultsAPIWrapper = VeracodeCommand.getResultsAPIWrapper(options);
        byte[] result = resultsAPIWrapper.summaryReportPdf(options._build_id);
        if (printReport) {
            VeracodeCommand.printReport(result, options);
        }
        return result;
    }

    private static byte[] thirdPartyReportPdf(Options options, boolean printReport) throws Exception {
        ResultsAPIWrapper resultsAPIWrapper = VeracodeCommand.getResultsAPIWrapper(options);
        byte[] result = resultsAPIWrapper.thirdPartyReportPdf(options._build_id);
        if (printReport) {
            VeracodeCommand.printReport(result, options);
        }
        return result;
    }

    private static String createTeam(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.createTeam(options._team_name, options._members);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String createUser(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.createUser(options._first_name, options._last_name, options._email_address, options._roles);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String deleteTeam(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.deleteTeam(options._team_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String deleteUser(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.deleteUser(options._username, options._custom_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getCurriculumList(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.getCurriculumList();
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getTeamList(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.getTeamList();
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getTrackList(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.getTrackList();
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getUserInfo(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.getUserInfo(options._username, options._custom_id);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getUserList(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.getUserList(options._first_name, options._last_name, options._custom_id, options._email_address, options._login_account_type, options._phone, options._teams, options._roles, APICallText.Reader.toString(options._is_saml_user), APICallText.Reader.toString(options._login_enabled), APICallText.Reader.toString(options._requires_token), APICallText.Reader.toString(options._is_elearning_manager), options._elearning_manager, options._elearning_track, options._elearning_curriculum, APICallText.Reader.toString(options._keep_elearning_active), options._custom_one, options._custom_two, options._custom_three, options._custom_four, options._custom_five);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String updateTeam(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.updateTeam(options._members, options._team_id, options._team_name);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String updateUser(Options options, boolean printReport) throws Exception {
        AdminAPIWrapper adminAPIWrapper = VeracodeCommand.getAdminAPIWrapper(options);
        String result = adminAPIWrapper.updateUser(options._username, options._custom_id, options._first_name, options._last_name, options._email_address, options._new_custom_id, options._login_account_type, options._phone, options._teams, options._roles, APICallText.Reader.toString(options._is_saml_user), APICallText.Reader.toString(options._login_enabled), APICallText.Reader.toString(options._requires_token), APICallText.Reader.toString(options._is_elearning_manager), options._elearning_manager, options._elearning_track, options._elearning_curriculum, APICallText.Reader.toString(options._keep_elearning_active), options._custom_one, options._custom_two, options._custom_three, options._custom_four, options._custom_five);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String archer(Options options, boolean printReport) throws Exception {
        ArcherAPIWrapper archerAPIWrapper = VeracodeCommand.getArcherAPIWrapper(options);
        String result = archerAPIWrapper.archer(options._app_id, options._period, options._from_date, options._to_date, options._scan_type);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String generateArcherReport(Options options, boolean printReport) throws Exception {
        ArcherAPIWrapper archerAPIWrapper = VeracodeCommand.getArcherAPIWrapper(options);
        String result = archerAPIWrapper.generateArcherReport(options._app_id, options._period, options._from_date, options._to_date, options._scan_type);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String downloadArcherReport(Options options, boolean printReport) throws Exception {
        ArcherAPIWrapper archerAPIWrapper = VeracodeCommand.getArcherAPIWrapper(options);
        String result = archerAPIWrapper.downloadArcherReport(options._token);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String getMitigationInfo(Options options, boolean printReport) throws Exception {
        MitigationAPIWrapper mitigationAPIWrapper = VeracodeCommand.getMitigationAPIWrapper(options);
        String result = mitigationAPIWrapper.getMitigationInfo(options._build_id, options._flaw_id_list);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static String updateMitigationInfo(Options options, boolean printReport) throws Exception {
        MitigationAPIWrapper mitigationAPIWrapper = VeracodeCommand.getMitigationAPIWrapper(options);
        String result = mitigationAPIWrapper.updateMitigationInfo(options._build_id, APICallText.Reader.toString(options._mitigation_action), options._comment, options._flaw_id_list);
        boolean isValidXML = VeracodeCommand.isValidXML(result, options);
        if (printReport && isValidXML) {
            VeracodeCommand.printReport(result, options);
        }
        return isValidXML ? result : null;
    }

    private static void allDetailedReports(Options options) throws Exception {
        NodeList nodeList;
        String result = VeracodeCommand.getAppBuilds(options, false);
        if (result != null && (nodeList = VeracodeCommand.getXmlNodeList(result, "/*/*/*[local-name()='build'][@results_ready='true']")).getLength() > 0) {
            ResultsAPIWrapper resultsAPIWrapper = VeracodeCommand.getResultsAPIWrapper(options);
            File folderPath = new File(options._output_folderpath);
            if (!folderPath.exists()) {
                folderPath.mkdirs();
            }
            int x = 0;
            while (x < nodeList.getLength()) {
                Node node = nodeList.item(x);
                String app_id = node.getParentNode().getAttributes().getNamedItem("app_id").getNodeValue();
                String build_id = node.getAttributes().getNamedItem("build_id").getNodeValue();
                File filePath = new File(folderPath, String.format("%s.%s.%s", Integer.parseInt(app_id), Integer.parseInt(build_id), options._format.toString()));
                switch (options._format) {
                    case pdf: {
                        VeracodeCommand.printReport(resultsAPIWrapper.detailedReportPdf(build_id), options, filePath.getPath());
                        break;
                    }
                    default: {
                        VeracodeCommand.printReport(resultsAPIWrapper.detailedReport(build_id), options, false, filePath.getPath());
                    }
                }
                ++x;
            }
        }
    }

    private static void passFail(Options options) throws Exception {
        String result = VeracodeCommand.getAppList(options, false);
        if (result != null) {
            String app_id = VeracodeCommand.parseAppId(options, result);
            if (app_id != null) {
                options._app_id = app_id;
                result = VeracodeCommand.getBuildInfo(options, false);
                if (result != null) {
                    String build_id;
                    Node node = VeracodeCommand.getXmlNode(result, "/*/*[local-name()='build'][@build_id]");
                    options._build_id = build_id = node.getAttributes().getNamedItem("build_id").getNodeValue();
                    result = VeracodeCommand.detailedReport(options, false);
                    if (result != null) {
                        node = VeracodeCommand.getXmlNode(result, "/*[local-name()='detailedreport']");
                        String formatString = "%s,%s,%s,%s";
                        String submitter = null;
                        String app_name = null;
                        String version = null;
                        String policy_compliance_status = null;
                        if (node.hasChildNodes()) {
                            Node attribute = node.getAttributes().getNamedItem("submitter");
                            if (attribute != null) {
                                submitter = String.format("\"%s\"", attribute.getNodeValue());
                            }
                            if ((attribute = node.getAttributes().getNamedItem("app_name")) != null) {
                                app_name = String.format("\"%s\"", attribute.getNodeValue());
                            }
                            if ((attribute = node.getAttributes().getNamedItem("version")) != null) {
                                version = String.format("\"%s\"", attribute.getNodeValue());
                            }
                            if ((attribute = node.getAttributes().getNamedItem("policy_compliance_status")) != null) {
                                policy_compliance_status = String.format("\"%s\"", attribute.getNodeValue());
                            }
                        }
                        VeracodeCommand.infoWriteLine(formatString, "SUBMITTER", "APPLICATION", "VERSION", "PASSFAIL");
                        VeracodeCommand.infoWriteLine(formatString, submitter, app_name, version, policy_compliance_status);
                    }
                }
            } else {
                VeracodeCommand.infoWriteLine("Application profile \"%s\" could not be located.", options._app_name);
            }
        }
    }

    private static void switchToSaml(Options options) throws Exception {
        String result = VeracodeCommand.getUserList(options, false);
        if (result != null) {
            VeracodeCommand.infoWriteLine("Attempting to switch user(s) to SAML.", new Object[0]);
            NodeList nodeList = VeracodeCommand.getXmlNodeList(result, "/*/*[local-name()='users'][@usernames]");
            if (nodeList.getLength() > 0) {
                String suppliedUser = options._username;
                int x = 0;
                while (x < nodeList.getLength()) {
                    Node node = nodeList.item(x);
                    List<String> users = Arrays.asList(node.getAttributes().getNamedItem("usernames").getNodeValue().split(String.valueOf(','), -1));
                    if (suppliedUser == null && users.size() > 0) {
                        Iterator<String> iterator = users.iterator();
                        while (iterator.hasNext()) {
                            String user;
                            options._username = user = iterator.next();
                            VeracodeCommand.infoWriteLine("\r\nAttempting to switch user \"%s\" to SAML.", options._username);
                            String responseMessage = VeracodeCommand.switchUserToSAML(options, false);
                            VeracodeCommand.infoWriteLine(responseMessage, new Object[0]);
                        }
                    } else if (users.contains(suppliedUser)) {
                        VeracodeCommand.infoWriteLine("\r\nAttempting to switch user \"%s\" to SAML.", options._username);
                        String responseMessage = VeracodeCommand.switchUserToSAML(options, false);
                        VeracodeCommand.infoWriteLine(responseMessage, new Object[0]);
                    } else {
                        VeracodeCommand.infoWriteLine("\r\nUser list does not contain user \"%s\".", suppliedUser);
                    }
                    ++x;
                }
            } else {
                VeracodeCommand.infoWriteLine("\r\nUser list could not be located.", new Object[0]);
            }
        }
    }

    private static void uploadAndScan(Options options) throws Exception {
        String result = VeracodeCommand.getAppList(options, false);
        if (result != null) {
            String app_id = VeracodeCommand.parseAppId(options, result);
            if (app_id != null) {
                VeracodeCommand.infoWriteLine("\r\nApplication profile \"%s\" (appid=%s) was located.", options._app_name, app_id);
            } else if (options._create_profile == TrueOrFalse.True) {
                Node node;
                VeracodeCommand.infoWriteLine("\r\nAttempting to create a new application profile with criticality \"%s\".", APICallText.Reader.toString(options._business_criticality));
                result = VeracodeCommand.createApp(options, false);
                if (result != null && (app_id = (node = VeracodeCommand.getXmlNode(result, "/*/*[local-name()='application'][@app_id]")).getAttributes().getNamedItem("app_id").getNodeValue()) != null) {
                    byte seconds = 7;
                    VeracodeCommand.infoWriteLine("\r\nThe app_id of the new application profile is \"%s\".\r\nWaiting %s seconds before attempting to create a new build.", app_id, seconds);
                    Thread.sleep(seconds * 1000);
                }
            }
            if (result != null) {
                if (app_id != null) {
                    options._app_id = app_id;
                    VeracodeCommand.commonUploadAndScan(options);
                } else {
                    VeracodeCommand.infoWriteLine("\r\nAn app_id could not be located for application profile \"%s\".", options._app_name);
                }
            }
        }
    }

    private static void uploadAndScanByAppId(Options options) throws Exception {
        String result = VeracodeCommand.getAppList(options, false);
        if (result != null) {
            String app_name = VeracodeCommand.parseAppName(options, result);
            if (app_name != null) {
                VeracodeCommand.infoWriteLine("\r\nApplication profile \"%s\" (appid=%s) was located.", app_name, options._app_id);
                options._app_name = app_name;
                VeracodeCommand.commonUploadAndScan(options);
            } else {
                VeracodeCommand.infoWriteLine("\r\nAn application profile could not be located for appid=\"%s\".", options._app_id);
            }
        }
    }

    private static void commonUploadAndScan(Options options) throws Exception {
        String result;
        if (StringUtility.compare(options._version, "timestamp", true) == 0) {
            options._version = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date());
        }
        if ((result = VeracodeCommand.createBuild(options, false)) != null) {
            Node node = VeracodeCommand.getXmlNode(result, "/*/*[local-name()='build'][@build_id]");
            String build_id = node.getAttributes().getNamedItem("build_id").getNodeValue();
            if (build_id != null) {
                VeracodeCommand.infoWriteLine("\r\nThe build_id of the new build is \"%s\".", build_id);
            }
            options._build_id = build_id;
            VeracodeCommand.uploadFiles(options, false, options._file);
            VeracodeCommand.infoWriteLine("\r\nStarting pre-scan verification for application \"%s\" build \"%s\".", options._app_name, options._version);
            result = VeracodeCommand.beginPreScan(options, false);
            if (result != null && (result = VeracodeCommand.tryGetBuildInfoXML(options, false)) != null) {
                VeracodeCommand.infoWriteLine("\r\nPre-scan verification for application \"%s\" build \"%s\" was successful.", options._app_name, options._version);
                result = VeracodeCommand.getPreScanResults(options, false);
                if (result != null) {
                    NodeList nodeList = VeracodeCommand.getXmlNodeList(result, "/*/*[local-name()='module'][@id][@name][@status][@has_fatal_errors='true']");
                    int count = nodeList.getLength();
                    VeracodeCommand.infoWriteLine("\r\nThere %s %s module%s with fatal errors%s", count != 1 ? "are" : "is", count, count != 1 ? "s" : "", count > 0 ? ":" : ".");
                    int x = 0;
                    while (x < count) {
                        VeracodeCommand.infoWriteLine("\r\nModule ID: %s", nodeList.item(x).getAttributes().getNamedItem("id").getNodeValue());
                        VeracodeCommand.infoWriteLine("Module Name: %s", nodeList.item(x).getAttributes().getNamedItem("name").getNodeValue());
                        ++x;
                    }
                    VeracodeCommand.infoWriteLine("\r\nSubmitting application \"%s\" build \"%s\" for scanning.", options._app_name, options._version);
                    options._scan_all_top_level_modules = TrueOrFalse.True;
                    options._modules = null;
                    result = VeracodeCommand.beginScan(options, false);
                    if (result != null) {
                        VeracodeCommand.infoWriteLine("\r\nApplication \"%s\" (appid=%s) build \"%s\" (buildid=%s) successfully submitted for scanning.", options._app_name, options._app_id, options._version, options._build_id);
                    }
                }
            }
        }
    }

    private static String parseAppId(Options options, String xmlResult) throws Exception {
        NodeList nodeList = VeracodeCommand.getXmlNodeList(xmlResult, "/*/*[local-name()='app'][@app_id][@app_name]");
        String app_id = null;
        int x = 0;
        while (x < nodeList.getLength()) {
            Node node = nodeList.item(x);
            if (StringUtility.compare(node.getAttributes().getNamedItem("app_name").getNodeValue(), options._app_name, true) == 0) {
                app_id = node.getAttributes().getNamedItem("app_id").getNodeValue();
                break;
            }
            ++x;
        }
        return app_id;
    }

    private static String parseAppName(Options options, String xmlResult) throws Exception {
        NodeList nodeList = VeracodeCommand.getXmlNodeList(xmlResult, "/*/*[local-name()='app'][@app_id][@app_name]");
        String app_name = null;
        int x = 0;
        while (x < nodeList.getLength()) {
            Node node = nodeList.item(x);
            if (StringUtility.compare(node.getAttributes().getNamedItem("app_id").getNodeValue(), options._app_id, true) == 0) {
                app_name = node.getAttributes().getNamedItem("app_name").getNodeValue();
                break;
            }
            ++x;
        }
        return app_name;
    }

    private static void uploadFiles(Options options, boolean printReports, String ... path) throws Exception {
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            File pFile = new File(p);
            if (pFile.isFile()) {
                VeracodeCommand.displayPreFileUploadMessage(p);
                options._file[0] = p;
                VeracodeCommand.uploadFile(options, printReports);
            } else if (pFile.isDirectory()) {
                File[] fileArray = pFile.listFiles();
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File cFile = fileArray[n4];
                    VeracodeCommand.uploadFiles(options, printReports, cFile.getPath());
                    ++n4;
                }
            } else {
                throw new IllegalArgumentException(String.format("Could not find file '%s'.", pFile.getCanonicalPath()));
            }
            ++n2;
        }
    }

    private static String tryGetBuildInfoXML(Options options, boolean printReports) throws Exception {
        Node node;
        String status;
        String result = null;
        byte seconds = 80;
        while ((result = VeracodeCommand.getBuildInfo(options, false)) != null && StringUtility.compare(status = (node = VeracodeCommand.getXmlNode(result, "/*/*/*[local-name()='analysis_unit'][@status]")).getAttributes().getNamedItem("status").getNodeValue(), "Pre-Scan Success", true) != 0) {
            if (StringUtility.compare(status, "Pre-Scan Failed", true) == 0 || StringUtility.compare(status, "Pre-Scan Failure", true) == 0) {
                result = null;
                break;
            }
            VeracodeCommand.infoWriteLine("\r\nThe status of the new build is \"%s\".\r\nRequesting build info again in %s seconds.", status, seconds);
            Thread.sleep(seconds * 1000);
        }
        return result;
    }

    private static String switchUserToSAML(Options options, boolean printReports) throws Exception {
        String responseMessage = null;
        String result = VeracodeCommand.getUserInfo(options, printReports);
        if (result != null) {
            String login_account_type = null;
            String email_address = null;
            String is_saml_user = null;
            Node loginNode = VeracodeCommand.getXmlNode(result, "/*/*[local-name()='login_account']");
            Node attribute = loginNode.getAttributes().getNamedItem("login_account_type");
            if (attribute != null) {
                login_account_type = attribute.getNodeValue();
            }
            if ((attribute = loginNode.getAttributes().getNamedItem("email_address")) != null) {
                email_address = attribute.getNodeValue();
            }
            if ((attribute = loginNode.getAttributes().getNamedItem("is_saml_user")) != null) {
                is_saml_user = attribute.getNodeValue();
            }
            if (StringUtility.compare(login_account_type, "api", true) == 0) {
                responseMessage = String.format("API user \"%s\" cannot use SAML.", options._username);
            } else if (StringUtility.compare(is_saml_user, "true", true) == 0) {
                responseMessage = String.format("User \"%s\" already uses SAML.", options._username);
            } else {
                options._email_address = email_address;
                options._is_saml_user = TrueOrFalse.True;
                result = VeracodeCommand.updateUser(options, printReports);
                responseMessage = result != null ? String.format("User \"%s\" switched to SAML.", options._username) : String.format("User \"%s\" could not be switched to SAML.", options._username);
            }
        }
        return responseMessage;
    }

    private static boolean printReport(byte[] bytesResult, Options options) throws Exception {
        return VeracodeCommand.printReport(bytesResult, options, null);
    }

    private static boolean printReport(byte[] bytesResult, Options options, String altFilePath) throws Exception {
        byte[] pdfResult = null;
        switch (options._format) {
            case pdf: {
                pdfResult = bytesResult;
                break;
            }
            default: {
                VeracodeCommand.errorWriteLine("Format \"%s\" not supported for Action \"%s\".", new Object[]{options._format, options._action});
            }
        }
        boolean printStatus = false;
        if (pdfResult != null) {
            String filePath;
            String string = filePath = altFilePath != null ? altFilePath : options._output_filepath;
            if (!StringUtility.isNullOrEmpty(filePath)) {
                try (PrintStream writer = null;){
                    writer = new PrintStream(filePath);
                    writer.write(pdfResult, 0, pdfResult.length);
                    VeracodeCommand.displayFileDownloadedMessage(filePath);
                }
                printStatus = true;
            } else {
                VeracodeCommand.errorWriteLine("Action \"%s\" resulted in the following error(s):\r\nOutput filepath is missing.", new Object[]{options._action});
            }
        } else {
            VeracodeCommand.errorWriteLine("Unable to retrieve data in \"%s\" format.", new Object[]{options._format});
        }
        return printStatus;
    }

    private static boolean printReport(String xmlResult, Options options) throws Exception {
        return VeracodeCommand.printReport(xmlResult, options, false);
    }

    private static boolean printReport(String xmlResult, Options options, boolean indentXml) throws Exception {
        return VeracodeCommand.printReport(xmlResult, options, false, null);
    }

    private static boolean printReport(String xmlResult, Options options, boolean indentXml, String altFilePath) throws Exception {
        String textResult = null;
        switch (options._format) {
            case xml: {
                textResult = indentXml ? VeracodeCommand.getIndentedXmlString(xmlResult) : xmlResult;
                break;
            }
            case csv: {
                textResult = VeracodeCommand.getCsvString(xmlResult);
                break;
            }
            default: {
                VeracodeCommand.errorWriteLine("Format \"%s\" not supported for Action \"%s\".", new Object[]{options._format, options._action});
            }
        }
        boolean printStatus = false;
        if (!StringUtility.isNullOrEmpty(textResult)) {
            String filePath;
            String string = filePath = altFilePath != null ? altFilePath : options._output_filepath;
            if (!StringUtility.isNullOrEmpty(filePath)) {
                try (PrintStream writer = null;){
                    writer = new PrintStream(filePath);
                    writer.print(textResult);
                    VeracodeCommand.displayFileDownloadedMessage(filePath);
                }
            } else {
                VeracodeCommand.consoleWriteLine(textResult, new Object[0]);
            }
            printStatus = true;
        } else {
            VeracodeCommand.errorWriteLine("Unable to retrieve data in \"%s\" format.", new Object[]{options._format});
        }
        return printStatus;
    }

    private static void displayFileDownloadedMessage(String filePath) {
        if (!StringUtility.isNullOrEmpty(filePath)) {
            VeracodeCommand.infoWriteLine("Output filepath: %s", filePath);
        }
    }

    private static void displayPreFileUploadMessage(String filePath) {
        if (filePath != null) {
            VeracodeCommand.infoWriteLine("\r\nUploading: %s", filePath);
        }
    }

    private static void displayProgressChangedMessage(int percentage, long bytesSent, long totalBytesToSend) {
        if (percentage >= 0 && percentage <= 100) {
            VeracodeCommand.infoWriteLine("Uploaded: %3d%%", percentage);
        }
    }

    private static void consoleWriteLine(String format, Object ... args) {
        System.out.println(args != null && args.length != 0 ? String.format(format, args) : format);
    }

    private static void infoWriteLine(String format, Object ... args) {
        String value = VeracodeCommand.addTimeStamp(args != null && args.length != 0 ? String.format(format, args) : format);
        System.out.println(value);
        VeracodeCommand.logWriteLine(value);
    }

    private static void errorWriteLine(String format, Object ... args) {
        String value = VeracodeCommand.addTimeStamp(args != null && args.length != 0 ? String.format(format, args) : format);
        System.err.println(value);
        VeracodeCommand.logWriteLine(value);
    }

    private static void logWriteLine(String value) {
        if (logWriter != null && !StringUtility.isNullOrEmpty(value)) {
            logWriter.println(value);
            logWriter.flush();
        }
    }

    private static String addTimeStamp(String value) {
        String timestamp = String.format("[%s] ", new SimpleDateFormat("yy.MM.dd HH:mm:ss").format(new Date()));
        return String.valueOf(timestamp) + (value != null ? value.replace("\r\n", "\r\n" + timestamp) : "");
    }

    private static boolean isValidXML(String xmlResult, Options options) {
        boolean isValidXML = false;
        String errorString = VeracodeCommand.getErrorString(xmlResult);
        if (StringUtility.isNullOrEmpty(errorString)) {
            isValidXML = true;
        } else {
            VeracodeCommand.errorWriteLine("\r\n* Action \"%s\" returned the following message:\r\n* %s\r\n", new Object[]{options._action, errorString.replace("\r\n", "\r\n* ")});
            isValidXML = false;
        }
        return isValidXML;
    }

    private static String getErrorString(String xmlString) {
        String errorString = "";
        StringBuilder builder = new StringBuilder();
        Pattern pattern = Pattern.compile("<error>(.*?)</error>");
        Matcher matcher = pattern.matcher(xmlString);
        while (matcher.find()) {
            builder.append(String.valueOf(matcher.group(1)) + "\r\n");
        }
        errorString = builder.toString();
        if (errorString.contains("\r\n")) {
            errorString = errorString.substring(0, builder.lastIndexOf("\r\n"));
        }
        return errorString;
    }

    private static String getCsvString(String xmlString) throws Exception {
        StringBuilder builder = new StringBuilder();
        NodeList nodeList = VeracodeCommand.getXmlNodeList(xmlString, "/*/*");
        if (nodeList != null) {
            ArrayList<String> nodeNames = new ArrayList<String>();
            String[] headers = null;
            String[] values = null;
            int x = 0;
            while (x < nodeList.getLength()) {
                Node node = nodeList.item(x);
                if (node != null) {
                    boolean newNodeName;
                    values = new String[node.getAttributes().getLength()];
                    boolean bl = newNodeName = !nodeNames.contains(node.getNodeName());
                    if (newNodeName) {
                        nodeNames.add(node.getNodeName());
                        headers = new String[node.getAttributes().getLength()];
                        if (x > 0) {
                            builder.append("\r\n");
                        }
                    }
                    int y = 0;
                    while (y < node.getAttributes().getLength()) {
                        String value;
                        if (newNodeName) {
                            headers[y] = node.getAttributes().item(y).getNodeName().toUpperCase();
                        }
                        String formatString = (value = node.getAttributes().item(y).getNodeValue().replace("\"", "\"\"")).contains(" ") ? "\"%s\"" : "%s";
                        values[y] = String.format(formatString, value);
                        ++y;
                    }
                    if (newNodeName) {
                        builder.append(String.valueOf(StringUtility.join(",", headers)) + "\r\n");
                    }
                    builder.append(String.valueOf(StringUtility.join(",", values)) + "\r\n");
                }
                ++x;
            }
        }
        return builder.toString();
    }

    private static String getIndentedXmlString(String xmlString) {
        String indentedXmlString = null;
        try {
            StringWriter stringWriter = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(VeracodeCommand.getXmlDocument(xmlString)), new StreamResult(stringWriter));
            indentedXmlString = stringWriter.toString();
        }
        catch (Exception e) {
            indentedXmlString = xmlString;
        }
        return indentedXmlString;
    }

    private static Node getXmlNode(String xmlString, String xPath) throws Exception {
        Document xml = VeracodeCommand.getXmlDocument(xmlString);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        return (Node)xPathObj.evaluate(xPath, xml.getDocumentElement(), XPathConstants.NODE);
    }

    private static NodeList getXmlNodeList(String xmlString, String xPath) throws Exception {
        Document xml = VeracodeCommand.getXmlDocument(xmlString);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        return (NodeList)xPathObj.evaluate(xPath, xml.getDocumentElement(), XPathConstants.NODESET);
    }

    private static Document getXmlDocument(String xmlString) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document xml = db.parse(new InputSource(new StringReader(xmlString)));
        return xml;
    }

    private static List<String[]> parseCsvFileAsArgs(String filePath) throws IOException {
        ArrayList<String[]> recordsList = new ArrayList<String[]>();
        Pattern pattern = Pattern.compile("((?:\"(?:\"\"|[^\"])*\")|(?:[^,]*)),?");
        boolean firstPass = true;
        String[] parameters = null;
        String[] arguments = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String current = null;
            while ((current = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(current);
                if (firstPass) {
                    int columnCount = 0;
                    while (matcher.find()) {
                        ++columnCount;
                    }
                    if (columnCount <= 0) break;
                    parameters = new String[columnCount - 1];
                    matcher.reset();
                } else {
                    arguments = new String[parameters.length * 2];
                }
                int x = 0;
                while (x < parameters.length) {
                    String item = null;
                    if (matcher.find()) {
                        item = matcher.group(1);
                        if (Pattern.matches("\".*\"", item)) {
                            item = item.substring(1, item.length() - 1);
                        }
                        String string = item = !StringUtility.isNullOrEmpty(item) ? item.replace("\"\"", "\"") : null;
                    }
                    if (firstPass) {
                        parameters[x] = item;
                    } else if (parameters[x] != null && item != null) {
                        arguments[x * 2] = "-" + parameters[x];
                        arguments[x * 2 + 1] = item;
                    }
                    ++x;
                }
                if (firstPass) {
                    firstPass = false;
                    continue;
                }
                recordsList.add(arguments);
            }
        }
        return recordsList;
    }

    private static UploadAPIWrapper getUploadAPIWrapper(Options options) {
        UploadAPIWrapper wrapper = new UploadAPIWrapper();
        VeracodeCommand.setUpWrapper(wrapper, options);
        return wrapper;
    }

    private static ResultsAPIWrapper getResultsAPIWrapper(Options options) {
        ResultsAPIWrapper wrapper = new ResultsAPIWrapper();
        VeracodeCommand.setUpWrapper(wrapper, options);
        return wrapper;
    }

    private static AdminAPIWrapper getAdminAPIWrapper(Options options) {
        AdminAPIWrapper wrapper = new AdminAPIWrapper();
        VeracodeCommand.setUpWrapper(wrapper, options);
        return wrapper;
    }

    private static ArcherAPIWrapper getArcherAPIWrapper(Options options) {
        ArcherAPIWrapper wrapper = new ArcherAPIWrapper();
        VeracodeCommand.setUpWrapper(wrapper, options);
        return wrapper;
    }

    private static MitigationAPIWrapper getMitigationAPIWrapper(Options options) {
        MitigationAPIWrapper wrapper = new MitigationAPIWrapper();
        VeracodeCommand.setUpWrapper(wrapper, options);
        return wrapper;
    }

    private static void setUpWrapper(AbstractAPIWrapper wrapper, Options options) {
        VeracodeCommand.setUpCredentials(wrapper, options);
        VeracodeCommand.setUpProxyCredentials(wrapper, options);
    }

    private static void setUpCredentials(AbstractAPIWrapper wrapper, Options options) {
        String user = options._vuser;
        String pass = options._vpassword;
        if (StringUtility.isNullOrEmpty(user) && !StringUtility.isNullOrEmpty(options._api1)) {
            user = VeracodeCommand.decodeB64(options._api1);
        }
        if (StringUtility.isNullOrEmpty(pass) && !StringUtility.isNullOrEmpty(options._api2)) {
            pass = VeracodeCommand.decodeB64(options._api2);
        }
        wrapper.setUpCredentials(user, pass);
    }

    private static void setUpProxyCredentials(AbstractAPIWrapper wrapper, Options options) {
        if (options._phost != null) {
            String user = options._puser;
            String pass = options._ppassword;
            if (StringUtility.isNullOrEmpty(user) && !StringUtility.isNullOrEmpty(options._api3)) {
                user = VeracodeCommand.decodeB64(options._api3);
            }
            if (StringUtility.isNullOrEmpty(pass) && !StringUtility.isNullOrEmpty(options._api4)) {
                pass = VeracodeCommand.decodeB64(options._api4);
            }
            wrapper.setUpProxy(options._phost, options._pport, user, pass);
        }
    }

    private static String decodeB64(String b64EncodedString) {
        try {
            return new String(DatatypeConverter.parseBase64Binary((String)b64EncodedString), "UTF-8");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid base64-encoded String.");
        }
    }

    private static String getVersionString() {
        String heading = null;
        String dateFormat = "yyyyMMddHHmm";
        String title = "";
        String version = "";
        String date = "";
        try {
            ClassLoader loader = VeracodeCommand.class.getClassLoader();
            try (InputStream is = null;){
                is = loader.getResourceAsStream("Version.properties");
                Properties properties = new Properties();
                properties.load(is);
                title = properties.getProperty("title");
                String string = title = !StringUtility.isNullOrEmpty(title) ? title : "";
                if (!StringUtility.isNullOrEmpty(title)) {
                    version = properties.getProperty("version");
                    version = !StringUtility.isNullOrEmpty(version) ? String.format(" v%s", version) : "";
                    try {
                        String rawDate = properties.getProperty("date");
                        String datePattern = properties.getProperty("datepattern");
                        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
                        date = new SimpleDateFormat(dateFormat).format(sdf.parse(rawDate));
                        date = !StringUtility.isNullOrEmpty(date) ? String.format(" c%s", date) : "";
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        heading = String.format("%s%s%s", title, version, date);
        return !StringUtility.isNullOrEmpty(heading) ? heading : "";
    }

    private static void handleException(Throwable e) {
        if (e instanceof ParseException) {
            VeracodeCommand.errorWriteLine("\r\nParsing error: %s", e.getMessage() != null ? e.getMessage() : e.getClass().getName());
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                VeracodeCommand.errorWriteLine(e.getCause().getMessage(), new Object[0]);
            }
        } else if (e instanceof IOException) {
            if (e.getMessage() != null) {
                VeracodeCommand.errorWriteLine("\r\n%s", e.getMessage());
                if (e.getMessage().contains("Server returned HTTP response code: 401")) {
                    VeracodeCommand.errorWriteLine("Please make sure that all of the following are true:", new Object[0]);
                    VeracodeCommand.errorWriteLine("1. The login credentials are valid.", new Object[0]);
                    VeracodeCommand.errorWriteLine("2. The account is an API account with sufficient privilege.", new Object[0]);
                    VeracodeCommand.errorWriteLine("3. The account is not locked.", new Object[0]);
                    VeracodeCommand.errorWriteLine("4. This machine's internet-facing IP address is not restricted.", new Object[0]);
                }
            } else {
                VeracodeCommand.errorWriteLine("\r\n%s", e.getClass().getName());
            }
        } else {
            VeracodeCommand.errorWriteLine("\r\n%s", e.getMessage() != null ? e.getMessage() : e.getClass().getName());
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                VeracodeCommand.errorWriteLine(e.getCause().getMessage(), new Object[0]);
            }
        }
    }

    private static void switchOptions(Options options) throws Exception {
        switch (options._action) {
            case BeginPreScan: {
                VeracodeCommand.beginPreScan(options, true);
                break;
            }
            case BeginScan: {
                VeracodeCommand.beginScan(options, true);
                break;
            }
            case CreateApp: {
                VeracodeCommand.createApp(options, true);
                break;
            }
            case CreateBuild: {
                VeracodeCommand.createBuild(options, true);
                break;
            }
            case DeleteApp: {
                VeracodeCommand.deleteApp(options, true);
                break;
            }
            case DeleteBuild: {
                VeracodeCommand.deleteBuild(options, true);
                break;
            }
            case GetAppInfo: {
                VeracodeCommand.getAppInfo(options, true);
                break;
            }
            case GetAppList: {
                VeracodeCommand.getAppList(options, true);
                break;
            }
            case GetBuildInfo: {
                VeracodeCommand.getBuildInfo(options, true);
                break;
            }
            case GetBuildList: {
                VeracodeCommand.getBuildList(options, true);
                break;
            }
            case GetFileList: {
                VeracodeCommand.getFileList(options, true);
                break;
            }
            case GetPolicyList: {
                VeracodeCommand.getPolicyList(options, true);
                break;
            }
            case GetPreScanResults: {
                VeracodeCommand.getPreScanResults(options, true);
                break;
            }
            case GetVendorList: {
                VeracodeCommand.getVendorList(options, true);
                break;
            }
            case RemoveFile: {
                VeracodeCommand.removeFile(options, true);
                break;
            }
            case UpdateApp: {
                VeracodeCommand.updateApp(options, true);
                break;
            }
            case UpdateBuild: {
                VeracodeCommand.updateBuild(options, true);
                break;
            }
            case UploadFile: {
                VeracodeCommand.uploadFile(options, true);
                break;
            }
            case DetailedReport: {
                if (options._format.equals((Object)Format.pdf)) {
                    VeracodeCommand.detailedReportPdf(options, true);
                    break;
                }
                VeracodeCommand.detailedReport(options, true);
                break;
            }
            case GetAppBuilds: {
                VeracodeCommand.getAppBuilds(options, true);
                break;
            }
            case GetCallStacks: {
                VeracodeCommand.getCallStacks(options, true);
                break;
            }
            case SummaryReport: {
                if (options._format.equals((Object)Format.pdf)) {
                    VeracodeCommand.summaryReportPdf(options, true);
                    break;
                }
                VeracodeCommand.summaryReport(options, true);
                break;
            }
            case ThirdPartyReport: {
                VeracodeCommand.thirdPartyReportPdf(options, true);
                break;
            }
            case CreateTeam: {
                VeracodeCommand.createTeam(options, true);
                break;
            }
            case CreateUser: {
                VeracodeCommand.createUser(options, true);
                break;
            }
            case DeleteTeam: {
                VeracodeCommand.deleteTeam(options, true);
                break;
            }
            case DeleteUser: {
                VeracodeCommand.deleteUser(options, true);
                break;
            }
            case GetCurriculumList: {
                VeracodeCommand.getCurriculumList(options, true);
                break;
            }
            case GetTeamList: {
                VeracodeCommand.getTeamList(options, true);
                break;
            }
            case GetTrackList: {
                VeracodeCommand.getTrackList(options, true);
                break;
            }
            case GetUserInfo: {
                VeracodeCommand.getUserInfo(options, true);
                break;
            }
            case GetUserList: {
                VeracodeCommand.getUserList(options, true);
                break;
            }
            case UpdateTeam: {
                VeracodeCommand.updateTeam(options, true);
                break;
            }
            case UpdateUser: {
                VeracodeCommand.updateUser(options, true);
                break;
            }
            case Archer: {
                VeracodeCommand.archer(options, true);
                break;
            }
            case GenerateArcherReport: {
                VeracodeCommand.generateArcherReport(options, true);
                break;
            }
            case DownloadArcherReport: {
                VeracodeCommand.downloadArcherReport(options, true);
                break;
            }
            case GetMitigationInfo: {
                VeracodeCommand.getMitigationInfo(options, true);
                break;
            }
            case UpdateMitigationInfo: {
                VeracodeCommand.updateMitigationInfo(options, true);
                break;
            }
            case AllDetailedReports: {
                VeracodeCommand.allDetailedReports(options);
                break;
            }
            case SwitchToSaml: {
                VeracodeCommand.switchToSaml(options);
                break;
            }
            case PassFail: {
                VeracodeCommand.passFail(options);
                break;
            }
            case UploadAndScan: {
                VeracodeCommand.uploadAndScan(options);
                break;
            }
            case UploadAndScanByAppId: {
                VeracodeCommand.uploadAndScanByAppId(options);
                break;
            }
            default: {
                throw new ParseException(String.format("Invalid Action: %s.", new Object[]{options._action}));
            }
        }
    }

    private static void printCommandNumber(int current, int total) {
        VeracodeCommand.infoWriteLine(StringUtility.repeatChar('*', 40), new Object[0]);
        VeracodeCommand.infoWriteLine("Command:\t%s/%s", current, total);
        VeracodeCommand.infoWriteLine(StringUtility.repeatChar('*', 40), new Object[0]);
    }

    private static void initializeLogWriter(Options options) throws Exception {
        if (options._log_filepath != null) {
            logWriter = new PrintStream(new FileOutputStream(options._log_filepath, true));
            VeracodeCommand.logWriteLine(StringUtility.repeatChar('-', 80));
            VeracodeCommand.logWriteLine(VeracodeCommand.getVersionString());
            VeracodeCommand.logWriteLine(options._action != null ? String.format("Action: %s", options._action.toString()) : "");
            VeracodeCommand.logWriteLine(StringUtility.repeatChar('-', 80));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        CommandLineParser parser = new CommandLineParser();
        Options options = new Options();
        try {
            try {
                if (!parser.parse(options, args)) return;
                VeracodeCommand.initializeLogWriter(options);
                if (options._input_filepath != null) {
                    List<String[]> argsList = VeracodeCommand.parseCsvFileAsArgs(options._input_filepath);
                    if (argsList == null || argsList.size() <= 0) throw new ParseException(String.format("Invalid Input File: %s.", options._input_filepath));
                    int x = 0;
                    parser.setSettings(new CommandLineParserSettings(null));
                    for (String[] _args : argsList) {
                        try {
                            VeracodeCommand.printCommandNumber(++x, argsList.size());
                            parser.parse(options, _args);
                            VeracodeCommand.switchOptions(options);
                        }
                        catch (Throwable e) {
                            VeracodeCommand.handleException(e);
                        }
                    }
                    return;
                } else {
                    VeracodeCommand.switchOptions(options);
                }
                return;
            }
            catch (Throwable e) {
                VeracodeCommand.handleException(e);
                if (logWriter == null) return;
                logWriter.close();
            }
            return;
        }
        finally {
            if (logWriter != null) {
                logWriter.close();
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface APICallText {
        public String value();

        public static final class Reader {
            public static String toString(Enum<?> enumElement) {
                String result = null;
                if (enumElement != null) {
                    String enumElementName = enumElement.toString();
                    APICallText attribute = null;
                    try {
                        attribute = enumElement.getClass().getField(enumElementName).getAnnotation(APICallText.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    result = attribute != null ? attribute.value() : enumElementName;
                }
                return result;
            }

            private Reader() {
            }
        }
    }

    public static enum Action {
        BeginPreScan,
        BeginScan,
        CreateApp,
        CreateBuild,
        DeleteApp,
        DeleteBuild,
        GetAppInfo,
        GetAppList,
        GetBuildInfo,
        GetBuildList,
        GetFileList,
        GetPolicyList,
        GetPreScanResults,
        GetVendorList,
        RemoveFile,
        UpdateApp,
        UpdateBuild,
        UploadFile,
        DetailedReport,
        GetAppBuilds,
        GetCallStacks,
        SummaryReport,
        ThirdPartyReport,
        CreateTeam,
        CreateUser,
        DeleteTeam,
        DeleteUser,
        GetCurriculumList,
        GetTeamList,
        GetTrackList,
        GetUserInfo,
        GetUserList,
        UpdateTeam,
        UpdateUser,
        Archer,
        GenerateArcherReport,
        DownloadArcherReport,
        GetMitigationInfo,
        UpdateMitigationInfo,
        AllDetailedReports,
        PassFail,
        SwitchToSaml,
        UploadAndScan,
        UploadAndScanByAppId;

    }

    public static enum App_Type {
        NotSpecified,
        ApplicationDesignConstructionIDEAnalysis,
        ApplicationLifeCycleManagement,
        ApplicationServerIntegrationServer,
        BackOfficeEnterprise,
        CRM,
        CollaborationGroupwareMessaging,
        Consumer,
        ContentManagementAuthoring,
        Engineering,
        EnterpriseResourcePlanning,
        InformationAccessDeliveryMiningPortal,
        InformationDataManagementDatabase,
        MiddlewareMessageOrientedTransaction,
        NetworkManagement,
        Networking,
        Other,
        OtherDevelopmentTools,
        Security,
        ServerWareClusteringWebVM,
        Storage,
        SystemLevelSoftware,
        SystemsManagement,
        TestingTools;

    }

    public static enum Business_Criticality {
        VeryHigh,
        High,
        Medium,
        Low,
        VeryLow;

    }

    public static enum Deployment_Type {
        NotSpecified,
        WebBased,
        EnterpriseApplicationEnhancement,
        ClientServer,
        Mobile,
        StandAlone;

    }

    public static enum Format {
        xml,
        pdf,
        csv,
        text;

    }

    public static enum Industry {
        NotSpecified,
        Aerospace,
        Agriculture,
        Apparel,
        AutomotiveAndTransport,
        Banking,
        Beverages,
        Biotechnology,
        BusinessServices,
        CharitableOrganizations,
        Chemicals,
        Communications,
        ComputerHardware,
        Software,
        Consulting,
        Construction,
        ConsumerProductsManufacturers,
        ConsumerServices,
        CulturalInstitutions,
        Education,
        Electronics,
        Energy,
        Engineering,
        Environmental,
        Finance,
        FoodAndBeverage,
        Foundations,
        Government,
        Healthcare,
        Hospitality,
        Manufacturing,
        Insurance,
        Recreation,
        Machinery,
        MediaAndEntertainment,
        MembershipOrganizations,
        MetalsAndMining,
        Pharmaceuticals,
        RealEstate,
        Retail,
        SecurityProductsAndServices,
        Technology,
        TelecommunicationsEquipment,
        Telecommunications,
        Transportation,
        Other,
        Utilities;

    }

    public static enum Lifecycle_Stage {
        NotSpecified,
        InDevelopmentPreAlpha,
        InternalOrAlphaTesting,
        ExternalOrBetaTesting,
        DeployedInProductionAndActivelyDeveloped,
        MaintenanceOnlyBugFixes,
        CannotDisclose;

    }

    public static enum Mitigation_Action {
        comment,
        fp,
        appdesign,
        osenv,
        netenv,
        rejected,
        accepted;

    }

    public static final class Options
    extends CommandLineOptionsBase {
        private static final String ACTION = "action";
        @Option(longName="action", parseOnce=true, displayEnumOptions=true, required=true)
        public Action _action = null;
        private static final String API1 = "api1";
        @Option(longName="api1", parseOnce=true, helpText="API one", mutuallyExclusiveSet="vuser_set")
        public String _api1 = null;
        private static final String API2 = "api2";
        @Option(longName="api2", parseOnce=true, helpText="API two", mutuallyExclusiveSet="vpassword_set")
        public String _api2 = null;
        private static final String API3 = "api3";
        @Option(longName="api3", parseOnce=true, helpText="API three", mutuallyExclusiveSet="puser_set")
        public String _api3 = null;
        private static final String API4 = "api4";
        @Option(longName="api4", parseOnce=true, helpText="API four", mutuallyExclusiveSet="ppassword_set")
        public String _api4 = null;
        private static final String APP_ID = "appid";
        @Option(longName="appid", helpText="Application ID", requiredBy={"action", "BeginPreScan", "BeginScan", "CreateBuild", "DeleteApp", "DeleteBuild", "GetAppInfo", "GetBuildInfo", "GetBuildList", "GetFileList", "GetPreScanResults", "RemoveFile", "UpdateApp", "UpdateBuild", "UploadFile", "UploadAndScanByAppId"}, optionalBy={"action", "Archer", "GenerateArcherReport"})
        public String _app_id = null;
        private static final String APP_NAME = "appname";
        @Option(longName="appname", helpText="Application Name", requiredBy={"action", "CreateApp", "PassFail", "UploadAndScan"}, optionalBy={"action", "UpdateApp"})
        public String _app_name = null;
        private static final String APP_TYPE = "apptype";
        @Option(longName="apptype", displayEnumOptions=true, optionalBy={"action", "CreateApp", "UpdateApp"})
        public App_Type _app_type = null;
        private static final String ARCHER_APP_NAME = "archerappname";
        @Option(longName="archerappname", helpText="Archer Application Name", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _archer_app_name = null;
        private static final String BUILD_ID = "buildid";
        @Option(longName="buildid", helpText="Build ID", requiredBy={"action", "DetailedReport", "GetCallStacks", "SummaryReport", "ThirdPartyReport", "GetMitigationInfo", "UpdateMitigationInfo"}, optionalBy={"action", "GetBuildInfo", "GetFileList", "GetPreScanResults", "UpdateBuild"})
        public String _build_id = null;
        private static final String BUSINESS_CRITICALITY = "criticality";
        @Option(longName="criticality", customDefaultValue="VeryHigh", displayEnumOptions=true, requiredBy={"action", "CreateApp", "UpdateApp"}, optionalBy={"action", "UploadAndScan"})
        public Business_Criticality _business_criticality = null;
        private static final String BUSINESS_OWNER = "businessowner";
        @Option(longName="businessowner", helpText="Business Owner", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _business_owner = null;
        private static final String BUSINESS_OWNER_EMAIL = "businessowneremail";
        @Option(longName="businessowneremail", helpText="Business Owner's e-mail address", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _business_owner_email = null;
        private static final String BUSINESS_UNIT = "businessunit";
        @Option(longName="businessunit", helpText="Business Unit", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _business_unit = null;
        private static final String COMMENT = "comment";
        @Option(longName="comment", helpText="Comment", requiredBy={"action", "UpdateMitigationInfo"})
        public String _comment = null;
        private static final String CREATE_PROFILE = "createprofile";
        @Option(longName="createprofile", helpText="True to create a new application profile", requiredBy={"action", "UploadAndScan"})
        public TrueOrFalse _create_profile = null;
        private static final String CUSTOM_FIELD_NAME = "customfieldname";
        @Option(longName="customfieldname", helpText="Custom field name", optionalBy={"action", "UpdateApp"})
        public String _custom_field_name = null;
        private static final String CUSTOM_FIELD_VALUE = "customfieldvalue";
        @Option(longName="customfieldvalue", helpText="Custom field value", optionalBy={"action", "UpdateApp"})
        public String _custom_field_value = null;
        private static final String CUSTOM_FIVE = "custom5";
        @Option(longName="custom5", helpText="Custom five", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_five = null;
        private static final String CUSTOM_FOUR = "custom4";
        @Option(longName="custom4", helpText="Custom four", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_four = null;
        private static final String CUSTOM_ID = "customid";
        @Option(longName="customid", helpText="Custom ID", mutuallyExclusiveSet="user_set", requiredBy={"action", "DeleteUser", "GetUserInfo", "UpdateUser"}, optionalBy={"action", "GetUserList"})
        public String _custom_id = null;
        private static final String CUSTOM_ONE = "custom1";
        @Option(longName="custom1", helpText="Custom one", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_one = null;
        private static final String CUSTOM_THREE = "custom3";
        @Option(longName="custom3", helpText="Custom three", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_three = null;
        private static final String CUSTOM_TWO = "custom2";
        @Option(longName="custom2", helpText="Custom two", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_two = null;
        private static final String DEBUG = "debug";
        @Option(longName="debug", parseOnce=true, helpText="Turn on debug messages")
        public boolean _debug = false;
        private static final String DEPLOYMENT_TYPE = "deploymenttype";
        @Option(longName="deploymenttype", displayEnumOptions=true, optionalBy={"action", "CreateApp", "UpdateApp"})
        public Deployment_Type _deployment_type = null;
        private static final String DESCRIPTION = "description";
        @Option(longName="description", helpText="Description", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _description = null;
        private static final String ELEARNING_CURRICULUM = "elearningcurriculum";
        @Option(longName="elearningcurriculum", helpText="eLearning Curriculum", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _elearning_curriculum = null;
        private static final String ELEARNING_MANAGER = "elearningmanager";
        @Option(longName="elearningmanager", helpText="eLearning Manager", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _elearning_manager = null;
        private static final String ELEARNING_TRACK = "elearningtrack";
        @Option(longName="elearningtrack", helpText="eLearning Track", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _elearning_track = null;
        private static final String EMAIL_ADDRESS = "emailaddress";
        @Option(longName="emailaddress", helpText="E-mail address", requiredBy={"action", "CreateUser"}, optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _email_address = null;
        private static final String FILE = "filepath";
        @Option(longName="filepath", inputPath=true, helpText="Filepath or folderpath of the file or directory to upload. (If the last character is a backslash it needs to be escaped: \\\\)", requiredBy={"action", "UploadFile", "UploadAndScan", "UploadAndScanByAppId"})
        public String[] _file = null;
        private static final String FILE_ID = "fileid";
        @Option(longName="fileid", helpText="File ID", requiredBy={"action", "RemoveFile"})
        public String _file_id = null;
        private static final String FIRST_NAME = "firstname";
        @Option(longName="firstname", helpText="First Name", requiredBy={"action", "CreateUser"}, optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _first_name = null;
        private static final String FLAW_ID = "flawid";
        @Option(longName="flawid", helpText="Flaw ID", requiredBy={"action", "GetCallStacks"})
        public String _flaw_id = null;
        private static final String FLAW_ID_LIST = "flawidlist";
        @Option(longName="flawidlist", helpText="Comma-separated list of module flaw IDs", requiredBy={"action", "GetMitigationInfo", "UpdateMitigationInfo"})
        public String _flaw_id_list = null;
        private static final String FORMAT = "format";
        @Option(longName="format", customDefaultValue="xml", displayEnumOptions=true, requiredBy={"action", "ThirdPartyReport"}, optionalBy={"~action", "ThirdPartyReport"})
        public Format _format = null;
        private static final String FROM_DATE = "fromdate";
        @Option(longName="fromdate", helpText="From Date", optionalBy={"action", "Archer", "GenerateArcherReport"})
        public String _from_date = null;
        private static final String HELP = "help";
        @Option(longName="help", parseOnce=true, helpText="Display this message")
        public boolean _help = false;
        private static final String INDUSTRY = "industry";
        @Option(longName="industry", displayEnumOptions=true, optionalBy={"action", "CreateApp", "UpdateApp"})
        public Industry _industry = null;
        private static final String INPUT_FILEPATH = "inputfilepath";
        @Option(longName="inputfilepath", parseOnce=true, inputPath=true, overridesRules=true, helpText="The filepath of the csv file from which to read additional command-line arguments", optionalBy={"~action", "GetAppList", "GetPolicyList", "GetVendorList", "GetAppBuilds", "GetCurriculumList", "GetTeamList", "GetTrackList", "GetUserList"})
        public String _input_filepath = null;
        private static final String IS_ELEARNING_MANAGER = "iselearningmanager";
        @Option(longName="iselearningmanager", helpText="True if eLearning manager", optionalBy={"action", "GetUserList", "UpdateUser"})
        public TrueOrFalse _is_elearning_manager = null;
        private static final String IS_SAML_USER = "issamluser";
        @Option(longName="issamluser", helpText="True if SAML user", optionalBy={"action", "GetUserList", "UpdateUser"})
        public TrueOrFalse _is_saml_user = null;
        private static final String KEEP_ELEARNING_ACTIVE = "keepelearningactive";
        @Option(longName="keepelearningactive", helpText="True to keep eLearning Active", optionalBy={"action", "GetUserList", "UpdateUser"})
        public TrueOrFalse _keep_elearning_active = null;
        private static final String LAST_NAME = "lastname";
        @Option(longName="lastname", helpText="Last Name", requiredBy={"action", "CreateUser"}, optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _last_name = null;
        private static final String LAUNCH_DATE = "launchdate";
        @Option(longName="launchdate", helpText="Launch date", optionalBy={"action", "CreateBuild", "UpdateBuild"})
        public String _launch_date = null;
        private static final String LIFECYCLE_STAGE = "lifecyclestage";
        @Option(longName="lifecyclestage", displayEnumOptions=true, optionalBy={"action", "CreateBuild", "UpdateBuild"})
        public Lifecycle_Stage _lifecycle_stage = null;
        private static final String LIFECYCLE_STAGE_ID = "lifecyclestageid";
        @Option(longName="lifecyclestageid", helpText="Lifecycle stage id", optionalBy={"action", "CreateBuild"})
        public String _lifecycle_stage_id = null;
        private static final String LOG_FILEPATH = "logfilepath";
        @Option(longName="logfilepath", parseOnce=true, outputPath=true, helpText="The filepath of the file where informational and error messages will be logged. If the file already exists new data will be appended.", optionalBy={"action"})
        public String _log_filepath = null;
        private static final String LOGIN_ACCOUNT_TYPE = "loginaccounttype";
        @Option(longName="loginaccounttype", helpText="Login Account Type", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _login_account_type = null;
        private static final String LOGIN_ENABLED = "loginenabled";
        @Option(longName="loginenabled", helpText="True if Login is enabled.", optionalBy={"action", "GetUserList", "UpdateUser"})
        public TrueOrFalse _login_enabled = null;
        private static final String MEMBERS = "members";
        @Option(longName="members", helpText="Members", optionalBy={"action", "CreateTeam", "UpdateTeam"})
        public String _members = null;
        private static final String MITIGATION_ACTION = "mitigationaction";
        @Option(longName="mitigationaction", displayEnumOptions=true, requiredBy={"action", "UpdateMitigationInfo"})
        public Mitigation_Action _mitigation_action = null;
        private static final String MODULES = "modules";
        @Option(longName="modules", helpText="Comma-separated list of module IDs", mutuallyExclusiveSet="modules_set", requiredBy={"action", "BeginScan"})
        public String _modules = null;
        private static final String NEW_CUSTOM_ID = "newcustomid";
        @Option(longName="newcustomid", helpText="New Custom ID", optionalBy={"action", "UpdateUser"})
        public String _new_custom_id = null;
        private static final String ORIGIN = "origin";
        @Option(longName="origin", displayEnumOptions=true, optionalBy={"action", "CreateApp", "UpdateApp"})
        public Origin _origin = null;
        private static final String OUTPUT_FILEPATH = "outputfilepath";
        @Option(longName="outputfilepath", outputPath=true, helpText="Output filepath", requiredBy={"action", "ThirdPartyReport", "DetailedReport", "SummaryReport"})
        public String _output_filepath = null;
        private static final String OUTPUT_FOLDERPATH = "outputfolderpath";
        @Option(longName="outputfolderpath", outputPath=true, helpText="Output folderpath. (If the last character is a backslash it needs to be escaped: \\\\)", requiredBy={"action", "AllDetailedReports"})
        public String _output_folderpath = null;
        private static final String PERIOD = "period";
        @Option(longName="period", helpText="Period", optionalBy={"action", "Archer", "GenerateArcherReport"})
        public String _period = null;
        private static final String PHONE = "phone";
        @Option(longName="phone", helpText="Phone", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _phone = null;
        private static final String PHOST = "phost";
        @Option(longName="phost", parseOnce=true, helpText="Proxy host", optionalBy={"action"})
        public String _phost = null;
        private static final String PLATFORM = "platform";
        @Option(longName="platform", displayEnumOptions=true, optionalBy={"action", "CreateBuild"})
        public Platform _platform = null;
        private static final String PLATFORM_ID = "platformid";
        @Option(longName="platformid", helpText="Platform id", optionalBy={"action", "CreateBuild"})
        public String _platform_id = null;
        private static final String POLICY = "policy";
        @Option(longName="policy", helpText="Policy", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _policy = null;
        private static final String PPASSWORD = "ppassword";
        @Option(longName="ppassword", parseOnce=true, helpText="Proxy password", mutuallyExclusiveSet="ppassword_set", optionalBy={"action"})
        public String _ppassword = null;
        private static final String PPORT = "pport";
        @Option(longName="pport", parseOnce=true, helpText="Proxy port", optionalBy={"action"})
        public String _pport = null;
        private static final String PUSER = "puser";
        @Option(longName="puser", parseOnce=true, helpText="Proxy user", mutuallyExclusiveSet="puser_set", optionalBy={"action"})
        public String _puser = null;
        private static final String REQUIRES_TOKEN = "requirestoken";
        @Option(longName="requirestoken", helpText="True if the user requires token", optionalBy={"action", "GetUserList", "UpdateUser"})
        public TrueOrFalse _requires_token = null;
        private static final String ROLES = "roles";
        @Option(longName="roles", helpText="Comma-delimited list. Case-sensitive. You can filter on theses human user roles: Administrator, Creator, Executive, Mitigation Approver, Policy Administrator, Reviewer, Security Lead, Submitter, Security Insights, eLearning.", requiredBy={"action", "CreateUser"}, optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _roles = null;
        private static final String SCAN_ALL_TOP_LEVEL_MODULES = "toplevel";
        @Option(longName="toplevel", helpText="True if you want to ensure that the scan completes even though there are non-fatal errors, such as unsupported frameworks.", mutuallyExclusiveSet="modules_set", requiredBy={"action", "BeginScan"})
        public TrueOrFalse _scan_all_top_level_modules = null;
        private static final String SCAN_TYPE = "scantype";
        @Option(longName="scantype", helpText="Scan Type", optionalBy={"action", "Archer", "GenerateArcherReport"})
        public String _scan_type = null;
        private static final String TAGS = "tags";
        @Option(longName="tags", helpText="Tags", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _tags = null;
        private static final String TEAM_ID = "teamid";
        @Option(longName="teamid", helpText="Team ID", requiredBy={"action", "DeleteTeam", "UpdateTeam"})
        public String _team_id = null;
        private static final String TEAM_NAME = "teamname";
        @Option(longName="teamname", helpText="Team Name", requiredBy={"action", "CreateTeam"}, optionalBy={"action", "UpdateTeam"})
        public String _team_name = null;
        private static final String TEAMS = "teams";
        @Option(longName="teams", helpText="Comma-separated list of team names", optionalBy={"action", "CreateApp", "UpdateApp", "GetUserList", "UpdateUser"})
        public String _teams = null;
        private static final String TO_DATE = "todate";
        @Option(longName="todate", helpText="To date", optionalBy={"action", "Archer", "GenerateArcherReport"})
        public String _to_date = null;
        private static final String TOKEN = "token";
        @Option(longName="token", helpText="Token associated with the archer report", optionalBy={"action", "DownloadArcherReport"})
        public String _token = null;
        private static final String USERNAME = "username";
        @Option(longName="username", helpText="User name", mutuallyExclusiveSet="user_set", requiredBy={"action", "DeleteUser", "GetUserInfo", "UpdateUser"})
        public String _username = null;
        private static final String VENDOR_ID = "vendorid";
        @Option(longName="vendorid", helpText="Vendor ID", optionalBy={"action", "CreateApp"})
        public String _vendor_id = null;
        private static final String VERSION = "version";
        @Option(longName="version", helpText="The name or version number of the new or updated build", requiredBy={"action", "CreateBuild", "UploadAndScan", "UploadAndScanByAppId"}, optionalBy={"action", "UpdateBuild"})
        public String _version = null;
        private static final String VPASSWORD = "vpassword";
        @Option(longName="vpassword", parseOnce=true, helpText="Veracode password", mutuallyExclusiveSet="vpassword_set", required=true)
        public String _vpassword = null;
        private static final String VUSER = "vuser";
        @Option(longName="vuser", parseOnce=true, helpText="Veracode user name", mutuallyExclusiveSet="vuser_set", required=true)
        public String _vuser = null;
        private static final String WEB_APPLICATION = "webapplication";
        @Option(longName="webapplication", helpText="True if the application is a web application.", optionalBy={"action", "CreateApp"})
        public TrueOrFalse _web_application = null;

        @Override
        public String createHeading() {
            String heading = VeracodeCommand.getVersionString();
            return !StringUtility.isNullOrEmpty(heading) ? String.valueOf(heading) + "\r\n" : "";
        }

        @Override
        public List<String> optionsWithIncompatibleArguments() {
            ArrayList<String> list = new ArrayList<String>();
            if (this._action != null) {
                switch (this._action) {
                    case AllDetailedReports: {
                        if (this._format.equals((Object)Format.pdf) || this._format.equals((Object)Format.xml)) break;
                        list.add(FORMAT);
                        break;
                    }
                    case ThirdPartyReport: {
                        if (this._format.equals((Object)Format.pdf)) break;
                        list.add(FORMAT);
                        break;
                    }
                    case DetailedReport: 
                    case SummaryReport: {
                        break;
                    }
                    default: {
                        if (!this._format.equals((Object)Format.pdf)) break;
                        list.add(FORMAT);
                    }
                }
            }
            return list;
        }
    }

    public static enum Origin {
        NotSpecified,
        ThirdPartyLibrary,
        PurchasedApplication,
        Contractor,
        InternallyDeveloped,
        OpenSource,
        OutsourcedTeam;

    }

    public static enum Platform {
        NotSpecified,
        Windows,
        Solaris,
        Linux,
        Java,
        WindowsMobile,
        J2ME,
        ColdFusion,
        PHP,
        Android,
        iOS,
        Ruby;

    }

    public static enum TrueOrFalse {
        True,
        False;

    }
}

