/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import com.google.zxing.DecodeHintType;
import com.journeyapps.barcodescanner.BarcodeCallback;
import com.journeyapps.barcodescanner.BarcodeResult;
import com.journeyapps.barcodescanner.CameraPreview;
import com.journeyapps.barcodescanner.Decoder;
import com.journeyapps.barcodescanner.DecoderFactory;
import com.journeyapps.barcodescanner.DecoderResultPointCallback;
import com.journeyapps.barcodescanner.DecoderThread;
import com.journeyapps.barcodescanner.DefaultDecoderFactory;
import com.journeyapps.barcodescanner.R;
import com.journeyapps.barcodescanner.Util;
import java.util.HashMap;
import java.util.List;

public class BarcodeView
extends CameraPreview {
    private DecodeMode decodeMode = DecodeMode.NONE;
    private BarcodeCallback callback = null;
    private DecoderThread decoderThread;
    private final Handler.Callback resultCallback = new Handler.Callback(){

        public boolean handleMessage(Message message) {
            if (message.what == R.id.zxing_decode_succeeded) {
                BarcodeResult result = (BarcodeResult)message.obj;
                if (result != null && BarcodeView.this.callback != null && BarcodeView.this.decodeMode != DecodeMode.NONE) {
                    BarcodeView.this.callback.barcodeResult(result);
                    if (BarcodeView.this.decodeMode == DecodeMode.SINGLE) {
                        BarcodeView.this.stopDecoding();
                    }
                }
                return true;
            }
            if (message.what == R.id.zxing_decode_failed) {
                return true;
            }
            if (message.what == R.id.zxing_possible_result_points) {
                List resultPoints = (List)message.obj;
                if (BarcodeView.this.callback != null && BarcodeView.this.decodeMode != DecodeMode.NONE) {
                    BarcodeView.this.callback.possibleResultPoints(resultPoints);
                }
                return true;
            }
            return false;
        }
    };
    private DecoderFactory decoderFactory;
    private Handler resultHandler;

    public BarcodeView(Context context) {
        super(context);
        this.initialize();
    }

    public BarcodeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    public BarcodeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    private void initialize() {
        this.decoderFactory = new DefaultDecoderFactory();
        this.resultHandler = new Handler(this.resultCallback);
    }

    private Decoder createDecoder() {
        if (this.decoderFactory == null) {
            this.decoderFactory = this.createDefaultDecoderFactory();
        }
        DecoderResultPointCallback callback = new DecoderResultPointCallback();
        HashMap<DecodeHintType, DecoderResultPointCallback> hints = new HashMap<DecodeHintType, DecoderResultPointCallback>();
        hints.put(DecodeHintType.NEED_RESULT_POINT_CALLBACK, callback);
        Decoder decoder = this.decoderFactory.createDecoder(hints);
        callback.setDecoder(decoder);
        return decoder;
    }

    public DecoderFactory getDecoderFactory() {
        return this.decoderFactory;
    }

    public void setDecoderFactory(DecoderFactory decoderFactory) {
        Util.validateMainThread();
        this.decoderFactory = decoderFactory;
        if (this.decoderThread != null) {
            this.decoderThread.setDecoder(this.createDecoder());
        }
    }

    public void decodeSingle(BarcodeCallback callback) {
        this.decodeMode = DecodeMode.SINGLE;
        this.callback = callback;
        this.startDecoderThread();
    }

    public void decodeContinuous(BarcodeCallback callback) {
        this.decodeMode = DecodeMode.CONTINUOUS;
        this.callback = callback;
        this.startDecoderThread();
    }

    public void stopDecoding() {
        this.decodeMode = DecodeMode.NONE;
        this.callback = null;
        this.stopDecoderThread();
    }

    protected DecoderFactory createDefaultDecoderFactory() {
        return new DefaultDecoderFactory();
    }

    private void startDecoderThread() {
        this.stopDecoderThread();
        if (this.decodeMode != DecodeMode.NONE && this.isPreviewActive()) {
            this.decoderThread = new DecoderThread(this.getCameraInstance(), this.createDecoder(), this.resultHandler);
            this.decoderThread.setCropRect(this.getPreviewFramingRect());
            this.decoderThread.start();
        }
    }

    @Override
    protected void previewStarted() {
        super.previewStarted();
        this.startDecoderThread();
    }

    private void stopDecoderThread() {
        if (this.decoderThread != null) {
            this.decoderThread.stop();
            this.decoderThread = null;
        }
    }

    @Override
    public void pause() {
        this.stopDecoderThread();
        super.pause();
    }

    private static enum DecodeMode {
        NONE,
        SINGLE,
        CONTINUOUS;

    }
}

