/*
 * Decompiled with CFR 0.152.
 */
package com.veken.chartview.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.veken.chartview.DensityUtils;
import com.veken.chartview.bean.ChartBean;
import com.veken.chartview.drawtype.DrawConnectLineType;
import com.veken.linecharviewmodule.R;
import java.util.ArrayList;
import java.util.List;

public class BarChartView
extends View {
    private float xLength;
    private float yLength;
    private float startPointX = 0.0f;
    private float startPointY = 0.0f;
    private float xMarginWidth;
    private float startX = 0.0f;
    private float startY = 0.0f;
    private List<ChartBean> mList = new ArrayList<ChartBean>();
    private String yLableText = "\u67f1\u72b6\u56fe";
    private Paint mScaleLinePaint;
    private Paint mDataLinePaint;
    private Paint yTextLablePaint;
    private Paint xTextLablePaint;
    private Paint yDataPaint;
    private Paint bgPaint;
    private int axisMarginHeight;
    private float yDataWidth;
    private int defaultStrokeWidth;
    private int defaultTextSize;
    private int yLableTextColor;
    private int defaultColor;
    private int xLableTextColor;
    private int axisColor;
    private int bgColor;
    private boolean isNeedBg;
    private boolean isNeedDrawYScale;
    private DrawConnectLineType drawConnectLineType;
    private boolean isNeedDrawConnectYDataLine;
    private Context mContext;
    private float firstDataWidth;
    private float yLableWidth;
    private float viewWidth;
    private float viewHeight;
    private float yDataHeight;
    private float xLableHeight;
    private int axisXItemWidth;
    private int dottedLineWidth;
    private int connectLineColor;
    private RectF rect;

    public int getConnectLineColor() {
        return this.connectLineColor;
    }

    public void setConnectLineColor(int connectLineColor) {
        this.connectLineColor = connectLineColor;
    }

    public DrawConnectLineType getDrawConnectLineType() {
        return this.drawConnectLineType;
    }

    public void setDrawConnectLineType(DrawConnectLineType drawConnectLineType) {
        this.drawConnectLineType = drawConnectLineType;
    }

    public int getDottedLineWidth() {
        return this.dottedLineWidth;
    }

    public void setDottedLineWidth(int dottedLineWidth) {
        this.dottedLineWidth = dottedLineWidth;
    }

    public int getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(int axisColor) {
        this.axisColor = axisColor;
    }

    public boolean isNeedDrawConnectYDataLine() {
        return this.isNeedDrawConnectYDataLine;
    }

    public void setNeedDrawConnectYDataLine(boolean needDrawConnectYDataLine) {
        this.isNeedDrawConnectYDataLine = needDrawConnectYDataLine;
    }

    public boolean isNeedDrawYScale() {
        return this.isNeedDrawYScale;
    }

    public void setNeedDrawYScale(boolean needDrawYScale) {
        this.isNeedDrawYScale = needDrawYScale;
    }

    public int getDefaultTextSize() {
        return this.defaultTextSize;
    }

    public void setDefaultTextSize(int defaultTextSize) {
        this.defaultTextSize = defaultTextSize;
    }

    public String getyLableText() {
        return this.yLableText;
    }

    public void setyLableText(String yLableText) {
        this.yLableText = yLableText;
    }

    public int getyLableTextColor() {
        return this.yLableTextColor;
    }

    public void setyLableTextColor(int yLableTextColor) {
        this.yLableTextColor = yLableTextColor;
    }

    public int getxLableTextColor() {
        return this.xLableTextColor;
    }

    public void setxLableTextColor(int xLableTextColor) {
        this.xLableTextColor = xLableTextColor;
    }

    public boolean isNeedBg() {
        return this.isNeedBg;
    }

    public void setNeedBg(boolean needBg) {
        this.isNeedBg = needBg;
    }

    public int getDefaultStrokeWidth() {
        return this.defaultStrokeWidth;
    }

    public void setDefaultStrokeWidth(int defaultStrokeWidth) {
        this.defaultStrokeWidth = defaultStrokeWidth;
    }

    public BarChartView(Context context) {
        this(context, null);
    }

    public BarChartView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BarChartView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray typedValue = context.obtainStyledAttributes(attrs, R.styleable.BarChartView);
        this.axisMarginHeight = typedValue.getDimensionPixelSize(R.styleable.BarChartView_axisMarginHeight, DensityUtils.dip2px(this.mContext, 10.0f));
        this.defaultTextSize = typedValue.getDimensionPixelSize(R.styleable.BarChartView_defaultTextSize, DensityUtils.sp2px(this.mContext, 14.0f));
        this.yLableTextColor = typedValue.getColor(R.styleable.BarChartView_yLableTextColor, -6711139);
        this.defaultColor = typedValue.getColor(R.styleable.BarChartView_yLableTextColor, -11368457);
        this.xLableTextColor = typedValue.getColor(R.styleable.BarChartView_xLableTextColor, -6711139);
        this.axisColor = typedValue.getColor(R.styleable.BarChartView_axisColor, -6711139);
        this.isNeedBg = typedValue.getBoolean(R.styleable.BarChartView_isNeedBg, true);
        this.yLableText = typedValue.getString(R.styleable.BarChartView_yLableText);
        this.axisXItemWidth = typedValue.getDimensionPixelSize(R.styleable.BarChartView_axisXItemWidth, DensityUtils.dip2px(this.mContext, 20.0f));
        this.defaultStrokeWidth = typedValue.getDimensionPixelSize(R.styleable.LineChartView_defaultStrokeWidth, DensityUtils.dip2px(this.mContext, 1.0f));
        this.bgColor = typedValue.getColor(R.styleable.BarChartView_bgColor, -11368457);
        this.isNeedDrawConnectYDataLine = typedValue.getBoolean(R.styleable.BarChartView_isNeedDrawConnectYDataLine, false);
        this.connectLineColor = typedValue.getColor(R.styleable.BarChartView_connectLineColor, -11368457);
        this.dottedLineWidth = typedValue.getDimensionPixelSize(R.styleable.BarChartView_dottedLineWidth, DensityUtils.dip2px(this.mContext, 3.0f));
        this.isNeedDrawYScale = typedValue.getBoolean(R.styleable.BarChartView_isNeedDrawYScale, false);
        this.init();
    }

    private void init() {
        this.mDataLinePaint = new Paint();
        this.mScaleLinePaint = new Paint();
        this.mDataLinePaint.setAntiAlias(true);
        this.mDataLinePaint.setStrokeWidth((float)this.defaultStrokeWidth);
        this.mDataLinePaint.setColor(this.defaultColor);
        this.mScaleLinePaint.setAntiAlias(true);
        this.mScaleLinePaint.setStrokeWidth((float)this.defaultStrokeWidth);
        this.mScaleLinePaint.setColor(this.axisColor);
        this.yTextLablePaint = new Paint();
        this.yTextLablePaint.setAntiAlias(true);
        this.yTextLablePaint.setTextSize((float)this.defaultTextSize);
        this.yTextLablePaint.setColor(this.yLableTextColor);
        this.xTextLablePaint = new Paint();
        this.xTextLablePaint.setAntiAlias(true);
        this.xTextLablePaint.setTextSize((float)this.defaultTextSize);
        this.xTextLablePaint.setColor(this.xLableTextColor);
        this.yDataPaint = new Paint();
        this.yDataPaint.setAntiAlias(true);
        this.yDataPaint.setTextSize((float)this.defaultTextSize);
        this.yDataPaint.setColor(this.defaultColor);
        this.bgPaint = new Paint();
        this.bgPaint.setAntiAlias(true);
        this.rect = new RectF();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initMeasure();
    }

    private void initMeasure() {
        this.viewWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        this.viewHeight = DensityUtils.px2dip(this.mContext, this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        this.yLableWidth = this.yTextLablePaint.measureText(this.yLableText);
        this.xLableHeight = DensityUtils.getFontHeight(this.xTextLablePaint, this.mList.get(0).getDate()) + (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight);
        this.yLength = DensityUtils.dip2px(this.mContext, this.viewHeight - (float)this.axisMarginHeight - this.xLableHeight);
        this.startX = this.getPaddingLeft();
        this.startY = this.getPaddingTop();
        this.xMarginWidth = this.yLableWidth > this.firstDataWidth ? this.yLableWidth / 2.0f : this.firstDataWidth / 2.0f;
        this.xLength = (this.viewWidth - this.xMarginWidth) / (float)this.mList.size();
        float maxWidth = this.yDataPaint.measureText(String.valueOf(this.mList.get(0).getValue()));
        float currentWidth = 0.0f;
        for (int i = 0; i < this.mList.size(); ++i) {
            currentWidth = this.yDataPaint.measureText(String.valueOf(this.mList.get(i).getValue()));
            if (!(maxWidth < currentWidth)) continue;
            maxWidth = currentWidth;
        }
        this.firstDataWidth = maxWidth + (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight);
        this.startPointX = this.startX + this.firstDataWidth;
        this.startPointY = this.startY + DensityUtils.getFontHeight(this.yTextLablePaint, this.yLableText) + (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight) + this.yLength;
        this.yDataHeight = DensityUtils.getFontHeight(this.yTextLablePaint, this.mList.get(0).getValue());
        this.getPointRoords();
    }

    private void getPointRoords() {
        int i;
        float averHeight = 0.0f;
        float max = Float.parseFloat(this.mList.get(0).getValue());
        for (i = 0; i < this.mList.size(); ++i) {
            this.mList.get(i).setxAxis(this.startPointX + (float)i * this.xLength);
            if (!(max < Float.parseFloat(this.mList.get(i).getValue()))) continue;
            max = Float.parseFloat(this.mList.get(i).getValue());
        }
        for (i = 0; i < this.mList.size(); ++i) {
            averHeight = (this.yLength - (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight) - this.yDataHeight) / max;
            this.mList.get(i).setyAxis(this.startPointY - averHeight * Float.parseFloat(this.mList.get(i).getValue()));
        }
    }

    public void setData(List<ChartBean> list) {
        this.mList = list;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawYLable(canvas);
        this.drawXLable(canvas);
        this.drawXLine(canvas);
        this.drawYLine(canvas);
        this.drawYBarChart(canvas);
        this.drawYData(canvas);
        if (this.isNeedDrawConnectYDataLine) {
            this.drawConnectYDataLine(canvas);
        }
        if (this.isNeedDrawYScale) {
            this.drawYScale(canvas);
        }
    }

    private void drawYScale(Canvas canvas) {
        float textHeight = DensityUtils.getFontHeight(this.yTextLablePaint, this.mList.get(0).getValue());
        for (int i = 0; i < this.mList.size(); ++i) {
            float yValueWidth = this.yTextLablePaint.measureText(this.mList.get(i).getValue());
            canvas.drawText(this.mList.get(i).getValue(), this.startPointX - yValueWidth - (float)DensityUtils.dip2px(this.mContext, 5.0f), this.mList.get(i).getyAxis() + textHeight / 2.0f, this.yTextLablePaint);
        }
    }

    private void drawConnectYDataLine(Canvas canvas) {
        this.mScaleLinePaint.setColor(this.connectLineColor);
        for (int i = 1; i < this.mList.size(); ++i) {
            if (this.drawConnectLineType == DrawConnectLineType.DrawFullLine) {
                canvas.drawLine(this.startPointX, this.mList.get(i).getyAxis(), this.mList.get(i).getxAxis(), this.mList.get(i).getyAxis(), this.mScaleLinePaint);
                continue;
            }
            if (this.drawConnectLineType != DrawConnectLineType.DrawDottedLine) continue;
            this.setLayerType(1, null);
            DashPathEffect pathEffect = new DashPathEffect(new float[]{5.0f, 5.0f}, 0.0f);
            this.mScaleLinePaint.setPathEffect((PathEffect)pathEffect);
            if (Float.parseFloat(this.mList.get(i).getValue()) == 0.0f) continue;
            canvas.drawLine(this.startPointX, this.mList.get(i).getyAxis(), this.mList.get(i).getxAxis() - (float)this.axisXItemWidth, this.mList.get(i).getyAxis(), this.mScaleLinePaint);
        }
        this.mScaleLinePaint.setColor(this.axisColor);
        this.mScaleLinePaint.setPathEffect(null);
    }

    private void drawYBarChart(Canvas canvas) {
        if (this.isNeedBg) {
            this.bgPaint.setColor(this.bgColor);
        } else {
            this.bgPaint.setColor(this.axisColor);
            this.bgPaint.setStrokeWidth((float)this.defaultStrokeWidth);
            this.bgPaint.setStyle(Paint.Style.STROKE);
        }
        for (int i = 1; i < this.mList.size(); ++i) {
            this.rect.left = this.mList.get(i).getxAxis() - (float)this.axisXItemWidth;
            this.rect.top = this.mList.get(i).getyAxis();
            this.rect.right = this.mList.get(i).getxAxis() + (float)this.axisXItemWidth;
            this.rect.bottom = this.startPointY;
            canvas.drawRect(this.rect, this.bgPaint);
        }
    }

    private void drawYData(Canvas canvas) {
        for (int i = 1; i < this.mList.size(); ++i) {
            this.yDataWidth = this.yDataPaint.measureText(String.valueOf(this.mList.get(i).getValue()));
            this.yDataPaint.setColor(this.defaultColor);
            canvas.drawText(String.valueOf(this.mList.get(i).getValue()), this.mList.get(i).getxAxis() - this.yDataWidth / 2.0f, this.mList.get(i).getyAxis() - (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight), this.yDataPaint);
        }
    }

    private void drawYLable(Canvas canvas) {
        float yLableTextWidth = this.yTextLablePaint.measureText(this.yLableText);
        canvas.drawText(this.yLableText, this.startPointX - yLableTextWidth / 2.0f, this.startPointY - this.yLength - (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight), this.yTextLablePaint);
    }

    private void drawXLable(Canvas canvas) {
        for (int i = 0; i < this.mList.size(); ++i) {
            float xLableWidth = this.xTextLablePaint.measureText(this.mList.get(i).getDate());
            this.xTextLablePaint.setColor(this.xLableTextColor);
            canvas.drawText(this.mList.get(i).getDate(), this.startPointX - xLableWidth / 2.0f + (float)i * this.xLength, this.startPointY + DensityUtils.getFontHeight(this.xTextLablePaint, this.mList.get(i).getDate()) + (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight), this.xTextLablePaint);
        }
    }

    private void drawYLine(Canvas canvas) {
        canvas.drawLine(this.startPointX, this.startPointY, this.startPointX, this.startPointY - this.yLength, this.mScaleLinePaint);
    }

    private void drawXLine(Canvas canvas) {
        canvas.drawLine(this.startPointX, this.startPointY, this.startPointX + this.viewWidth - this.xMarginWidth, this.startPointY, this.mScaleLinePaint);
    }
}

