/*
 * Decompiled with CFR 0.152.
 */
package com.veken.chartview;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import java.text.DecimalFormat;

public class DensityUtils {
    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static float getFontHeight(Paint paint, String text) {
        Rect rect = new Rect();
        paint.getTextBounds(text, 0, text.length(), rect);
        return rect.height();
    }

    public static String float2Format(float num) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(num);
    }

    public static String floatFormat(float num) {
        DecimalFormat df = new DecimalFormat("0");
        return df.format(num);
    }
}

