/*
 * Decompiled with CFR 0.152.
 */
package com.veken.chartview.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.veken.chartview.DensityUtils;
import com.veken.chartview.bean.PieChartBean;
import com.veken.linecharviewmodule.R;
import java.util.ArrayList;
import java.util.List;

public class PieChartView
extends View {
    private Paint arcPaint;
    private Paint textPaint;
    private Paint insidePaint;
    private int textColor;
    private boolean isTextOutCircle = true;
    private Rect dataTextBound = new Rect();
    private int radius;
    private float insideRadiusPercent;
    private boolean isNeedInside = false;
    private String insideText = "";
    private int insideBgColor;
    private int insideTextColor;
    private int insideTextSize;
    private float[] angle;
    private RectF rectF;
    private Rect insideRect;
    private Context mContext;
    private float pointCircleX;
    private float pointCircleY;
    private float textOutCircleMargin;
    private float progress = 360.0f;
    private float maxText;
    private List<PieChartBean> mList = new ArrayList<PieChartBean>();

    public float getInsideRadiusPercent() {
        return this.insideRadiusPercent;
    }

    public void setInsideRadiusPercent(float insideRadiusPercent) {
        this.insideRadiusPercent = insideRadiusPercent;
    }

    public int getInsideTextColor() {
        return this.insideTextColor;
    }

    public void setInsideTextColor(int insideTextColor) {
        this.insideTextColor = insideTextColor;
    }

    public int getInsideTextSize() {
        return this.insideTextSize;
    }

    public void setInsideTextSize(int insideTextSize) {
        this.insideTextSize = insideTextSize;
    }

    public boolean isTextOutCircle() {
        return this.isTextOutCircle;
    }

    public void setTextOutCircle(boolean textOutCircle) {
        this.isTextOutCircle = textOutCircle;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public boolean isNeedInside() {
        return this.isNeedInside;
    }

    public void setNeedInside(boolean needInside) {
        this.isNeedInside = needInside;
    }

    public String getInsideText() {
        return this.insideText;
    }

    public void setInsideText(String insideText) {
        this.insideText = insideText;
    }

    public int getInsideBgColor() {
        return this.insideBgColor;
    }

    public void setInsideBgColor(int insideBgColor) {
        this.insideBgColor = insideBgColor;
    }

    public PieChartView(Context context) {
        this(context, null);
    }

    public PieChartView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PieChartView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PieChartView);
        this.textColor = typedArray.getColor(R.styleable.PieChartView_textColor, -1);
        this.textOutCircleMargin = typedArray.getDimensionPixelSize(R.styleable.PieChartView_textOutCircleMargin, 5);
        this.insideRadiusPercent = typedArray.getFloat(R.styleable.PieChartView_insideRadiusPercent, 0.5f);
        this.isNeedInside = typedArray.getBoolean(R.styleable.PieChartView_isNeedInside, true);
        this.insideText = typedArray.getString(R.styleable.PieChartView_insideText);
        this.insideBgColor = typedArray.getColor(R.styleable.PieChartView_insideBgColor, -1);
        this.insideTextSize = typedArray.getDimensionPixelSize(R.styleable.PieChartView_insideTextSize, 20);
        this.insideTextColor = typedArray.getColor(R.styleable.PieChartView_insideTextColor, 0);
        this.init();
    }

    private void init() {
        this.radius = DensityUtils.dip2px(this.mContext, this.radius);
        this.textOutCircleMargin = DensityUtils.dip2px(this.mContext, this.textOutCircleMargin);
        this.insideTextSize = DensityUtils.dip2px(this.mContext, this.insideTextSize);
        this.arcPaint = new Paint();
        this.arcPaint.setAntiAlias(true);
        this.arcPaint.setStyle(Paint.Style.FILL);
        this.textPaint = new Paint();
        this.textPaint.setColor(-16777216);
        this.textPaint.setTextSize((float)DensityUtils.dip2px(this.mContext, 14.0f));
        this.insidePaint = new Paint();
        this.insidePaint.setAntiAlias(true);
        this.insidePaint.setColor(this.insideBgColor);
        this.insidePaint.setTextSize((float)this.insideTextSize);
        this.insideRect = new Rect();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int wideSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int wideMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (wideMode == 0x40000000) {
            width = wideSize;
        } else {
            width = this.radius * 2 + this.getPaddingLeft() + this.getPaddingRight();
            if (wideMode == Integer.MIN_VALUE) {
                width = Math.min(width, wideSize);
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            height = this.radius * 2 + this.getPaddingTop() + this.getPaddingBottom();
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
        this.pointCircleX = width / 2;
        this.pointCircleY = height / 2;
        this.textPaint.getTextBounds(String.valueOf(DensityUtils.floatFormat(this.maxText * 100.0f)) + "%", 0, String.valueOf(DensityUtils.floatFormat(this.maxText * 100.0f) + "%").length(), this.dataTextBound);
        float textMargin = this.textOutCircleMargin + (float)Math.max(this.dataTextBound.width(), this.dataTextBound.height());
        this.radius = (int)((float)(width / 2) - textMargin);
        this.rectF = new RectF(this.pointCircleX - (float)this.radius, this.pointCircleY - (float)this.radius, this.pointCircleX + (float)this.radius, this.pointCircleY + (float)this.radius);
        this.insidePaint.getTextBounds(this.insideText, 0, this.insideText.length(), this.insideRect);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawArc(canvas);
        if (this.isNeedInside) {
            this.insidePaint.setColor(this.insideBgColor);
            canvas.drawCircle(this.pointCircleX, this.pointCircleY, (float)this.radius * this.insideRadiusPercent, this.insidePaint);
            this.insidePaint.setColor(this.insideTextColor);
            if (!TextUtils.isEmpty((CharSequence)this.insideText)) {
                canvas.drawText(this.insideText, this.pointCircleX - (float)(this.insideRect.width() / 2), this.pointCircleY + (float)(this.insideRect.height() / 2), this.insidePaint);
            }
        }
    }

    private void drawArc(Canvas canvas) {
        float startAngle = 0.0f;
        for (int i = 0; i < this.mList.size(); ++i) {
            float sweepAngle = i != this.mList.size() - 1 ? this.angle[i] * 360.0f : 360.0f - startAngle;
            if (sweepAngle == 0.0f) continue;
            this.arcPaint.setColor(this.mList.get(i).getColor());
            if (this.progress - startAngle >= 0.0f) {
                canvas.drawArc(this.rectF, startAngle, this.progress - startAngle, true, this.arcPaint);
                float centerAngle = startAngle + sweepAngle / 2.0f;
                float endAngle = startAngle + sweepAngle;
                this.drawText(canvas, centerAngle, endAngle, DensityUtils.floatFormat(this.angle[i] * 100.0f) + "%");
            }
            startAngle += sweepAngle;
        }
    }

    private void drawText(Canvas canvas, float centerAngle, float endAngle, String s) {
        this.textPaint.getTextBounds(s, 0, s.length(), this.dataTextBound);
        float x = 0.0f;
        float y = 0.0f;
        if (centerAngle >= 0.0f && centerAngle < 90.0f) {
            if (this.isTextOutCircle) {
                x = this.pointCircleX + (float)Math.cos(Math.toRadians(centerAngle)) * ((float)this.radius + this.textOutCircleMargin);
                y = this.pointCircleY + (float)Math.sin(Math.toRadians(centerAngle)) * ((float)this.radius + this.textOutCircleMargin);
                if (endAngle >= 90.0f && endAngle < 135.0f) {
                    canvas.drawText(s, x, y + (float)(this.dataTextBound.height() / 2), this.textPaint);
                } else {
                    canvas.drawText(s, x, y + (float)this.dataTextBound.height(), this.textPaint);
                }
            }
        } else if (centerAngle >= 90.0f && centerAngle < 180.0f) {
            if (this.isTextOutCircle) {
                x = this.pointCircleX - (float)Math.cos(Math.toRadians(180.0f - centerAngle)) * ((float)this.radius + this.textOutCircleMargin);
                y = this.pointCircleY + (float)Math.sin(Math.toRadians(180.0f - centerAngle)) * ((float)this.radius + this.textOutCircleMargin);
                canvas.drawText(s, x - (float)this.dataTextBound.width(), y + (float)this.dataTextBound.height(), this.textPaint);
            }
        } else if (centerAngle >= 180.0f && centerAngle < 270.0f) {
            if (this.isTextOutCircle) {
                x = this.pointCircleX - (float)Math.cos(Math.toRadians(centerAngle - 180.0f)) * ((float)this.radius + this.textOutCircleMargin);
                y = this.pointCircleY - (float)Math.sin(Math.toRadians(centerAngle - 180.0f)) * ((float)this.radius + this.textOutCircleMargin);
                canvas.drawText(s, x - (float)this.dataTextBound.width(), y, this.textPaint);
            }
        } else if (centerAngle >= 270.0f && centerAngle <= 360.0f && this.isTextOutCircle) {
            x = this.pointCircleX + (float)Math.cos(Math.toRadians(360.0f - centerAngle)) * ((float)this.radius + this.textOutCircleMargin);
            y = this.pointCircleY - (float)Math.sin(Math.toRadians(360.0f - centerAngle)) * ((float)this.radius + this.textOutCircleMargin);
            if (endAngle >= 270.0f && endAngle <= 315.0f) {
                canvas.drawText(s, x - (float)(this.dataTextBound.width() / 2), y, this.textPaint);
            } else {
                canvas.drawText(s, x, y, this.textPaint);
            }
        }
    }

    public void setData(List<PieChartBean> list) {
        int i;
        this.mList = list;
        this.angle = new float[this.mList.size()];
        float sum = 0.0f;
        for (i = 0; i < this.mList.size(); ++i) {
            sum += this.mList.get(i).getValue();
        }
        for (i = 0; i < this.mList.size(); ++i) {
            this.angle[i] = Float.parseFloat(DensityUtils.float2Format(this.mList.get(i).getValue() / sum));
        }
        if (this.angle != null && this.angle.length > 0) {
            for (i = 0; i < this.angle.length - 1; ++i) {
                this.maxText = this.angle[i];
                if (!(this.maxText < this.angle[i + 1])) continue;
                this.maxText = this.angle[i + 1];
            }
        }
    }

    public void setIsNeedAnimation(boolean isNeedAnimation, long duration) {
        if (isNeedAnimation) {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
            animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    PieChartView.this.progress = ((Float)animation.getAnimatedValue()).floatValue();
                    PieChartView.this.invalidate();
                }
            });
            animator.setDuration(duration);
            animator.start();
        }
    }

    public void setIsNeedAnimation(boolean isNeedAnimation) {
        if (!isNeedAnimation) {
            this.progress = 360.0f;
        }
    }
}

