/*
 * Decompiled with CFR 0.152.
 */
package com.veken.chartview.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.veken.chartview.DensityUtils;
import com.veken.chartview.bean.ChartBean;
import com.veken.chartview.drawtype.DrawBgType;
import com.veken.chartview.drawtype.DrawConnectLineType;
import com.veken.chartview.drawtype.DrawLineType;
import com.veken.linecharviewmodule.R;
import java.util.ArrayList;
import java.util.List;

public class LineChartView
extends View {
    private float xLength;
    private float yLength;
    private float startPointX = 0.0f;
    private float startPointY = 0.0f;
    private float xMarginWidth;
    private float startX = 0.0f;
    private float startY = 0.0f;
    private List<ChartBean> mList = new ArrayList<ChartBean>();
    private int showPicResource = R.mipmap.click_icon;
    private String yLableText;
    private Paint mScaleLinePaint;
    private Paint mDataLinePaint;
    private Paint transparentPaint = new Paint();
    private Paint pointSelectedPaint = new Paint();
    private Paint pointPaint = new Paint();
    private Paint yTextLablePaint;
    private Paint xTextLablePaint;
    private Paint yDataPaint;
    private Paint clickPaint;
    private Paint bgPaint;
    private int axisMarginHeight;
    private int pointMarginHeight;
    private int textAndPicMargin;
    private float yDataWidth;
    private int defaultTextSize = 14;
    private int pointDefaultRadius = 4;
    private int pointClickRadius = 2;
    private int defaultStrokeWidth = 1;
    private int yLableTextColor;
    private int defaultColor;
    private int xLableTextColor;
    private int axisColor;
    private int clickBgColor;
    private int connectLineColor;
    private int startColor;
    private int endColor;
    private int[] mColors;
    private boolean isClick;
    private int clickIndex = -1;
    private boolean clickable;
    private boolean isNeedBg;
    private Context mContext;
    private Bitmap bitmap;
    private Bitmap resizeBitmap;
    private float firstDataWidth;
    private float yLableWidth;
    private float viewWidth;
    private float viewHeight;
    private float clickBgHeight;
    private float clickBgWidth;
    private float yDataHeight;
    private float xLableHeight;
    private int dottedLineWidth;
    private Path bgPath;
    private boolean isNeedDrawConnectYDataLine;
    private DrawBgType drawBgType;
    private DrawConnectLineType drawConnectLineType;
    private DrawLineType drawLineType = DrawLineType.Draw_Line;
    private Path curvePath;
    private Point startp;
    private Point endp;
    private Point p3;
    private Point p4;
    private RectF rectF;
    int i = 0;

    public DrawLineType getDrawLineType() {
        return this.drawLineType;
    }

    public void setDrawLineType(DrawLineType drawLineType) {
        this.drawLineType = drawLineType;
    }

    public int getConnectLineColor() {
        return this.connectLineColor;
    }

    public void setConnectLineColor(int connectLineColor) {
        this.connectLineColor = connectLineColor;
    }

    public int getDottedLineWidth() {
        return this.dottedLineWidth;
    }

    public void setDottedLineWidth(int dottedLineWidth) {
        this.dottedLineWidth = dottedLineWidth;
    }

    public DrawBgType getDrawBgType() {
        return this.drawBgType;
    }

    public void setDrawBgType(DrawBgType drawBgType) {
        this.drawBgType = drawBgType;
    }

    public DrawConnectLineType getDrawConnectLineType() {
        return this.drawConnectLineType;
    }

    public void setDrawConnectLineType(DrawConnectLineType drawConnectLineType) {
        this.drawConnectLineType = drawConnectLineType;
    }

    public int getClickBgColor() {
        return this.clickBgColor;
    }

    public void setClickBgColor(int clickBgColor) {
        this.clickBgColor = clickBgColor;
    }

    public int getPointClickRadius() {
        return this.pointClickRadius;
    }

    public void setPointClickRadius(int pointClickRadius) {
        this.pointClickRadius = pointClickRadius;
    }

    public boolean isNeedDrawConnectYDataLine() {
        return this.isNeedDrawConnectYDataLine;
    }

    public void setNeedDrawConnectYDataLine(boolean needDrawConnectYDataLine) {
        this.isNeedDrawConnectYDataLine = needDrawConnectYDataLine;
    }

    public int getPointDefaultRadius() {
        return this.pointDefaultRadius;
    }

    public void setPointDefaultRadius(int pointDefaultRadius) {
        this.pointDefaultRadius = pointDefaultRadius;
    }

    public int getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(int axisColor) {
        this.axisColor = axisColor;
    }

    public int getShowPicResource() {
        return this.showPicResource;
    }

    public void setShowPicResource(int showPicResource) {
        this.showPicResource = showPicResource;
    }

    public int getDefaultTextSize() {
        return this.defaultTextSize;
    }

    public void setDefaultTextSize(int defaultTextSize) {
        this.defaultTextSize = defaultTextSize;
    }

    public String getyLableText() {
        return this.yLableText;
    }

    public void setyLableText(String yLableText) {
        this.yLableText = yLableText;
    }

    public int getPointMarginHeight() {
        return this.pointMarginHeight;
    }

    public void setPointMarginHeight(int pointMarginHeight) {
        this.pointMarginHeight = pointMarginHeight;
    }

    public int getyLableTextColor() {
        return this.yLableTextColor;
    }

    public void setyLableTextColor(int yLableTextColor) {
        this.yLableTextColor = yLableTextColor;
    }

    public int getxLableTextColor() {
        return this.xLableTextColor;
    }

    public void setxLableTextColor(int xLableTextColor) {
        this.xLableTextColor = xLableTextColor;
    }

    public int getTextAndPicMargin() {
        return this.textAndPicMargin;
    }

    public void setTextAndPicMargin(int textAndPicMargin) {
        this.textAndPicMargin = textAndPicMargin;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean isNeedBg() {
        return this.isNeedBg;
    }

    public void setNeedBg(boolean needBg) {
        this.isNeedBg = needBg;
    }

    public LineChartView(Context context) {
        this(context, null);
    }

    public LineChartView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LineChartView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray typedValue = context.obtainStyledAttributes(attrs, R.styleable.LineChartView);
        this.showPicResource = typedValue.getResourceId(R.styleable.LineChartView_showPicResource, R.mipmap.click_icon);
        this.axisMarginHeight = typedValue.getDimensionPixelSize(R.styleable.LineChartView_marginHeight, DensityUtils.dip2px(this.mContext, 10.0f));
        this.pointMarginHeight = typedValue.getDimensionPixelSize(R.styleable.LineChartView_pointMarginHeight, DensityUtils.dip2px(this.mContext, 20.0f));
        this.defaultTextSize = typedValue.getDimensionPixelSize(R.styleable.LineChartView_defaultTextSize, DensityUtils.sp2px(this.mContext, 14.0f));
        this.pointDefaultRadius = typedValue.getDimensionPixelSize(R.styleable.LineChartView_pointDefaultRadius, DensityUtils.dip2px(this.mContext, 3.0f));
        this.pointClickRadius = typedValue.getDimensionPixelSize(R.styleable.LineChartView_pointClickRadius, DensityUtils.dip2px(this.mContext, 2.0f));
        this.defaultStrokeWidth = typedValue.getDimensionPixelSize(R.styleable.LineChartView_defaultStrokeWidth, DensityUtils.dip2px(this.mContext, 1.0f));
        this.yLableTextColor = typedValue.getColor(R.styleable.LineChartView_yLableTextColor, -6711139);
        this.defaultColor = typedValue.getColor(R.styleable.LineChartView_defaultColor, -11368457);
        this.xLableTextColor = typedValue.getColor(R.styleable.LineChartView_xLableTextColor, -6711139);
        this.axisColor = typedValue.getColor(R.styleable.LineChartView_axisColor, -6711139);
        this.textAndPicMargin = typedValue.getDimensionPixelSize(R.styleable.LineChartView_textAndPicMargin, DensityUtils.dip2px(this.mContext, 10.0f));
        this.clickBgColor = typedValue.getColor(R.styleable.LineChartView_clickBgColor, -11368457);
        this.startColor = typedValue.getColor(R.styleable.LineChartView_startColor, 549449727);
        this.endColor = typedValue.getColor(R.styleable.LineChartView_endColor, -11368457);
        this.clickable = typedValue.getBoolean(R.styleable.LineChartView_clickable, true);
        this.isNeedBg = typedValue.getBoolean(R.styleable.LineChartView_isNeedBg, true);
        this.yLableText = typedValue.getString(R.styleable.LineChartView_yLableText);
        this.isNeedDrawConnectYDataLine = typedValue.getBoolean(R.styleable.LineChartView_isNeedDrawConnectYDataLine, false);
        this.dottedLineWidth = typedValue.getDimensionPixelSize(R.styleable.LineChartView_dottedLineWidth, DensityUtils.dip2px(this.mContext, 3.0f));
        this.connectLineColor = typedValue.getColor(R.styleable.LineChartView_connectLineColor, -11368457);
        this.mColors = new int[2];
        this.mColors[0] = this.startColor;
        this.mColors[1] = this.endColor;
        this.init();
    }

    private void init() {
        this.mDataLinePaint = new Paint();
        this.mScaleLinePaint = new Paint();
        this.mDataLinePaint.setAntiAlias(true);
        this.mDataLinePaint.setStrokeWidth((float)this.defaultStrokeWidth);
        this.mDataLinePaint.setColor(this.defaultColor);
        this.mScaleLinePaint.setAntiAlias(true);
        this.mScaleLinePaint.setStrokeWidth((float)this.defaultStrokeWidth);
        this.mScaleLinePaint.setColor(this.axisColor);
        this.transparentPaint.setColor(-1);
        this.transparentPaint.setStyle(Paint.Style.FILL);
        this.transparentPaint.setStrokeWidth((float)this.defaultStrokeWidth);
        this.pointSelectedPaint.setAntiAlias(true);
        this.pointSelectedPaint.setStrokeWidth((float)this.defaultStrokeWidth);
        this.pointSelectedPaint.setStyle(Paint.Style.STROKE);
        this.pointPaint.setAntiAlias(true);
        this.pointPaint.setStyle(Paint.Style.STROKE);
        this.pointPaint.setColor(this.defaultColor);
        this.pointPaint.setStrokeWidth((float)this.defaultStrokeWidth);
        this.pointClickRadius = DensityUtils.dip2px(this.mContext, this.pointClickRadius);
        this.pointDefaultRadius = DensityUtils.dip2px(this.mContext, this.pointDefaultRadius);
        this.yTextLablePaint = new Paint();
        this.yTextLablePaint.setAntiAlias(true);
        this.yTextLablePaint.setTextSize((float)this.defaultTextSize);
        this.yTextLablePaint.setColor(this.yLableTextColor);
        this.xTextLablePaint = new Paint();
        this.xTextLablePaint.setAntiAlias(true);
        this.xTextLablePaint.setTextSize((float)this.defaultTextSize);
        this.xTextLablePaint.setColor(this.xLableTextColor);
        this.yDataPaint = new Paint();
        this.yDataPaint.setAntiAlias(true);
        this.yDataPaint.setTextSize((float)this.defaultTextSize);
        this.yDataPaint.setColor(this.defaultColor);
        this.clickPaint = new Paint();
        this.bgPath = new Path();
        this.bgPaint = new Paint();
        this.bgPaint.setAntiAlias(true);
        this.curvePath = new Path();
        this.startp = new Point();
        this.endp = new Point();
        this.p3 = new Point();
        this.p4 = new Point();
        this.rectF = new RectF();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initMeasure();
    }

    private void initMeasure() {
        this.viewWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        this.viewHeight = DensityUtils.px2dip(this.mContext, this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        this.yLableWidth = !TextUtils.isEmpty((CharSequence)this.yLableText) ? this.yTextLablePaint.measureText(this.yLableText) : this.yTextLablePaint.measureText("");
        this.xLableHeight = DensityUtils.getFontHeight(this.xTextLablePaint, this.mList.get(0).getDate()) + (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight);
        this.yLength = DensityUtils.dip2px(this.mContext, this.viewHeight - (float)this.axisMarginHeight - this.xLableHeight);
        this.startX = this.getPaddingLeft();
        this.startY = this.getPaddingTop();
        this.clickBgHeight = DensityUtils.getFontHeight(this.yDataPaint, this.mList.get(0).getValue()) + (float)DensityUtils.dip2px(this.mContext, this.textAndPicMargin);
        this.clickBgWidth = this.yDataPaint.measureText(this.mList.get(0).getValue()) + (float)DensityUtils.dip2px(this.mContext, this.textAndPicMargin);
        this.yDataHeight = DensityUtils.getFontHeight(this.yDataPaint, this.mList.get(0).getValue());
        float maxWidth = this.yDataPaint.measureText(String.valueOf(this.mList.get(0).getValue()));
        float currentWidth = 0.0f;
        for (int i = 0; i < this.mList.size(); ++i) {
            currentWidth = this.yDataPaint.measureText(String.valueOf(this.mList.get(i).getValue()));
            if (!(maxWidth < currentWidth)) continue;
            maxWidth = currentWidth;
        }
        this.firstDataWidth = maxWidth + (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight);
        this.xMarginWidth = this.yLableWidth > this.firstDataWidth ? this.yLableWidth / 2.0f : this.firstDataWidth / 2.0f;
        this.xLength = (this.viewWidth - this.xMarginWidth) / (float)this.mList.size();
        this.startPointX = this.startX + this.xMarginWidth;
        this.startPointY = this.startY + DensityUtils.getFontHeight(this.yTextLablePaint, this.yLableText) + (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight) + this.yLength;
    }

    private void getPoints() {
        int i;
        float averHeight = 0.0f;
        float max = Float.parseFloat(this.mList.get(0).getValue());
        for (i = 0; i < this.mList.size(); ++i) {
            this.mList.get(i).setxAxis(this.startPointX + (float)i * this.xLength);
            if (!(max < Float.parseFloat(this.mList.get(i).getValue()))) continue;
            max = Float.parseFloat(this.mList.get(i).getValue());
        }
        for (i = 0; i < this.mList.size(); ++i) {
            averHeight = (this.yLength - (float)DensityUtils.dip2px(this.mContext, this.pointMarginHeight) - this.clickBgHeight / 2.0f + this.yDataHeight / 2.0f) / max;
            this.mList.get(i).setyAxis(this.startPointY - averHeight * Float.parseFloat(this.mList.get(i).getValue()));
        }
    }

    public void setData(List<ChartBean> list) {
        this.mList = list;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawYLable(canvas);
        this.drawDataLines(canvas);
        this.drawXLable(canvas);
        if (this.isNeedBg) {
            this.drawBgColor(canvas);
        }
        this.drawXLine(canvas);
        this.drawYLine(canvas);
        if (this.isClick && this.clickable) {
            this.showClick(this.clickIndex, canvas);
        }
        this.drawYData(canvas);
        if (this.isNeedDrawConnectYDataLine) {
            this.drawConnectYDataLine(canvas);
        }
        this.drawDataPoints(canvas);
    }

    private void drawConnectYDataLine(Canvas canvas) {
        this.mScaleLinePaint.setColor(this.connectLineColor);
        for (int i = 0; i < this.mList.size(); ++i) {
            if (this.drawConnectLineType == DrawConnectLineType.DrawFullLine) {
                canvas.drawLine(this.startPointX, this.mList.get(i).getyAxis(), this.mList.get(i).getxAxis(), this.mList.get(i).getyAxis(), this.mScaleLinePaint);
                continue;
            }
            if (this.drawConnectLineType != DrawConnectLineType.DrawDottedLine) continue;
            float x = this.mList.get(i).getxAxis() - this.startPointX;
            float spaceWidth = DensityUtils.dip2px(this.mContext, 2.0f);
            int count = (int)(x / (spaceWidth + (float)this.dottedLineWidth));
            for (int j = 0; j < count; ++j) {
                canvas.drawLine(this.startPointX + (spaceWidth + (float)this.dottedLineWidth) * (float)j, this.mList.get(i).getyAxis(), this.startPointX + (spaceWidth + (float)this.dottedLineWidth) * (float)j + (float)this.dottedLineWidth, this.mList.get(i).getyAxis(), this.mScaleLinePaint);
            }
            canvas.drawLine(this.startPointX + (spaceWidth + (float)this.dottedLineWidth) * (float)count, this.mList.get(i).getyAxis(), this.mList.get(i).getxAxis(), this.mList.get(i).getyAxis(), this.mScaleLinePaint);
        }
    }

    private void drawBgColor(Canvas canvas) {
        LinearGradient hrLg = new LinearGradient(this.startPointX, this.startPointY, this.mList.get(0).getxAxis(), this.mList.get(0).getyAxis(), this.startColor, this.endColor, Shader.TileMode.CLAMP);
        this.bgPaint.setShader((Shader)hrLg);
        if (this.drawLineType == DrawLineType.Draw_Line) {
            this.bgPath.moveTo(this.startPointX, this.startPointY);
            for (int i = 0; i < this.mList.size(); ++i) {
                this.bgPath.lineTo(this.mList.get(i).getxAxis(), this.mList.get(i).getyAxis());
            }
            this.bgPath.lineTo(this.mList.get(this.mList.size() - 1).getxAxis(), this.startPointY);
            canvas.drawPath(this.bgPath, this.bgPaint);
        } else if (this.drawLineType == DrawLineType.Draw_Curve) {
            this.bgPaint.setStyle(Paint.Style.FILL);
            canvas.drawPath(this.drawCurveLine(), this.bgPaint);
        }
    }

    private void drawYData(Canvas canvas) {
        for (int i = 0; i < this.mList.size(); ++i) {
            this.yDataWidth = this.yDataPaint.measureText(String.valueOf(this.mList.get(i).getValue()));
            if (this.isClick && this.clickIndex == i && this.clickable) {
                this.yDataPaint.setColor(-1);
            } else {
                this.yDataPaint.setColor(this.defaultColor);
            }
            canvas.drawText(String.valueOf(this.mList.get(i).getValue()), this.mList.get(i).getxAxis() - this.yDataWidth / 2.0f, this.mList.get(i).getyAxis() - (float)DensityUtils.dip2px(this.mContext, this.pointMarginHeight), this.yDataPaint);
        }
    }

    private void drawYLable(Canvas canvas) {
        float yLableTextWidth = this.yTextLablePaint.measureText(this.yLableText);
        canvas.drawText(this.yLableText, this.startPointX - yLableTextWidth / 2.0f, this.startPointY - this.yLength - (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight), this.yTextLablePaint);
    }

    private void drawXLable(Canvas canvas) {
        for (int i = 0; i < this.mList.size(); ++i) {
            float xLableWidth = this.xTextLablePaint.measureText(this.mList.get(i).getDate());
            if (this.isClick && this.clickIndex == i && this.clickable) {
                this.xTextLablePaint.setColor(this.defaultColor);
            } else {
                this.xTextLablePaint.setColor(this.xLableTextColor);
            }
            canvas.drawText(this.mList.get(i).getDate(), this.startPointX - xLableWidth / 2.0f + (float)i * this.xLength, this.startPointY + DensityUtils.getFontHeight(this.xTextLablePaint, this.mList.get(i).getDate()) + (float)DensityUtils.dip2px(this.mContext, this.axisMarginHeight), this.xTextLablePaint);
        }
    }

    private void drawYLine(Canvas canvas) {
        for (int i = 0; i < this.mList.size(); ++i) {
            canvas.drawLine(this.startPointX + (float)i * this.xLength, this.startPointY, this.startPointX + (float)i * this.xLength, this.startPointY - this.yLength, this.mScaleLinePaint);
        }
    }

    private void drawXLine(Canvas canvas) {
        this.mScaleLinePaint.setColor(this.axisColor);
        canvas.drawLine(this.startPointX, this.startPointY, this.startPointX + this.viewWidth - this.xMarginWidth, this.startPointY, this.mScaleLinePaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float touchX = event.getX();
        for (int i = 0; i < this.mList.size(); ++i) {
            float dataX = this.mList.get(i).getxAxis();
            if (!(Math.abs(touchX - dataX) < this.xLength / 2.0f)) continue;
            this.isClick = true;
            this.clickIndex = i;
            this.invalidate();
        }
        return true;
    }

    private void drawDataLines(Canvas canvas) {
        this.getPoints();
        if (this.isNeedBg) {
            this.mDataLinePaint.setColor(this.endColor);
        } else {
            this.mDataLinePaint.setColor(this.defaultColor);
        }
        this.mDataLinePaint.setStyle(Paint.Style.STROKE);
        if (this.drawLineType == DrawLineType.Draw_Curve) {
            canvas.drawPath(this.drawCurveLine(), this.mDataLinePaint);
        } else if (this.drawLineType == DrawLineType.Draw_Line) {
            for (int i = 0; i < this.mList.size(); ++i) {
                if (i == this.mList.size() - 1) {
                    return;
                }
                canvas.drawLine(this.mList.get(i).getxAxis(), this.mList.get(i).getyAxis(), this.mList.get(i + 1).getxAxis(), this.mList.get(i + 1).getyAxis(), this.mDataLinePaint);
            }
        }
    }

    private Path drawCurveLine() {
        this.curvePath.reset();
        for (int i = 0; i < this.mList.size(); ++i) {
            if (i != this.mList.size() - 1) {
                if (i == 0) {
                    this.curvePath.moveTo(this.mList.get(0).getxAxis(), this.mList.get(0).getyAxis());
                }
                this.curvePath.cubicTo((this.mList.get(i).getxAxis() + this.mList.get(i + 1).getxAxis()) / 2.0f, this.mList.get(i).getyAxis(), (this.mList.get(i).getxAxis() + this.mList.get(i + 1).getxAxis()) / 2.0f, this.mList.get(i + 1).getyAxis(), this.mList.get(i + 1).getxAxis(), this.mList.get(i + 1).getyAxis());
                continue;
            }
            this.curvePath.lineTo(this.mList.get(this.mList.size() - 1).getxAxis(), this.startPointY);
            this.curvePath.lineTo(this.mList.get(0).getxAxis(), this.startPointY);
            this.curvePath.lineTo(this.mList.get(0).getxAxis(), this.mList.get(0).getyAxis());
        }
        return this.curvePath;
    }

    private void drawDataPoints(Canvas canvas) {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (this.isClick && this.clickIndex == i && this.clickable) {
                canvas.drawCircle(this.mList.get(this.clickIndex).getxAxis(), this.mList.get(this.clickIndex).getyAxis(), (float)(this.pointDefaultRadius + DensityUtils.dip2px(this.mContext, 2.0f)), this.transparentPaint);
                this.pointSelectedPaint.setColor(this.defaultColor);
                canvas.drawCircle(this.mList.get(this.clickIndex).getxAxis(), this.mList.get(this.clickIndex).getyAxis(), (float)(this.pointDefaultRadius + DensityUtils.dip2px(this.mContext, 2.0f)), this.pointSelectedPaint);
                this.pointPaint.setColor(this.defaultColor);
                this.pointPaint.setStyle(Paint.Style.FILL);
                this.pointPaint.setStrokeWidth((float)this.defaultStrokeWidth);
                canvas.drawCircle(this.mList.get(this.clickIndex).getxAxis(), this.mList.get(this.clickIndex).getyAxis(), (float)this.pointClickRadius, this.pointPaint);
                continue;
            }
            canvas.drawCircle(this.mList.get(i).getxAxis(), this.mList.get(i).getyAxis(), (float)this.pointDefaultRadius, this.transparentPaint);
            this.pointPaint.setColor(this.defaultColor);
            this.pointPaint.setStrokeWidth((float)this.defaultStrokeWidth);
            this.pointPaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle(this.mList.get(i).getxAxis(), this.mList.get(i).getyAxis(), (float)this.pointDefaultRadius, this.pointPaint);
        }
    }

    private void showClick(int index, Canvas canvas) {
        this.rectF.left = this.mList.get(index).getxAxis() - this.clickBgWidth / 2.0f;
        this.rectF.top = this.mList.get(index).getyAxis() - this.clickBgHeight / 2.0f - (float)DensityUtils.dip2px(this.mContext, this.pointMarginHeight);
        this.rectF.right = this.mList.get(index).getxAxis() + this.clickBgWidth / 2.0f;
        this.rectF.bottom = this.mList.get(index).getyAxis() - (float)DensityUtils.dip2px(this.mContext, this.pointMarginHeight) + (float)DensityUtils.dip2px(this.mContext, this.textAndPicMargin / 2) - this.yDataHeight / 2.0f;
        switch (this.drawBgType) {
            case DrawBackground: {
                this.clickPaint.setColor(this.clickBgColor);
                canvas.drawRect(this.rectF, this.clickPaint);
                break;
            }
            case DrawBitmap: {
                this.bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.showPicResource);
                this.resizeBitmap = LineChartView.resizeBitmap(this.bitmap, this.clickBgWidth, this.clickBgHeight);
                canvas.drawBitmap(this.resizeBitmap, null, this.rectF, this.clickPaint);
            }
        }
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, float w, float h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = w / (float)width;
        float scaleHeight = h / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public void recycleBitmap() {
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.bitmap.recycle();
        }
    }
}

