/*
 * Decompiled with CFR 0.152.
 */
package com.veinhorn.scrollgalleryview.loader.picasso;

import android.content.Context;
import android.widget.ImageView;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import com.veinhorn.scrollgalleryview.loader.MediaLoader;
import com.veinhorn.scrollgalleryview.loader.picasso.R;

public class PicassoImageLoader
implements MediaLoader {
    private String url;
    private Integer thumbnailWidth;
    private Integer thumbnailHeight;

    public PicassoImageLoader(String url) {
        this.url = url;
    }

    public PicassoImageLoader(String url, Integer thumbnailWidth, Integer thumbnailHeight) {
        this.url = url;
        this.thumbnailWidth = thumbnailWidth;
        this.thumbnailHeight = thumbnailHeight;
    }

    public boolean isImage() {
        return true;
    }

    public void loadMedia(Context context, ImageView imageView, MediaLoader.SuccessCallback callback) {
        Picasso.with((Context)context).load(this.url).placeholder(R.drawable.placeholder_image).into(imageView, (Callback)new ImageCallback(callback));
    }

    public void loadThumbnail(Context context, ImageView thumbnailView, MediaLoader.SuccessCallback callback) {
        Picasso.with((Context)context).load(this.url).resize(this.thumbnailWidth == null ? 100 : this.thumbnailWidth, this.thumbnailHeight == null ? 100 : this.thumbnailHeight).placeholder(R.drawable.placeholder_image).centerInside().into(thumbnailView, (Callback)new ImageCallback(callback));
    }

    private static class ImageCallback
    implements Callback {
        private final MediaLoader.SuccessCallback callback;

        public ImageCallback(MediaLoader.SuccessCallback callback) {
            this.callback = callback;
        }

        public void onSuccess() {
            this.callback.onSuccess();
        }

        public void onError() {
        }
    }
}

