/*
 * Decompiled with CFR 0.152.
 */
package com.veinhorn.scrollgalleryview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.media.ThumbnailUtils;
import android.os.Build;
import android.support.transition.Transition;
import android.support.transition.TransitionManager;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.veinhorn.scrollgalleryview.HackyViewPager;
import com.veinhorn.scrollgalleryview.MediaInfo;
import com.veinhorn.scrollgalleryview.R;
import com.veinhorn.scrollgalleryview.ScreenSlidePagerAdapter;
import com.veinhorn.scrollgalleryview.builder.GalleryBuilder;
import com.veinhorn.scrollgalleryview.builder.GalleryBuilderImpl;
import com.veinhorn.scrollgalleryview.loader.MediaLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScrollGalleryView
extends LinearLayout {
    private FragmentManager fragmentManager;
    private Context context;
    private Point displayProps;
    private ScreenSlidePagerAdapter pagerAdapter;
    private List<MediaInfo> mListOfMedia;
    private int thumbnailSize;
    private boolean zoomEnabled;
    private boolean isThumbnailsHidden;
    private boolean hideThumbnailsOnClick;
    private Integer hideThumbnailsAfterDelay;
    private LinearLayout thumbnailsContainer;
    private HorizontalScrollView horizontalScrollView;
    private ViewPager viewPager;
    private TextView imageDescription;
    private Transition thumbnailsTransition;
    private boolean useDefaultThumbnailsTransition;
    private boolean initOnce;
    private final ViewPager.SimpleOnPageChangeListener viewPagerChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            ScrollGalleryView.this.scroll(ScrollGalleryView.this.thumbnailsContainer.getChildAt(position));
            ScrollGalleryView.this.changeImageDescription(position);
        }
    };
    private final View.OnClickListener thumbnailOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            ScrollGalleryView.this.scroll(v);
            ScrollGalleryView.this.changeImageDescription(v.getId());
            ScrollGalleryView.this.viewPager.setCurrentItem(v.getId(), true);
        }
    };
    private OnImageClickListener onImageClickListener;
    private OnImageLongClickListener onImageLongClickListener;
    private OnImageClickListener innerOnImageClickListener = new OnImageClickListener(){

        @Override
        public void onClick(int position) {
            if (ScrollGalleryView.this.hideThumbnailsOnClick) {
                if (ScrollGalleryView.this.isThumbnailsHidden) {
                    ScrollGalleryView.this.showThumbnails();
                    ScrollGalleryView.this.isThumbnailsHidden = false;
                } else {
                    ScrollGalleryView.this.hideThumbnails();
                    ScrollGalleryView.this.isThumbnailsHidden = true;
                }
            }
            if (ScrollGalleryView.this.onImageClickListener != null) {
                ScrollGalleryView.this.onImageClickListener.onClick(position);
            }
        }
    };
    private OnImageLongClickListener innerOnImageLongClickListener = new OnImageLongClickListener(){

        @Override
        public void onClick(int position) {
            if (ScrollGalleryView.this.onImageLongClickListener != null) {
                ScrollGalleryView.this.onImageLongClickListener.onClick(position);
            }
        }
    };

    private void changeImageDescription(int position) {
        if (this.mListOfMedia.get(position) != null) {
            this.imageDescription.setText((CharSequence)this.mListOfMedia.get(position).getDescription());
        } else {
            this.imageDescription.setText((CharSequence)"");
        }
    }

    public ScrollGalleryView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.mListOfMedia = new ArrayList<MediaInfo>();
        this.setOrientation(1);
        this.displayProps = this.getDisplaySize();
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.scroll_gallery_view, (ViewGroup)this, true);
        this.horizontalScrollView = (HorizontalScrollView)this.findViewById(R.id.thumbnails_scroll_view);
        this.imageDescription = (TextView)this.findViewById(R.id.imageDescription);
        this.thumbnailsContainer = (LinearLayout)this.findViewById(R.id.thumbnails_container);
        this.thumbnailsContainer.setPadding(this.displayProps.x / 2, 0, this.displayProps.x / 2, 0);
    }

    public ScrollGalleryView setFragmentManager(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
        this.initializeViewPager();
        if (this.hideThumbnailsAfterDelay != null) {
            this.hideThumbnailsAfterDelay(this.hideThumbnailsAfterDelay);
        }
        return this;
    }

    public ViewPager getViewPager() {
        return this.viewPager;
    }

    public ScrollGalleryView addOnImageClickListener(OnImageClickListener onImageClickListener) {
        this.onImageClickListener = onImageClickListener;
        return this;
    }

    public ScrollGalleryView addOnImageLongClickListener(OnImageLongClickListener onImageLongClickListener) {
        this.onImageLongClickListener = onImageLongClickListener;
        return this;
    }

    public void addOnPageChangeListener(final ViewPager.OnPageChangeListener listener) {
        this.viewPager.clearOnPageChangeListeners();
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                listener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }

            public void onPageSelected(int position) {
                ScrollGalleryView.this.scroll(ScrollGalleryView.this.thumbnailsContainer.getChildAt(position));
                listener.onPageSelected(position);
            }

            public void onPageScrollStateChanged(int state) {
                listener.onPageScrollStateChanged(state);
            }
        });
    }

    public ScrollGalleryView addMedia(MediaInfo mediaInfo) {
        if (mediaInfo == null) {
            throw new NullPointerException("Infos may not be null!");
        }
        return this.addMedia(Collections.singletonList(mediaInfo));
    }

    public ScrollGalleryView addMedia(List<MediaInfo> infos) {
        if (infos == null) {
            throw new NullPointerException("Infos may not be null!");
        }
        for (MediaInfo info : infos) {
            this.mListOfMedia.add(info);
            final ImageView thumbnail = this.addThumbnail(this.getDefaultThumbnail());
            info.getLoader().loadThumbnail(this.getContext(), thumbnail, new MediaLoader.SuccessCallback(){

                @Override
                public void onSuccess() {
                    thumbnail.setScaleType(ImageView.ScaleType.FIT_CENTER);
                }
            });
            this.pagerAdapter.notifyDataSetChanged();
        }
        if (!this.initOnce && !infos.isEmpty()) {
            this.changeImageDescription(0);
            this.initOnce = true;
        }
        return this;
    }

    public ScrollGalleryView setCurrentItem(int i) {
        this.viewPager.setCurrentItem(i, false);
        return this;
    }

    public int getCurrentItem() {
        return this.viewPager.getCurrentItem();
    }

    public ScrollGalleryView setThumbnailSize(int thumbnailSize) {
        this.thumbnailSize = thumbnailSize;
        return this;
    }

    public ScrollGalleryView setZoom(boolean zoomEnabled) {
        this.zoomEnabled = zoomEnabled;
        return this;
    }

    public ScrollGalleryView withHiddenThumbnails(boolean isThumbnailsHidden) {
        if (this.isThumbnailsHidden && !isThumbnailsHidden) {
            this.showThumbnails();
        } else if (!this.isThumbnailsHidden && isThumbnailsHidden) {
            this.hideThumbnails();
        }
        this.isThumbnailsHidden = isThumbnailsHidden;
        return this;
    }

    public ScrollGalleryView hideThumbnailsOnClick(boolean hideThumbnailsOnClick) {
        if (!this.isThumbnailsHidden) {
            this.hideThumbnailsOnClick = hideThumbnailsOnClick;
            if (hideThumbnailsOnClick) {
                this.useDefaultThumbnailsTransition = true;
            }
        }
        return this;
    }

    public ScrollGalleryView hideThumbnailsOnClick(boolean hideThumbnailsOnClick, Transition thumbnailsTransition) {
        if (!this.isThumbnailsHidden) {
            this.hideThumbnailsOnClick = hideThumbnailsOnClick;
            this.thumbnailsTransition = thumbnailsTransition;
        }
        return this;
    }

    public ScrollGalleryView hideThumbnailsAfter(int hideThumbnailsAfterDelay) {
        if (!this.isThumbnailsHidden) {
            this.hideThumbnailsAfterDelay = hideThumbnailsAfterDelay;
        }
        return this;
    }

    public void showThumbnails() {
        this.setThumbnailsTransition();
        this.horizontalScrollView.setVisibility(0);
        if (this.hideThumbnailsAfterDelay != null) {
            this.hideThumbnailsAfterDelay(this.hideThumbnailsAfterDelay);
        }
    }

    public void hideThumbnails() {
        this.setThumbnailsTransition();
        this.horizontalScrollView.setVisibility(8);
    }

    public void clearGallery() {
        this.mListOfMedia.clear();
        this.pagerAdapter = new ScreenSlidePagerAdapter(this.fragmentManager, this.mListOfMedia, this.zoomEnabled, this.innerOnImageClickListener, this.innerOnImageLongClickListener);
        this.viewPager.setAdapter((PagerAdapter)this.pagerAdapter);
        this.thumbnailsContainer.removeAllViews();
    }

    public void removeMedia(int position) {
        if (position >= this.mListOfMedia.size() || position < 0) {
            return;
        }
        this.pagerAdapter.removeItem(position);
        this.removeThumbnail(position);
    }

    public static GalleryBuilder from(ScrollGalleryView galleryView) {
        return new GalleryBuilderImpl(galleryView);
    }

    private void hideThumbnailsAfterDelay(int delay) {
        this.horizontalScrollView.postDelayed(new Runnable(){

            @Override
            public void run() {
                ScrollGalleryView.this.hideThumbnails();
                ScrollGalleryView.this.isThumbnailsHidden = !ScrollGalleryView.this.isThumbnailsHidden;
            }
        }, (long)delay);
    }

    private void setThumbnailsTransition() {
        if (this.thumbnailsTransition == null && this.useDefaultThumbnailsTransition) {
            TransitionManager.beginDelayedTransition((ViewGroup)this.horizontalScrollView);
        } else if (this.thumbnailsTransition != null) {
            TransitionManager.beginDelayedTransition((ViewGroup)this.horizontalScrollView, (Transition)this.thumbnailsTransition);
        }
    }

    private Bitmap getDefaultThumbnail() {
        return ((BitmapDrawable)this.getContext().getResources().getDrawable(R.drawable.placeholder_image)).getBitmap();
    }

    private Point getDisplaySize() {
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 13) {
            display.getSize(point);
        } else {
            point.set(display.getWidth(), display.getHeight());
        }
        return point;
    }

    private void removeThumbnail(int position) {
        View thumbnail = this.thumbnailsContainer.getChildAt(position);
        if (thumbnail == null) {
            return;
        }
        this.thumbnailsContainer.removeView(thumbnail);
    }

    private ImageView addThumbnail(Bitmap image) {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(this.thumbnailSize, this.thumbnailSize);
        lp.setMargins(10, 10, 10, 10);
        Bitmap thumbnail = this.createThumbnail(image);
        ImageView thumbnailView = this.createThumbnailView(lp, thumbnail);
        this.thumbnailsContainer.addView((View)thumbnailView);
        return thumbnailView;
    }

    private ImageView createThumbnailView(LinearLayout.LayoutParams lp, Bitmap thumbnail) {
        ImageView thumbnailView = new ImageView(this.context);
        thumbnailView.setLayoutParams((ViewGroup.LayoutParams)lp);
        thumbnailView.setImageBitmap(thumbnail);
        thumbnailView.setId(this.mListOfMedia.size() - 1);
        thumbnailView.setOnClickListener(this.thumbnailOnClickListener);
        thumbnailView.setScaleType(ImageView.ScaleType.CENTER);
        return thumbnailView;
    }

    private Bitmap createThumbnail(Bitmap image) {
        return ThumbnailUtils.extractThumbnail((Bitmap)image, (int)this.thumbnailSize, (int)this.thumbnailSize);
    }

    private void initializeViewPager() {
        this.viewPager = (HackyViewPager)this.findViewById(R.id.viewPager);
        this.pagerAdapter = new ScreenSlidePagerAdapter(this.fragmentManager, this.mListOfMedia, this.zoomEnabled, this.innerOnImageClickListener, this.innerOnImageLongClickListener);
        this.viewPager.setAdapter((PagerAdapter)this.pagerAdapter);
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.viewPagerChangeListener);
    }

    private void scroll(View thumbnail) {
        int[] thumbnailCoords = new int[2];
        thumbnail.getLocationOnScreen(thumbnailCoords);
        int thumbnailCenterX = thumbnailCoords[0] + this.thumbnailSize / 2;
        int thumbnailDelta = this.displayProps.x / 2 - thumbnailCenterX;
        this.horizontalScrollView.smoothScrollBy(-thumbnailDelta, 0);
    }

    private int calculateInSampleSize(int imgWidth, int imgHeight, int maxWidth, int maxHeight) {
        int inSampleSize = 1;
        while (imgWidth / inSampleSize > maxWidth || imgHeight / inSampleSize > maxHeight) {
            inSampleSize *= 2;
        }
        return inSampleSize;
    }

    public static interface OnImageLongClickListener {
        public void onClick(int var1);
    }

    public static interface OnImageClickListener {
        public void onClick(int var1);
    }
}

