/*
 * Decompiled with CFR 0.152.
 */
package com.veinhorn.scrollgalleryview.loader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.widget.ImageView;
import com.veinhorn.scrollgalleryview.loader.MediaLoader;

public class DefaultImageLoader
implements MediaLoader {
    private int mId;
    private Bitmap mBitmap;

    public DefaultImageLoader(int id2) {
        this.mId = id2;
    }

    public DefaultImageLoader(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    @Override
    public boolean isImage() {
        return true;
    }

    @Override
    public void loadMedia(Context context, ImageView imageView, MediaLoader.SuccessCallback callback) {
        imageView.setImageBitmap(this.mBitmap);
        if (callback != null) {
            callback.onSuccess();
        }
    }

    @Override
    public void loadThumbnail(Context context, ImageView thumbnailView, MediaLoader.SuccessCallback callback) {
        this.loadBitmap(context);
        thumbnailView.setImageBitmap(this.mBitmap);
        if (callback != null) {
            callback.onSuccess();
        }
    }

    private void loadBitmap(Context context) {
        if (this.mBitmap == null) {
            this.mBitmap = ((BitmapDrawable)context.getResources().getDrawable(this.mId)).getBitmap();
        }
    }
}

