package com.veinhorn.scrollgalleryview.builder;

import com.veinhorn.scrollgalleryview.MediaInfo;
import com.veinhorn.scrollgalleryview.ScrollGalleryView;

import java.util.ArrayList;
import java.util.List;

public class GalleryBuilderImpl implements GalleryBuilder {
    private ScrollGalleryView galleryView;
    private GallerySettings settings;

    private List<MediaInfo> medias;

    public GalleryBuilderImpl(ScrollGalleryView galleryView) {
        this.galleryView = galleryView;
        this.medias = new ArrayList<>();
    }

    @Override
    public GalleryBuilder settings(GallerySettings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public GalleryBuilder add(MediaInfo mediaInfo) {
        medias.add(mediaInfo);
        return this;
    }

    @Override
    public ScrollGalleryView build() {
        // check here all parameters


        // set options
        return galleryView
                .setThumbnailSize(settings.getThumbnailSize())
                .setZoom(settings.isZoomEnabled())
                .setFragmentManager(settings.getFragmentManager())
                .addMedia(medias);
    }
}
