/*
 * Decompiled with CFR 0.152.
 */
package com.veinhorn.scrollgalleryview;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import com.veinhorn.scrollgalleryview.ImageFragment;
import com.veinhorn.scrollgalleryview.MediaInfo;
import com.veinhorn.scrollgalleryview.ScrollGalleryView;
import java.util.List;

public class ScreenSlidePagerAdapter
extends FragmentStatePagerAdapter {
    private List<MediaInfo> mListOfMedia;
    private boolean isZoom = false;
    private ScrollGalleryView.OnImageClickListener onImageClickListener;

    public ScreenSlidePagerAdapter(FragmentManager fm, List<MediaInfo> listOfMedia, boolean isZoom, ScrollGalleryView.OnImageClickListener onImageClickListener) {
        super(fm);
        this.mListOfMedia = listOfMedia;
        this.isZoom = isZoom;
        this.onImageClickListener = onImageClickListener;
    }

    public Fragment getItem(int position) {
        Fragment fragment = null;
        if (position < this.mListOfMedia.size()) {
            MediaInfo mediaInfo = this.mListOfMedia.get(position);
            fragment = this.loadImageFragment(mediaInfo);
        }
        return fragment;
    }

    private Fragment loadImageFragment(MediaInfo mediaInfo) {
        ImageFragment fragment = new ImageFragment();
        fragment.setMediaInfo(mediaInfo);
        if (this.onImageClickListener != null) {
            fragment.setOnImageClickListener(this.onImageClickListener);
        }
        Bundle bundle = new Bundle();
        bundle.putBoolean("zoom", this.isZoom);
        fragment.setArguments(bundle);
        return fragment;
    }

    public int getCount() {
        return this.mListOfMedia.size();
    }
}

