/*
 * Decompiled with CFR 0.152.
 */
package com.veinhorn.scrollgalleryview;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.github.chrisbanes.photoview.PhotoView;
import com.veinhorn.scrollgalleryview.HackyViewPager;
import com.veinhorn.scrollgalleryview.MediaInfo;
import com.veinhorn.scrollgalleryview.R;
import com.veinhorn.scrollgalleryview.ScrollGalleryView;
import com.veinhorn.scrollgalleryview.loader.MediaLoader;

public class ImageFragment
extends Fragment {
    private MediaInfo mMediaInfo;
    private HackyViewPager viewPager;
    private PhotoView photoView;
    private ScrollGalleryView.OnImageClickListener onImageClickListener;

    public void setOnImageClickListener(ScrollGalleryView.OnImageClickListener onImageClickListener) {
        this.onImageClickListener = onImageClickListener;
    }

    public void setMediaInfo(MediaInfo mediaInfo) {
        this.mMediaInfo = mediaInfo;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        View rootView = inflater.inflate(R.layout.image_fragment, container, false);
        this.photoView = (PhotoView)rootView.findViewById(R.id.photoView);
        if (this.onImageClickListener != null) {
            this.photoView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ImageFragment.this.onImageClickListener.onClick();
                }
            });
        }
        this.viewPager = (HackyViewPager)this.getActivity().findViewById(R.id.viewPager);
        if (savedInstanceState != null) {
            boolean isLocked = savedInstanceState.getBoolean("isLocked", false);
            this.viewPager.setLocked(isLocked);
        }
        this.loadImageToView();
        return rootView;
    }

    private void loadImageToView() {
        if (this.mMediaInfo != null) {
            this.mMediaInfo.getLoader().loadMedia((Context)this.getActivity(), (ImageView)this.photoView, new MediaLoader.SuccessCallback(){

                @Override
                public void onSuccess() {
                }
            });
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.isViewPagerActive()) {
            outState.putBoolean("isLocked", this.viewPager.isLocked());
        }
        super.onSaveInstanceState(outState);
    }

    private boolean isViewPagerActive() {
        return this.viewPager != null;
    }

    private boolean isBackgroundImageActive() {
        return this.photoView != null && this.photoView.getDrawable() != null;
    }
}

