/*
 * Decompiled with CFR 0.152.
 */
package com.veinhorn.scrollgalleryview.loader;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.view.View;
import android.widget.ImageView;
import com.veinhorn.scrollgalleryview.VideoPlayerActivity;
import com.veinhorn.scrollgalleryview.loader.MediaLoader;

public class DefaultVideoLoader
implements MediaLoader {
    private String url;
    private int mId;
    private Bitmap mBitmap;

    public DefaultVideoLoader(String url, int mId) {
        this.url = url;
        this.mId = mId;
    }

    @Override
    public boolean isImage() {
        return false;
    }

    @Override
    public void loadMedia(final Context context, ImageView imageView, MediaLoader.SuccessCallback callback) {
        this.loadBitmap(context);
        imageView.setImageBitmap(this.mBitmap);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DefaultVideoLoader.this.displayVideo(context, DefaultVideoLoader.this.url);
            }
        });
    }

    @Override
    public void loadThumbnail(Context context, ImageView thumbnailView, MediaLoader.SuccessCallback callback) {
        this.loadBitmap(context);
        thumbnailView.setImageBitmap(this.mBitmap);
        callback.onSuccess();
    }

    private void displayVideo(Context context, String url) {
        Intent intent = new Intent(context, VideoPlayerActivity.class);
        intent.putExtra("url", url);
        context.startActivity(intent);
    }

    private void loadBitmap(Context context) {
        if (this.mBitmap == null) {
            this.mBitmap = ((BitmapDrawable)context.getResources().getDrawable(this.mId)).getBitmap();
        }
    }
}

