/*
 * Decompiled with CFR 0.152.
 */
package com.veinhorn.scrollgalleryview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.veinhorn.scrollgalleryview.HackyViewPager;
import com.veinhorn.scrollgalleryview.MediaInfo;
import com.veinhorn.scrollgalleryview.R;
import com.veinhorn.scrollgalleryview.loader.MediaLoader;
import uk.co.senab.photoview.PhotoViewAttacher;

public class ImageFragment
extends Fragment {
    private MediaInfo mMediaInfo;
    private HackyViewPager viewPager;
    private ImageView backgroundImage;
    private PhotoViewAttacher photoViewAttacher;

    public void setMediaInfo(MediaInfo mediaInfo) {
        this.mMediaInfo = mediaInfo;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        View rootView = inflater.inflate(R.layout.image_fragment, container, false);
        this.backgroundImage = (ImageView)rootView.findViewById(R.id.backgroundImage);
        this.viewPager = (HackyViewPager)this.getActivity().findViewById(R.id.viewPager);
        if (savedInstanceState != null) {
            boolean isLocked = savedInstanceState.getBoolean("isLocked", false);
            this.viewPager.setLocked(isLocked);
            this.backgroundImage.setImageBitmap((Bitmap)savedInstanceState.getParcelable("image"));
            this.createViewAttacher(savedInstanceState);
        }
        this.loadImageToView();
        return rootView;
    }

    private void loadImageToView() {
        if (this.mMediaInfo != null) {
            this.mMediaInfo.getLoader().loadMedia((Context)this.getActivity(), this.backgroundImage, new MediaLoader.SuccessCallback(){

                @Override
                public void onSuccess() {
                    ImageFragment.this.createViewAttacher(ImageFragment.this.getArguments());
                }
            });
        }
    }

    private void createViewAttacher(Bundle savedInstanceState) {
        if (savedInstanceState.getBoolean("zoom")) {
            this.photoViewAttacher = new PhotoViewAttacher(this.backgroundImage);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.isViewPagerActive()) {
            outState.putBoolean("isLocked", this.viewPager.isLocked());
        }
        outState.putParcelable("image", (Parcelable)((BitmapDrawable)this.backgroundImage.getDrawable()).getBitmap());
        outState.putBoolean("zoom", this.photoViewAttacher != null);
        super.onSaveInstanceState(outState);
    }

    private boolean isViewPagerActive() {
        return this.viewPager != null;
    }
}

