/*
 * Decompiled with CFR 0.152.
 */
package com.veinhorn.scrollgalleryview;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.veinhorn.scrollgalleryview.HackyViewPager;
import com.veinhorn.scrollgalleryview.R;
import uk.co.senab.photoview.PhotoViewAttacher;

public class ImageFragment
extends Fragment {
    private static final String IS_LOCKED = "isLocked";
    private HackyViewPager viewPager;
    private ImageView backgroundImage;
    private PhotoViewAttacher photoViewAttacher;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        View rootView = inflater.inflate(R.layout.image_fragment, container, false);
        this.backgroundImage = (ImageView)rootView.findViewById(R.id.backgroundImage);
        this.backgroundImage.setImageBitmap((Bitmap)this.getArguments().getParcelable("image"));
        if (this.getArguments().getBoolean("isZoom")) {
            this.photoViewAttacher = new PhotoViewAttacher(this.backgroundImage);
        }
        this.viewPager = this.getViewPager();
        if (savedInstanceState != null) {
            boolean isLocked = savedInstanceState.getBoolean(IS_LOCKED, false);
            this.viewPager.setLocked(isLocked);
        }
        return rootView;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.isViewPagerActive()) {
            outState.putBoolean(IS_LOCKED, this.viewPager.isLocked());
        }
        super.onSaveInstanceState(outState);
    }

    private boolean isViewPagerActive() {
        return this.viewPager != null;
    }

    private HackyViewPager getViewPager() {
        return (HackyViewPager)this.getActivity().findViewById(R.id.viewPager);
    }
}

