/*
 * Decompiled with CFR 0.152.
 */
package com.veinhorn.scrollgalleryview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.media.ThumbnailUtils;
import android.os.Build;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.veinhorn.scrollgalleryview.R;
import com.veinhorn.scrollgalleryview.ScreenSlidePagerAdapter;
import java.util.ArrayList;
import java.util.List;

public class ScrollGalleryView
extends LinearLayout {
    private FragmentManager fragmentManager;
    private Context context;
    private Point displayProps;
    private int thumbnailSize;
    private boolean isZoom;
    private LinearLayout thumbnailsContainer;
    private HorizontalScrollView horizontalScrollView;
    private ViewPager viewPager;
    private PagerAdapter pagerAdapter;
    private List<Bitmap> images;
    private View.OnClickListener thumbnailOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            ScrollGalleryView.this.scroll(v);
            ScrollGalleryView.this.viewPager.setCurrentItem(((Integer)v.getTag()).intValue(), true);
        }
    };
    private ViewPager.SimpleOnPageChangeListener viewPagerChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            ScrollGalleryView.this.scroll(ScrollGalleryView.this.thumbnailsContainer.getChildAt(position));
        }
    };

    public ScrollGalleryView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.images = new ArrayList<Bitmap>();
        this.setOrientation(1);
        this.displayProps = this.getDisplaySize();
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.scroll_gallery_view, (ViewGroup)this, true);
        this.horizontalScrollView = (HorizontalScrollView)this.findViewById(R.id.thumbnails_scroll_view);
        this.thumbnailsContainer = (LinearLayout)this.findViewById(R.id.thumbnails_container);
        this.thumbnailsContainer.setPadding(this.displayProps.x / 2, 0, this.displayProps.x / 2, 0);
    }

    public ScrollGalleryView setFragmentManager(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
        this.initializeViewPager();
        return this;
    }

    public ScrollGalleryView addImage(int image) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)image);
        this.addImage(bitmap);
        return this;
    }

    public ScrollGalleryView addImage(Bitmap image) {
        this.images.add(image);
        this.addThumbnail(image);
        this.pagerAdapter.notifyDataSetChanged();
        return this;
    }

    public ScrollGalleryView setThumbnailSize(int thumbnailSize) {
        this.thumbnailSize = thumbnailSize;
        return this;
    }

    public ScrollGalleryView setZoom(boolean isZoom) {
        this.isZoom = isZoom;
        return this;
    }

    private Point getDisplaySize() {
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 13) {
            display.getSize(point);
        } else {
            point.set(display.getWidth(), display.getHeight());
        }
        return point;
    }

    private ScrollGalleryView addThumbnail(Bitmap image) {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(this.thumbnailSize, this.thumbnailSize);
        lp.setMargins(10, 10, 10, 10);
        Bitmap thumbnail = this.createThumbnail(image);
        this.thumbnailsContainer.addView((View)this.createThumbnailView(lp, thumbnail));
        return this;
    }

    private ImageView createThumbnailView(LinearLayout.LayoutParams lp, Bitmap thumbnail) {
        ImageView thumbnailView = new ImageView(this.context);
        thumbnailView.setLayoutParams((ViewGroup.LayoutParams)lp);
        thumbnailView.setImageBitmap(thumbnail);
        thumbnailView.setTag((Object)(this.images.size() - 1));
        thumbnailView.setOnClickListener(this.thumbnailOnClickListener);
        return thumbnailView;
    }

    private Bitmap createThumbnail(Bitmap image) {
        return ThumbnailUtils.extractThumbnail((Bitmap)image, (int)this.thumbnailSize, (int)this.thumbnailSize);
    }

    private void initializeViewPager() {
        this.viewPager = (ViewPager)this.findViewById(R.id.viewPager);
        this.pagerAdapter = new ScreenSlidePagerAdapter(this.fragmentManager, this.images, this.isZoom);
        this.viewPager.setAdapter(this.pagerAdapter);
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.viewPagerChangeListener);
    }

    private void scroll(View thumbnail) {
        int[] thumbnailCoords = new int[2];
        thumbnail.getLocationOnScreen(thumbnailCoords);
        int thumbnailCenterX = thumbnailCoords[0] + this.thumbnailSize / 2;
        int thumbnailDelta = this.displayProps.x / 2 - thumbnailCenterX;
        this.horizontalScrollView.smoothScrollBy(-thumbnailDelta, 0);
    }
}

