/*
 * Decompiled with CFR 0.152.
 */
package ogbe.ozioma.com.glideimageloader;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.veinhorn.scrollgalleryview.loader.MediaLoader;
import ogbe.ozioma.com.glideimageloader.R;

public class GlideImageLoader
implements MediaLoader {
    private String url;
    private int width;
    private int height;
    private RequestOptions requestOptions;

    public GlideImageLoader(String url) {
        this.url = url;
        this.requestOptions = new RequestOptions().placeholder(R.drawable.placeholder_image);
    }

    public GlideImageLoader(String url, int width, int height) {
        this.url = url;
        this.width = width;
        this.height = height;
        this.requestOptions = new RequestOptions().placeholder(R.drawable.placeholder_image).override(width, height);
    }

    public boolean isImage() {
        return true;
    }

    public void loadMedia(Context context, ImageView imageView, final MediaLoader.SuccessCallback callback) {
        RequestOptions requestOptions = new RequestOptions();
        Glide.with((Context)context).applyDefaultRequestOptions(requestOptions).load(this.url).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                callback.onSuccess();
                return false;
            }
        }).into(imageView);
    }

    public void loadThumbnail(Context context, ImageView thumbnailView, final MediaLoader.SuccessCallback callback) {
        Glide.with((Context)context).applyDefaultRequestOptions(this.requestOptions).load(this.url).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                callback.onSuccess();
                return false;
            }
        }).into(thumbnailView);
    }
}

