/*
 * Decompiled with CFR 0.152.
 */
package com.ayokunlepaul.frescoloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.widget.ImageView;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.veinhorn.scrollgalleryview.loader.MediaLoader;
import java.util.concurrent.Executor;

public class FrescoImageLoader
implements MediaLoader {
    private String url;
    private Integer thumbnailWidth;
    private Integer thumbnailHeight;

    public FrescoImageLoader(String url) {
        this.url = url;
    }

    public FrescoImageLoader(String url, Integer thumbnailWidth, Integer thumbnailHeight) {
        this.url = url;
        this.thumbnailWidth = thumbnailWidth;
        this.thumbnailHeight = thumbnailHeight;
    }

    public boolean isImage() {
        return true;
    }

    public void loadMedia(Context context, ImageView imageView, MediaLoader.SuccessCallback callback) {
        if (!Fresco.hasBeenInitialized()) {
            Fresco.initialize((Context)context);
        }
        ImagePipeline pipeline = Fresco.getImagePipeline();
        DataSubscriber subscriber = this.getSubscriber(imageView, callback);
        DataSource dataSource = pipeline.fetchDecodedImage(this.createImageRequest(), (Object)context);
        dataSource.subscribe(subscriber, (Executor)UiThreadImmediateExecutorService.getInstance());
    }

    public void loadThumbnail(Context context, ImageView thumbnailView, MediaLoader.SuccessCallback callback) {
        if (!Fresco.hasBeenInitialized()) {
            Fresco.initialize((Context)context);
        }
        ImagePipeline pipeline = Fresco.getImagePipeline();
        DataSubscriber subscriber = this.getSubscriber(thumbnailView, callback);
        DataSource dataSource = pipeline.fetchDecodedImage(this.createImageRequest(this.thumbnailWidth, this.thumbnailHeight), (Object)context);
        dataSource.subscribe(subscriber, (Executor)UiThreadImmediateExecutorService.getInstance());
    }

    private ImageRequest createImageRequest() {
        return ImageRequest.fromUri((Uri)Uri.parse((String)this.url));
    }

    private ImageRequest createImageRequest(Integer thumbnailWidth, Integer thumbnailHeight) {
        ImageRequestBuilder builder = ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)this.url));
        builder.setResizeOptions(new ResizeOptions(thumbnailWidth.intValue(), thumbnailHeight.intValue()));
        return builder.build();
    }

    private DataSubscriber getSubscriber(final ImageView imageView, final MediaLoader.SuccessCallback callback) {
        return new BaseDataSubscriber<CloseableReference<CloseableBitmap>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onNewResultImpl(DataSource<CloseableReference<CloseableBitmap>> dataSource) {
                if (!dataSource.isFinished()) {
                    return;
                }
                CloseableReference result = (CloseableReference)dataSource.getResult();
                if (result != null) {
                    CloseableReference resultCopy = result.clone();
                    try {
                        CloseableBitmap closeableBitmap = (CloseableBitmap)resultCopy.get();
                        Bitmap bitmap = closeableBitmap.getUnderlyingBitmap();
                        if (bitmap != null && !bitmap.isRecycled()) {
                            imageView.setImageBitmap(bitmap);
                            callback.onSuccess();
                        }
                    }
                    finally {
                        result.close();
                        resultCopy.close();
                    }
                }
            }

            protected void onFailureImpl(DataSource<CloseableReference<CloseableBitmap>> dataSource) {
                Throwable cause = dataSource.getFailureCause();
                if (cause != null) {
                    cause.printStackTrace();
                }
            }
        };
    }
}

