/*
 * Decompiled with CFR 0.152.
 */
package com.veeyikpong.easyfragmentcontainer;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.veeyikpong.easyfragmentcontainer.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001)B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0016H\u0007J\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0007H\u0007J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0007H\u0007J\u000e\u0010\u000f\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u0014J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0007H\u0007J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0007H\u0007J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0007R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/veeyikpong/easyfragmentcontainer/FragmentContainer;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentFragment", "Landroidx/fragment/app/Fragment;", "getCurrentFragment", "()Landroidx/fragment/app/Fragment;", "setCurrentFragment", "(Landroidx/fragment/app/Fragment;)V", "fragmentTag", "", "mEnterAnimation", "mExitAnimation", "mFragmentManager", "Landroidx/fragment/app/FragmentManager;", "mListener", "Lcom/veeyikpong/easyfragmentcontainer/FragmentContainer$FragmentListener;", "mPopEnterAnimation", "mPopExitAnimation", "addFragment", "", "fragment", "bundle", "Landroid/os/Bundle;", "addFragmentListener", "listener", "back", "", "enterAnimation", "animation", "exitAnimation", "getFragmentManager", "popEnterAnimation", "popExitAnimation", "replaceFragment", "FragmentListener", "easyfragmentcontainer_release"})
public final class FragmentContainer
extends FrameLayout {
    private FragmentListener mListener;
    private FragmentManager mFragmentManager;
    @NotNull
    public Fragment currentFragment;
    private int mEnterAnimation;
    private int mExitAnimation;
    private int mPopEnterAnimation;
    private int mPopExitAnimation;
    private String fragmentTag;
    private HashMap _$_findViewCache;

    @NotNull
    public final Fragment getCurrentFragment() {
        Fragment fragment = this.currentFragment;
        if (fragment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFragment");
        }
        return fragment;
    }

    public final void setCurrentFragment(@NotNull Fragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"<set-?>");
        this.currentFragment = fragment;
    }

    @NonNull
    public final void addFragmentListener(@NotNull FragmentListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.mListener = listener;
    }

    @NonNull
    public final void enterAnimation(int animation) {
        this.mEnterAnimation = animation;
    }

    @NonNull
    public final void popEnterAnimation(int animation) {
        this.mPopEnterAnimation = animation;
    }

    @NonNull
    public final void exitAnimation(int animation) {
        this.mExitAnimation = animation;
    }

    @NonNull
    public final void popExitAnimation(int animation) {
        this.mPopExitAnimation = animation;
    }

    @NotNull
    public final FragmentManager getFragmentManager() {
        return this.mFragmentManager;
    }

    public final void fragmentTag(@NotNull String fragmentTag) {
        Intrinsics.checkParameterIsNotNull((Object)fragmentTag, (String)"fragmentTag");
        this.fragmentTag = fragmentTag;
    }

    @NonNull
    public final void replaceFragment(@NotNull Fragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        FragmentTransaction fragmentTransaction = this.mFragmentManager.beginTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentTransaction, (String)"mFragmentManager\n       \u2026      .beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        transaction.setCustomAnimations(this.mEnterAnimation, this.mExitAnimation, this.mPopEnterAnimation, this.mPopExitAnimation);
        transaction.replace(this.getId(), fragment).disallowAddToBackStack().commit();
    }

    @NonNull
    public final void addFragment(@NotNull Fragment fragment, @NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        fragment.setArguments(bundle);
        String tag = fragment.getClass().getSimpleName();
        if (!StringsKt.isBlank((CharSequence)this.fragmentTag)) {
            tag = this.fragmentTag;
        }
        FragmentTransaction fragmentTransaction = this.mFragmentManager.beginTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentTransaction, (String)"mFragmentManager\n       \u2026      .beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        transaction.setCustomAnimations(this.mEnterAnimation, this.mExitAnimation, this.mPopEnterAnimation, this.mPopExitAnimation);
        transaction.replace(this.getId(), fragment, tag).addToBackStack(tag);
        transaction.commit();
    }

    @NonNull
    public static /* synthetic */ void addFragment$default(FragmentContainer fragmentContainer, Fragment fragment, Bundle bundle, int n, Object object) {
        if ((n & 2) != 0) {
            bundle = new Bundle();
        }
        fragmentContainer.addFragment(fragment, bundle);
    }

    public final boolean back() {
        int backStackCount = this.mFragmentManager.getBackStackEntryCount();
        if (backStackCount > 1) {
            this.mFragmentManager.popBackStackImmediate();
            return true;
        }
        return false;
    }

    @JvmOverloads
    public FragmentContainer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        FragmentManager fragmentManager = ((AppCompatActivity)context).getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"((context) as AppCompatA\u2026y).supportFragmentManager");
        this.mFragmentManager = fragmentManager;
        this.fragmentTag = "";
        TypedArray attributeArray = context.obtainStyledAttributes(attrs, R.styleable.FragmentContainer);
        this.mEnterAnimation = attributeArray.getResourceId(R.styleable.FragmentContainer_enterAnimation, 0);
        this.mExitAnimation = attributeArray.getResourceId(R.styleable.FragmentContainer_exitAnimation, 0);
        attributeArray.recycle();
        this.mFragmentManager.registerFragmentLifecycleCallbacks(new FragmentManager.FragmentLifecycleCallbacks(){

            public void onFragmentActivityCreated(@NotNull FragmentManager fm, @NotNull Fragment f, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
                Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                super.onFragmentActivityCreated(fm, f, savedInstanceState);
                super.onFragmentResumed(fm, f);
                if (mListener != null) {
                    FragmentListener fragmentListener = mListener;
                    if (fragmentListener == null) {
                        Intrinsics.throwNpe();
                    }
                    fragmentListener.onFragmentShow(f);
                }
                this.setCurrentFragment(f);
            }

            public void onFragmentViewDestroyed(@NotNull FragmentManager fm, @NotNull Fragment f) {
                Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
                Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                super.onFragmentViewDestroyed(fm, f);
                if (mListener != null) {
                    FragmentListener fragmentListener = mListener;
                    if (fragmentListener == null) {
                        Intrinsics.throwNpe();
                    }
                    fragmentListener.onFragmentDestroyed(f);
                }
            }
        }, true);
    }

    @JvmOverloads
    public /* synthetic */ FragmentContainer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public FragmentContainer(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public FragmentContainer(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$setMListener$p(FragmentContainer $this, FragmentListener fragmentListener) {
        $this.mListener = fragmentListener;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/veeyikpong/easyfragmentcontainer/FragmentContainer$FragmentListener;", "", "onFragmentDestroyed", "", "f", "Landroidx/fragment/app/Fragment;", "onFragmentShow", "easyfragmentcontainer_release"})
    public static interface FragmentListener {
        public void onFragmentShow(@NotNull Fragment var1);

        public void onFragmentDestroyed(@NotNull Fragment var1);
    }
}

