/*
 * Decompiled with CFR 0.152.
 */
package com.vdurmont.semver4j;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Tokenizer {
    private static final Map<Character, Token> SPECIAL_CHARS = new HashMap<Character, Token>();

    protected static List<Token> tokenize(String requirement) {
        requirement = requirement.replace("||", "|").replace("<=", "\u2264").replace(">=", "\u2265");
        LinkedList<Token> tokens = new LinkedList<Token>();
        Token previousToken = null;
        char[] chars = requirement.toCharArray();
        Token token = null;
        for (char c : chars) {
            if (c == ' ') continue;
            if (SPECIAL_CHARS.containsKey(Character.valueOf(c))) {
                if (token != null) {
                    tokens.add(token);
                    previousToken = token;
                    token = null;
                }
                Token current = SPECIAL_CHARS.get(Character.valueOf(c));
                if (current.type.isUnary() && previousToken != null && previousToken.type == TokenType.VERSION) {
                    tokens.add(new Token(TokenType.AND));
                }
                tokens.add(current);
                previousToken = current;
                continue;
            }
            if (token == null) {
                token = new Token(TokenType.VERSION);
            }
            token.append(c);
        }
        if (token != null) {
            tokens.add(token);
        }
        return tokens;
    }

    static {
        for (TokenType type : TokenType.values()) {
            if (type.character == null) continue;
            SPECIAL_CHARS.put(type.character, new Token(type));
        }
    }

    protected static enum TokenType {
        TILDE(Character.valueOf('~'), true),
        CARET(Character.valueOf('^'), true),
        EQ(Character.valueOf('='), true),
        LT(Character.valueOf('<'), true),
        LTE(Character.valueOf('\u2264'), true),
        GT(Character.valueOf('>'), true),
        GTE(Character.valueOf('\u2265'), true),
        HYPHEN(Character.valueOf('-'), false),
        OR(Character.valueOf('|'), false),
        AND(null, false),
        OPENING(Character.valueOf('('), false),
        CLOSING(Character.valueOf(')'), false),
        VERSION(null, false);

        public final Character character;
        private final boolean unary;

        private TokenType(Character character, boolean unary) {
            this.character = character;
            this.unary = unary;
        }

        public boolean isUnary() {
            return this.unary;
        }
    }

    protected static class Token {
        public final TokenType type;
        public String value;

        public Token(TokenType type) {
            this(type, null);
        }

        public Token(TokenType type, String value) {
            this.type = type;
            this.value = value;
        }

        public void append(char c) {
            if (this.value == null) {
                this.value = "";
            }
            this.value = this.value + c;
        }
    }
}

