/*
 * Decompiled with CFR 0.152.
 */
package com.vdurmont.emoji;

import com.vdurmont.emoji.Emoji;
import com.vdurmont.emoji.EmojiManager;
import com.vdurmont.emoji.Fitzpatrick;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmojiParser {
    private EmojiParser() {
    }

    public static String parseToAliases(String input) {
        return EmojiParser.parseToAliases(input, FitzpatrickAction.PARSE);
    }

    public static String parseToAliases(String input, FitzpatrickAction fitzpatrickAction) {
        String result = EmojiParser.prepareParsing(input, fitzpatrickAction);
        for (Emoji emoji : EmojiManager.getAll()) {
            if (fitzpatrickAction != FitzpatrickAction.REMOVE && emoji.supportsFitzpatrick() && fitzpatrickAction == FitzpatrickAction.PARSE) {
                for (Fitzpatrick fitzpatrick : Fitzpatrick.values()) {
                    String replacement = ":" + emoji.getAliases().get(0) + "|" + fitzpatrick.toString().toLowerCase() + ":";
                    result = result.replace(emoji.getUnicode(fitzpatrick), replacement);
                }
            }
            result = result.replace(emoji.getUnicode(), ":" + emoji.getAliases().get(0) + ":");
        }
        return result;
    }

    public static String parseToUnicode(String input) {
        List<AliasCandidate> candidates = EmojiParser.getAliasCandidates(input);
        String result = input;
        for (AliasCandidate candidate : candidates) {
            Emoji emoji = EmojiManager.getForAlias(candidate.alias);
            if (emoji == null || !emoji.supportsFitzpatrick() && (emoji.supportsFitzpatrick() || candidate.fitzpatrick != null)) continue;
            String replacement = emoji.getUnicode();
            if (candidate.fitzpatrick != null) {
                replacement = replacement + candidate.fitzpatrick.unicode;
            }
            result = result.replace(":" + candidate.fullString + ":", replacement);
        }
        for (Emoji emoji : EmojiManager.getAll()) {
            result = result.replace(emoji.getHtmlHexidecimal(), emoji.getUnicode());
            result = result.replace(emoji.getHtmlDecimal(), emoji.getUnicode());
        }
        return result;
    }

    protected static List<AliasCandidate> getAliasCandidates(String input) {
        ArrayList<AliasCandidate> candidates = new ArrayList<AliasCandidate>();
        String regex = "(?<=:)\\+?(\\w|\\||\\-)+(?=:)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        matcher = matcher.useTransparentBounds(true);
        while (matcher.find()) {
            String match = matcher.group();
            if (!match.contains("|")) {
                candidates.add(new AliasCandidate(match, match, null));
                continue;
            }
            String[] splitted = match.split("\\|");
            if (splitted.length == 2 || splitted.length > 2) {
                candidates.add(new AliasCandidate(match, splitted[0], splitted[1]));
                continue;
            }
            candidates.add(new AliasCandidate(match, match, null));
        }
        return candidates;
    }

    public static String parseToHtmlDecimal(String input) {
        return EmojiParser.parseToHtmlDecimal(input, FitzpatrickAction.PARSE);
    }

    public static String parseToHtmlDecimal(String input, FitzpatrickAction fitzpatrickAction) {
        String result = EmojiParser.prepareParsing(input, fitzpatrickAction);
        for (Emoji emoji : EmojiManager.getAll()) {
            if (fitzpatrickAction != FitzpatrickAction.REMOVE && emoji.supportsFitzpatrick()) {
                for (Fitzpatrick fitzpatrick : Fitzpatrick.values()) {
                    String search = fitzpatrickAction == FitzpatrickAction.PARSE ? emoji.getUnicode(fitzpatrick) : emoji.getUnicode();
                    result = result.replace(search, emoji.getHtmlDecimal());
                }
            }
            result = result.replace(emoji.getUnicode(), emoji.getHtmlDecimal());
        }
        return result;
    }

    public static String parseToHtmlHexadecimal(String input) {
        return EmojiParser.parseToHtmlHexadecimal(input, FitzpatrickAction.PARSE);
    }

    public static String parseToHtmlHexadecimal(String input, FitzpatrickAction fitzpatrickAction) {
        String result = EmojiParser.prepareParsing(input, fitzpatrickAction);
        for (Emoji emoji : EmojiManager.getAll()) {
            if (fitzpatrickAction != FitzpatrickAction.REMOVE && emoji.supportsFitzpatrick()) {
                for (Fitzpatrick fitzpatrick : Fitzpatrick.values()) {
                    String search = fitzpatrickAction == FitzpatrickAction.PARSE ? emoji.getUnicode(fitzpatrick) : emoji.getUnicode();
                    result = result.replace(search, emoji.getHtmlHexidecimal());
                }
            }
            result = result.replace(emoji.getUnicode(), emoji.getHtmlHexidecimal());
        }
        return result;
    }

    private static String prepareParsing(String input, FitzpatrickAction fitzpatrickAction) {
        if (fitzpatrickAction == FitzpatrickAction.REMOVE) {
            for (Fitzpatrick fitzpatrick : Fitzpatrick.values()) {
                input = input.replace(fitzpatrick.unicode, "");
            }
        }
        return input;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FitzpatrickAction {
        PARSE,
        REMOVE,
        IGNORE;

    }

    protected static class AliasCandidate {
        public final String fullString;
        public final String alias;
        public final Fitzpatrick fitzpatrick;

        private AliasCandidate(String fullString, String alias, String fitzpatrickString) {
            this.fullString = fullString;
            this.alias = alias;
            this.fitzpatrick = fitzpatrickString == null ? null : AliasCandidate.resolveFitzpatrick(fitzpatrickString);
        }

        private static Fitzpatrick resolveFitzpatrick(String fitzpatrickString) {
            try {
                return Fitzpatrick.valueOf(fitzpatrickString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

