/*
 * Decompiled with CFR 0.152.
 */
package com.vdurmont.emoji;

import com.vdurmont.emoji.Emoji;
import com.vdurmont.emoji.EmojiManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmojiParser {
    public static String parseToAliases(String input) {
        String result = input;
        for (Emoji emoji : EmojiManager.getAll()) {
            result = result.replace(emoji.getUnicode(), ":" + emoji.getAliases().get(0) + ":");
        }
        return result;
    }

    public static String parseToUnicode(String input) {
        List<String> aliases = EmojiParser.getAliasesCandidates(input);
        String result = input;
        for (String alias : aliases) {
            Emoji emoji = EmojiManager.getForAlias(alias);
            if (emoji == null) continue;
            result = result.replace(":" + alias + ":", emoji.getUnicode());
        }
        for (Emoji emoji : EmojiManager.getAll()) {
            result = result.replace(emoji.getHtmlHexidecimal(), emoji.getUnicode());
            result = result.replace(emoji.getHtml(), emoji.getUnicode());
        }
        return result;
    }

    protected static List<String> getAliasesCandidates(String input) {
        ArrayList<String> candidates = new ArrayList<String>();
        String regex = "(?<=:)\\+?\\w+(?=:)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        matcher = matcher.useTransparentBounds(true);
        while (matcher.find()) {
            candidates.add(matcher.group());
        }
        return candidates;
    }

    @Deprecated
    public static String parseToHtml(String input) {
        return EmojiParser.parseToHtmlDecimal(input);
    }

    public static String parseToHtmlDecimal(String input) {
        String result = input;
        for (Emoji emoji : EmojiManager.getAll()) {
            result = result.replace(emoji.getUnicode(), emoji.getHtmlDecimal());
        }
        return result;
    }

    public static String parseToHtmlHexadecimal(String input) {
        String result = input;
        for (Emoji emoji : EmojiManager.getAll()) {
            result = result.replace(emoji.getUnicode(), emoji.getHtmlHexidecimal());
        }
        return result;
    }
}

