/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor.mimetype;

import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import java.io.FileDescriptor;
import java.io.InputStream;

public class MimeTypeUtils {
    public static boolean isJpg(String mimeType) {
        return "image/jpeg".equals(mimeType) || "image/jpg".equals(mimeType);
    }

    public static boolean isPng(String mimeType) {
        return "image/png".equals(mimeType);
    }

    public static boolean isGif(String mimeType) {
        return "image/gif".equals(mimeType);
    }

    public static boolean isBmp(String mimeType) {
        return "image/bmp".equals(mimeType);
    }

    public static boolean isWebp(String mimeType) {
        return "image/webp".equals(mimeType);
    }

    public static String getMimeType(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        String mimeType = options.outMimeType;
        options.inJustDecodeBounds = false;
        return mimeType;
    }

    public static String getMimeType(Resources res, int id) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        String mimeType = options.outMimeType;
        options.inJustDecodeBounds = false;
        return mimeType;
    }

    public static String getMimeType(InputStream is) {
        return MimeTypeUtils.getMimeType(is, null);
    }

    public static String getMimeType(InputStream is, Rect outPadding) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        String mimeType = options.outMimeType;
        options.inJustDecodeBounds = false;
        return mimeType;
    }

    public static String getMimeType(FileDescriptor fd) {
        return MimeTypeUtils.getMimeType(fd, null);
    }

    public static String getMimeType(FileDescriptor fd, Rect outPadding) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        String mimeType = options.outMimeType;
        options.inJustDecodeBounds = false;
        return mimeType;
    }
}

