/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor.log;

import android.util.Log;

public class LogUtils {
    public static final int VERBOSE = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    public static final int WARN = 4;
    public static final int ERROR = 5;
    public static final int NOTHING = 6;
    private static int level = 6;
    public static final String TAG = LogUtils.class.getSimpleName();

    private LogUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static void setLevel(int level) {
        LogUtils.level = level;
    }

    public static void v(String tag, String msg) {
        if (level <= 1) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void d(String tag, String msg) {
        if (level <= 2) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void i(String tag, String msg) {
        if (level <= 3) {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void w(String tag, String msg) {
        if (level <= 4) {
            Log.w((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg) {
        if (level <= 5) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void v(String msg) {
        if (level <= 1) {
            Log.v((String)TAG, (String)msg);
        }
    }

    public static void d(String msg) {
        if (level <= 2) {
            Log.d((String)TAG, (String)msg);
        }
    }

    public static void i(String msg) {
        if (level <= 3) {
            Log.i((String)TAG, (String)msg);
        }
    }

    public static void w(String msg) {
        if (level <= 4) {
            Log.w((String)TAG, (String)msg);
        }
    }

    public static void e(String msg) {
        if (level <= 5) {
            Log.e((String)TAG, (String)msg);
        }
    }

    public static void v(Exception e) {
        if (level <= 1 && e != null) {
            Log.v((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    public static void d(Exception e) {
        if (level <= 2 && e != null) {
            Log.d((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    public static void i(Exception e) {
        if (level <= 3 && e != null) {
            Log.i((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    public static void w(Exception e) {
        if (level <= 4 && e != null) {
            Log.w((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    public static void e(Exception e) {
        if (level <= 5 && e != null) {
            Log.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }
}

