/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor.image;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import androidx.annotation.Nullable;
import com.vdreamers.vcompressor.log.LogUtils;
import java.io.File;

public class StorageUtils {
    public static final String TAG = StorageUtils.class.getSimpleName();

    private StorageUtils() {
        throw new UnsupportedOperationException("StorageUtils cannot be instantiated");
    }

    public static boolean isFileValid(File file) {
        return file != null && file.exists() && file.isFile() && file.length() > 0L && file.canRead();
    }

    public static File getInternalDir() {
        return Environment.getDataDirectory();
    }

    public static File getInternalFilesDir(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return context.getFilesDir();
    }

    public static File getInternalCacheDir(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return context.getCacheDir();
    }

    public static boolean deleteInternalFile(Context context, String name) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return context.deleteFile(name);
    }

    public static String[] getInternalFileList(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return context.fileList();
    }

    public static File getExternalFilesDir(Context context, @Nullable String type) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (!StorageUtils.isSDCardEnable()) {
            return null;
        }
        return context.getExternalFilesDir(type);
    }

    public static File getExternalCacheDir(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (!StorageUtils.isSDCardEnable()) {
            return null;
        }
        return context.getExternalCacheDir();
    }

    public static boolean isSDCardEnable() {
        return "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable();
    }

    public static File getRootDir() {
        return Environment.getRootDirectory();
    }

    public static long getExternalTotalSize(Context context) {
        File file;
        if (StorageUtils.isSDCardEnable() && (file = StorageUtils.getExternalFilesDir(context, null)) != null) {
            return file.getTotalSpace();
        }
        return 0L;
    }

    public static long getExternalFreeSize(Context context) {
        File file;
        if (StorageUtils.isSDCardEnable() && (file = StorageUtils.getExternalFilesDir(context, null)) != null) {
            return file.getFreeSpace();
        }
        return 0L;
    }

    public static long getInternalTotalSize() {
        return StorageUtils.getInternalDir().getTotalSpace();
    }

    public static long getInternalFreeSize() {
        return StorageUtils.getInternalDir().getFreeSpace();
    }

    public static long getFreeBytes(String filePath) {
        long availableBlocks;
        long blockSize;
        StatFs statFs = new StatFs(filePath);
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = statFs.getBlockSizeLong();
            availableBlocks = statFs.getAvailableBlocksLong();
        } else {
            blockSize = statFs.getBlockSize();
            availableBlocks = statFs.getAvailableBlocks();
        }
        return blockSize * availableBlocks;
    }

    public static long getTotalBytes(String filePath) {
        long totalSize;
        long blockSize;
        StatFs statFs = new StatFs(filePath);
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = statFs.getBlockSizeLong();
            totalSize = statFs.getBlockCountLong();
        } else {
            blockSize = statFs.getBlockSize();
            totalSize = statFs.getBlockCount();
        }
        return blockSize * totalSize;
    }

    public static String getFilesPath(Context context, String dir) {
        File file;
        String directoryPath = StorageUtils.isSDCardEnable() ? ((file = context.getExternalFilesDir(dir)) != null ? file.getAbsolutePath() + File.separator + dir : context.getFilesDir() + File.separator + dir) : context.getFilesDir() + File.separator + dir;
        file = new File(directoryPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        LogUtils.d(TAG, directoryPath);
        return directoryPath;
    }

    public static String getCachePath(Context context) {
        return StorageUtils.getCachePath(context, "");
    }

    public static String getCachePath(Context context, String subDir) {
        File file;
        if (context == null) {
            return "";
        }
        if (subDir == null) {
            subDir = "";
        }
        String directoryPath = StorageUtils.isSDCardEnable() ? ((file = context.getExternalCacheDir()) != null ? file.getAbsolutePath() + File.separator + subDir : context.getCacheDir() + File.separator + subDir) : context.getCacheDir() + File.separator + subDir;
        file = new File(directoryPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        LogUtils.d(TAG, directoryPath);
        return directoryPath;
    }
}

