/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor.image;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.ExifInterface;
import com.vdreamers.vcompressor.log.LogUtils;
import java.io.IOException;

public class ImageUtils {
    public static int getExifOrientation(String filepath) {
        int orientation;
        int degree = 0;
        ExifInterface exif = null;
        try {
            exif = new ExifInterface(filepath);
        }
        catch (IOException e) {
            LogUtils.e("getExifOrientation stop running unexpected. " + e.getMessage());
        }
        if (exif != null && (orientation = exif.getAttributeInt("Orientation", -1)) != -1) {
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
                default: {
                    degree = 0;
                }
            }
        }
        return degree;
    }

    public static Bitmap rotateImage(Bitmap bitmap, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }
}

