/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor.image;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import com.vdreamers.vcompressor.log.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.OutputStream;

public class BitmapUtils {
    public static Bitmap nnrSizeCompress(String pathName, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
    }

    public static Bitmap nnrSizeCompress(Resources res, int id, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
    }

    public static Bitmap nnrSizeCompress(FileDescriptor fd, int reqWidth, int reqHeight) {
        return BitmapUtils.nnrSizeCompress(fd, null, reqWidth, reqHeight);
    }

    public static Bitmap nnrSizeCompress(FileDescriptor fd, Rect outPadding, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static Bitmap brSizeCompress(Bitmap bitmap, int reqWidth, int reqHeight) {
        if (bitmap.getWidth() <= reqWidth && bitmap.getHeight() <= reqHeight) {
            return bitmap;
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)reqWidth, (int)reqHeight, (boolean)true);
    }

    public static void qualityCompress(Bitmap bitmap, Bitmap.CompressFormat format, int quality, ByteArrayOutputStream byteArrayOutputStream, int maxSize) {
        bitmap.compress(format, quality, (OutputStream)byteArrayOutputStream);
        if (maxSize > 0) {
            while (byteArrayOutputStream.size() / 1024 > maxSize) {
                byteArrayOutputStream.reset();
                if (quality < 0) break;
                bitmap.compress(format, quality, (OutputStream)byteArrayOutputStream);
                LogUtils.d("Compress : quantity:" + quality + " size:" + byteArrayOutputStream.size() / 1024);
                if (byteArrayOutputStream.size() / 1024 - maxSize < 100) {
                    quality -= 2;
                    continue;
                }
                quality -= 5;
            }
        }
    }
}

