/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor.fotmat;

import android.graphics.Bitmap;
import android.os.Build;

public class CompressFormatUtils {
    public static Bitmap.CompressFormat parseFormat(String fileName) {
        int dotPos = fileName.lastIndexOf(".");
        if (dotPos <= 0 || dotPos + 1 >= fileName.length()) {
            return Bitmap.CompressFormat.JPEG;
        }
        String ext = fileName.substring(dotPos + 1);
        if ("jpg".equalsIgnoreCase(ext) || "jpeg".equalsIgnoreCase(ext)) {
            return Bitmap.CompressFormat.JPEG;
        }
        if ("png".equalsIgnoreCase(ext)) {
            return Bitmap.CompressFormat.PNG;
        }
        if (Build.VERSION.SDK_INT >= 14 && "webp".equalsIgnoreCase(ext)) {
            return Bitmap.CompressFormat.WEBP;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static String getSuffixName(Bitmap.CompressFormat format) {
        if (format == Bitmap.CompressFormat.PNG) {
            return "png";
        }
        if (Build.VERSION.SDK_INT >= 14 && format == Bitmap.CompressFormat.WEBP) {
            return "webp";
        }
        return "jpg";
    }

    public static String getSuffixName(String fileName) {
        Bitmap.CompressFormat format = CompressFormatUtils.parseFormat(fileName);
        return CompressFormatUtils.getSuffixName(format);
    }
}

