/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor.executor;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vdreamers.vcompressor.executor.CompressExecutor;
import com.vdreamers.vcompressor.log.LogUtils;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;

public class CompressExecutorUtils {
    private ExecutorService mExecutorService;
    private static final int MAXIMUM_THREAD_NUM = 4;

    private CompressExecutorUtils() {
    }

    public static CompressExecutorUtils getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void runWorker(@NonNull Runnable runnable) {
        this.ensureWorkerHandlerNotNull();
        try {
            this.mExecutorService.execute(runnable);
        }
        catch (Exception e) {
            LogUtils.e("runnable stop running unexpected. " + e.getMessage());
        }
    }

    @Nullable
    public FutureTask<File> runWorker(@NonNull Callable<File> callable) {
        this.ensureWorkerHandlerNotNull();
        FutureTask<File> task = null;
        try {
            task = new FutureTask<File>(callable);
            this.mExecutorService.submit(task);
            return task;
        }
        catch (Exception e) {
            LogUtils.e("callable stop running unexpected. " + e.getMessage());
            return task;
        }
    }

    public void runUI(@NonNull Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
            return;
        }
        Handler handler = this.ensureUiHandlerNotNull();
        try {
            handler.post(runnable);
        }
        catch (Exception e) {
            LogUtils.d("update UI task fail. " + e.getMessage());
        }
    }

    private void ensureWorkerHandlerNotNull() {
        if (this.mExecutorService == null) {
            this.mExecutorService = CompressExecutor.newExecutor(CompressExecutorUtils.calculateBestThreadCount());
        }
    }

    public static int calculateBestThreadCount() {
        return Math.min(4, Runtime.getRuntime().availableProcessors());
    }

    private Handler ensureUiHandlerNotNull() {
        return new Handler(Looper.getMainLooper());
    }

    private static class SingletonHolder {
        private static final CompressExecutorUtils INSTANCE = new CompressExecutorUtils();

        private SingletonHolder() {
        }
    }
}

