/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor.config;

import android.graphics.Bitmap;

public class CompressConfig {
    public static final boolean DEFAULT_COMPRESS_SCALED = true;
    public static final int DEFAULT_COMPRESS_MAX_SIZE = 400;
    public static final int DEFAULT_COMPRESS_MAX_WIDTH = 800;
    public static final int DEFAULT_COMPRESS_MAX_HEIGHT = 800;
    public static final int DEFAULT_COMPRESS_QUALITY = 100;
    public static final boolean DEFAULT_FORCE_COMPRESS_FORMAT = false;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private int mCompressMaxSize = 400;
    private boolean mScaled = true;
    private int mCompressMaxWidth = 800;
    private int mCompressMaxHeight = 800;
    private int mQuality = 100;
    private boolean mForceFormat = false;
    private Bitmap.CompressFormat mFormat = DEFAULT_COMPRESS_FORMAT;

    private CompressConfig() {
    }

    public static CompressConfig init() {
        return new CompressConfig();
    }

    public CompressConfig setScaled(boolean scaled) {
        this.mScaled = scaled;
        return this;
    }

    public CompressConfig setCompressMaxWidth(int compressMaxWidth) {
        this.mCompressMaxWidth = compressMaxWidth;
        return this;
    }

    public CompressConfig setCompressMaxHeight(int compressMaxHeight) {
        this.mCompressMaxHeight = compressMaxHeight;
        return this;
    }

    public CompressConfig setCompressMaxSize(int compressMaxSize) {
        this.mCompressMaxSize = compressMaxSize;
        return this;
    }

    public CompressConfig setQuality(int quality) {
        this.mQuality = quality;
        return this;
    }

    public CompressConfig setForceFormat(boolean forceFormat) {
        this.mForceFormat = forceFormat;
        return this;
    }

    public CompressConfig setFormat(Bitmap.CompressFormat format) {
        this.mFormat = format;
        return this;
    }

    public int getCompressMaxSize() {
        return this.mCompressMaxSize;
    }

    public boolean isScaled() {
        return this.mScaled;
    }

    public int getCompressMaxWidth() {
        return this.mCompressMaxWidth;
    }

    public int getCompressMaxHeight() {
        return this.mCompressMaxHeight;
    }

    public int getQuality() {
        return this.mQuality;
    }

    public boolean isForceFormat() {
        return this.mForceFormat;
    }

    public Bitmap.CompressFormat getFormat() {
        return this.mFormat;
    }
}

