/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor.compressor;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vdreamers.vcompressor.compressor.ICompressor;
import com.vdreamers.vcompressor.config.CompressConfig;
import com.vdreamers.vcompressor.fotmat.CompressFormatUtils;
import com.vdreamers.vcompressor.image.BitmapUtils;
import com.vdreamers.vcompressor.image.ImageUtils;
import com.vdreamers.vcompressor.image.StorageUtils;
import com.vdreamers.vcompressor.log.LogUtils;
import com.vdreamers.vcompressor.mimetype.MimeTypeUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class DefaultCompressor
implements ICompressor {
    private WeakReference<Context> mContextWeakReference;
    private CompressConfig mCompressConfig;
    private static final String FILE_NAME_PRE = "compressed_";

    private DefaultCompressor() {
    }

    public DefaultCompressor(@NonNull Context context) {
        this(context, null);
    }

    public DefaultCompressor(@NonNull Context context, CompressConfig config) {
        this.mContextWeakReference = new WeakReference<Context>(context);
        this.mCompressConfig = config;
        if (this.mCompressConfig == null) {
            this.mCompressConfig = CompressConfig.init();
        }
    }

    @Override
    public File getCompressOutFile(String fileName, File file) {
        String compressedFileName;
        if (this.mCompressConfig.isForceFormat()) {
            compressedFileName = fileName + "." + CompressFormatUtils.getSuffixName(this.mCompressConfig.getFormat());
            LogUtils.i("use compress format:" + CompressFormatUtils.getSuffixName(this.mCompressConfig.getFormat()));
        } else {
            compressedFileName = fileName + "." + CompressFormatUtils.getSuffixName(file.getAbsolutePath());
            LogUtils.i("use compress format:" + CompressFormatUtils.getSuffixName(file.getAbsolutePath()));
        }
        return new File(StorageUtils.getCachePath((Context)this.mContextWeakReference.get()) + compressedFileName);
    }

    @Override
    @Nullable
    public File compress(File file) throws IOException, IllegalArgumentException {
        Bitmap resultBitmap;
        if (!StorageUtils.isFileValid(file)) {
            return null;
        }
        String path = file.getAbsolutePath();
        String mimeType = MimeTypeUtils.getMimeType(path);
        if (MimeTypeUtils.isGif(mimeType)) {
            return null;
        }
        if (this.mCompressConfig.isScaled()) {
            Bitmap nnrBitmap = BitmapUtils.nnrSizeCompress(path, this.mCompressConfig.getCompressMaxWidth(), this.mCompressConfig.getCompressMaxHeight());
            if (nnrBitmap != (resultBitmap = BitmapUtils.brSizeCompress(nnrBitmap, this.mCompressConfig.getCompressMaxWidth(), this.mCompressConfig.getCompressMaxHeight()))) {
                nnrBitmap.recycle();
            }
        } else {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = 1;
            resultBitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        int angle = ImageUtils.getExifOrientation(path);
        if (angle != 0) {
            LogUtils.d("rotate image from:" + angle);
            Bitmap rotateBitmap = ImageUtils.rotateImage(resultBitmap, angle);
            if (resultBitmap != rotateBitmap) {
                resultBitmap.recycle();
            }
            resultBitmap = rotateBitmap;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BitmapUtils.qualityCompress(resultBitmap, this.mCompressConfig.getFormat(), this.mCompressConfig.getQuality(), byteArrayOutputStream, this.mCompressConfig.getCompressMaxSize());
        File outputFile = this.getCompressOutFile(FILE_NAME_PRE + System.currentTimeMillis(), file);
        if (outputFile.exists() && outputFile.isFile()) {
            outputFile.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile, true);
        byte[] bytes = byteArrayOutputStream.toByteArray();
        fileOutputStream.write(bytes);
        fileOutputStream.flush();
        fileOutputStream.close();
        return outputFile;
    }
}

