/*
 * Decompiled with CFR 0.152.
 */
package com.vdreamers.vcompressor;

import android.content.Context;
import com.vdreamers.vcompressor.compressor.DefaultCompressor;
import com.vdreamers.vcompressor.compressor.ICompressor;
import com.vdreamers.vcompressor.config.CompressConfig;
import com.vdreamers.vcompressor.executor.CompressCallable;
import com.vdreamers.vcompressor.executor.CompressExecutorUtils;
import com.vdreamers.vcompressor.listener.CompressListener;
import com.vdreamers.vcompressor.log.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class CompressUtils {
    private CompressConfig mCompressConfig;
    private CompressListener mCompressListener;

    private CompressUtils() {
    }

    public static CompressUtils of() {
        return new CompressUtils();
    }

    public CompressUtils setCompressConfig(CompressConfig compressConfig) {
        this.mCompressConfig = compressConfig;
        return this;
    }

    public CompressUtils setCompressListener(CompressListener compressListener) {
        this.mCompressListener = compressListener;
        return this;
    }

    public boolean compress(Context context, List<File> fileList) {
        return this.compress(new DefaultCompressor(context, this.mCompressConfig), fileList, this.mCompressListener);
    }

    public boolean compress(ICompressor compressor, List<File> fileList, final CompressListener compressListener) {
        FutureTask task;
        if (compressor == null || fileList == null) {
            return false;
        }
        CompressExecutorUtils.getInstance().runUI(new Runnable(){

            @Override
            public void run() {
                if (compressListener != null) {
                    compressListener.onStart();
                }
            }
        });
        int size = fileList.size();
        ArrayList<FutureTask> taskList = new ArrayList<FutureTask>(size);
        for (File file : fileList) {
            task = CompressExecutorUtils.getInstance().runWorker(new CompressCallable(compressor, file));
            taskList.add(task);
        }
        final ArrayList<File> resultFileList = new ArrayList<File>(size);
        for (int i = 0; i < size; ++i) {
            try {
                task = (FutureTask)taskList.get(i);
                if (task == null) continue;
                File file = (File)task.get();
                if (file == null) {
                    resultFileList.add(fileList.get(i));
                    continue;
                }
                resultFileList.add(file);
                continue;
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                LogUtils.e("futureTask stop running unexpected. " + e.getMessage());
                CompressExecutorUtils.getInstance().runUI(new Runnable(){

                    @Override
                    public void run() {
                        if (compressListener != null) {
                            compressListener.onFailed(e);
                        }
                    }
                });
                return false;
            }
        }
        CompressExecutorUtils.getInstance().runUI(new Runnable(){

            @Override
            public void run() {
                if (compressListener != null) {
                    compressListener.onSuccess(resultFileList);
                }
            }
        });
        return true;
    }
}

