package com.vdreamers.vcompressor.executor;

import com.vdreamers.vcompressor.compressor.ICompressor;
import com.vdreamers.vcompressor.image.StorageUtils;

import java.io.File;
import java.util.concurrent.Callable;

public class CompressCallable implements Callable<File> {

    private ICompressor mCompressor;
    private File mFile;

    public CompressCallable(ICompressor compressor, File file){
        mCompressor  = compressor;
        mFile = file;
    }

    @Override
    public File call() throws Exception {
        File result = null;
        if (mCompressor != null) {
            result = mCompressor.compress(mFile);
        }
        boolean resultVailid = StorageUtils.isFileValid(result);
        return resultVailid ? result : mFile;
    }
}
