/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.uikit.view;

import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import com.vdian.uikit.util.RectUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ViewGroupMonitor
implements View.OnAttachStateChangeListener,
ViewTreeObserver.OnPreDrawListener {
    private static boolean doDraw = true;
    private boolean isAttached = false;
    private boolean isRaw;
    private ViewGroup mParent;
    private ChildListener mListener;

    public static void cancelDraw() {
        doDraw = false;
    }

    public static void globalMonitor(ViewGroup parent, ChildListener listener) {
        if (parent == null || listener == null) {
            return;
        }
        parent.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new ViewGroupMonitor(true, parent, listener));
    }

    public static void localMonitor(ViewGroup parent, ChildListener listener) {
        if (parent == null || listener == null) {
            return;
        }
        parent.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new ViewGroupMonitor(false, parent, listener));
    }

    private ViewGroupMonitor(boolean raw, ViewGroup parent, ChildListener listener) {
        this.isRaw = raw;
        this.mParent = parent;
        this.mListener = listener;
        if (ViewCompat.isAttachedToWindow((View)this.mParent)) {
            this.onViewAttachedToWindow(null);
        }
    }

    public void onViewAttachedToWindow(View v) {
        if (this.isAttached) {
            return;
        }
        this.isAttached = true;
        this.mParent.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        if (this.mListener instanceof ChildListeners) {
            ((ChildListeners)this.mListener).monitor(this.isAttached);
        }
    }

    public void onViewDetachedFromWindow(View v) {
        if (!this.isAttached) {
            return;
        }
        this.isAttached = false;
        this.mParent.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        if (this.mListener instanceof ChildListeners) {
            ((ChildListeners)this.mListener).monitor(this.isAttached);
        }
    }

    public boolean onPreDraw() {
        doDraw = true;
        Child.release(this.mListener.handle(Child.request(this.isRaw, this.mParent)));
        return doDraw;
    }

    public static interface ChildListeners
    extends ChildListener {
        public void monitor(boolean var1);
    }

    public static interface ChildListener {
        public List<Child> handle(List<Child> var1);
    }

    public static class Child
    implements Comparable<Child> {
        private static Queue<List<Child>> list = new LinkedList<List<Child>>();
        private static Queue<Child> cell = new LinkedList<Child>();
        private static Rect origin = new Rect();
        public int index = -1;
        public int position = -1;
        public Rect rect = new Rect();

        protected static List<Child> request(boolean raw, ViewGroup parent) {
            if (raw) {
                ArrayList<Child> children = list.size() > 0 ? list.remove() : new ArrayList();
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    Child child = cell.size() > 0 ? cell.remove() : new Child();
                    child.index = i;
                    child.position = Child.position(parent, i);
                    RectUtil.measure(parent.getChildAt(i), child.rect);
                    children.add(child);
                }
                return children;
            }
            RectUtil.measure((View)parent, origin);
            ArrayList<Child> children = list.size() > 0 ? list.remove() : new ArrayList();
            for (int i = 0; i < parent.getChildCount(); ++i) {
                Child child = cell.size() > 0 ? cell.remove() : new Child();
                child.index = i;
                child.position = Child.position(parent, i);
                RectUtil.measure(parent.getChildAt(i), child.rect);
                child.rect.set(child.rect.left - Child.origin.left, child.rect.top - Child.origin.top, child.rect.right - Child.origin.left, child.rect.bottom - Child.origin.top);
                children.add(child);
            }
            return children;
        }

        protected static void release(List<Child> children) {
            if (children != null) {
                cell.addAll(children);
                children.clear();
                list.add(children);
            }
        }

        private static int position(ViewGroup parent, int index) {
            if (parent instanceof AdapterView) {
                return ((AdapterView)parent).getPositionForView(parent.getChildAt(index));
            }
            if (parent instanceof RecyclerView) {
                return ((RecyclerView)parent).getChildAdapterPosition(parent.getChildAt(index));
            }
            return index;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Child) {
                if (this.index != ((Child)obj).index) {
                    return false;
                }
                if (this.position != ((Child)obj).position) {
                    return false;
                }
                return !(this.rect == null || ((Child)obj).rect == null ? this.rect != null || ((Child)obj).rect != null : !this.rect.equals((Object)((Child)obj).rect));
            }
            return false;
        }

        @Override
        public int compareTo(Child o) {
            if (this.position != o.position) {
                return this.position - o.position;
            }
            return this.index - o.index;
        }
    }
}

