/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.uikit.view;

import android.view.View;
import android.view.animation.AnimationUtils;

public class TransitionController {
    private boolean resetTime = true;
    private long lastTime = 0L;
    private float mValue;
    private float mTarget;
    private View mView;
    private TransitionListener mTransitionListener;

    public TransitionController(TransitionListener listener, View view) {
        this(listener, view, -1.0f);
    }

    public TransitionController(TransitionListener listener, View view, float value) {
        if (value < 0.0f || value > 1.0f) {
            value = 0.0f;
        }
        this.mTransitionListener = listener;
        this.mView = view;
        this.mValue = value;
        this.mTarget = value;
    }

    public void initDisplay() {
        this.mTransitionListener.display(this.mView, this.mValue);
    }

    public float getValue() {
        return this.mValue;
    }

    public void setValue(float value) {
        if (value < 0.0f || value > 1.0f) {
            return;
        }
        this.mTarget = value;
        this.mValue = value;
        this.resetTime = true;
        this.mTransitionListener.display(this.mView, this.mValue);
    }

    public float getTarget() {
        return this.mTarget;
    }

    public void setTarget(float target) {
        if (target < 0.0f || target > 1.0f) {
            return;
        }
        this.mTarget = target;
        if (this.mValue == this.mTarget) {
            this.resetTime = true;
        } else {
            this.mView.invalidate();
        }
    }

    public void computeScroll() {
        if (this.mValue != this.mTarget) {
            if (this.resetTime) {
                this.lastTime = AnimationUtils.currentAnimationTimeMillis();
                this.resetTime = false;
            } else {
                long dTime = AnimationUtils.currentAnimationTimeMillis() - this.lastTime;
                if (dTime > 0L) {
                    this.lastTime += dTime;
                    float dValue = (float)this.reduce(dTime) * this.mTransitionListener.speed(this.mValue, this.mTarget);
                    if (this.mValue < this.mTarget) {
                        this.mValue += dValue;
                        if (this.mValue >= this.mTarget) {
                            this.mValue = this.mTarget;
                            this.resetTime = true;
                        }
                    } else {
                        this.mValue -= dValue;
                        if (this.mValue <= this.mTarget) {
                            this.mValue = this.mTarget;
                            this.resetTime = true;
                        }
                    }
                    this.mTransitionListener.display(this.mView, this.mValue);
                }
            }
            this.mView.postInvalidate();
        }
    }

    protected long reduce(long time) {
        return time;
    }

    public static interface TransitionListener {
        public float speed(float var1, float var2);

        public void display(View var1, float var2);
    }
}

