/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.uikit.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.WeakHashMap;

public abstract class AnimatorManager {
    private WeakHashMap<View, HashMap<String, Object>> map = new WeakHashMap();

    protected abstract float get(View var1);

    protected abstract void set(View var1, float var2);

    protected abstract Animator create(View var1, float var2, float var3);

    public float getValue(View view) {
        return this.get(view);
    }

    public void setValue(View view, float value) {
        HashMap<String, Object> expand = this.map.get(view);
        if (expand != null) {
            expand.remove("target");
            Object a = expand.remove("animator");
            if (a instanceof Animator && ((Animator)a).isRunning()) {
                ((Animator)a).cancel();
            }
        }
        this.set(view, value);
    }

    public float getTarget(View view) {
        Object t;
        HashMap<String, Object> expand = this.map.get(view);
        if (expand != null && (t = expand.get("target")) instanceof Float) {
            return ((Float)t).floatValue();
        }
        return this.get(view);
    }

    public void setTarget(View view, float target) {
        float value = this.get(view);
        HashMap<String, Object> expand = this.map.get(view);
        if (expand == null) {
            if (value == target) {
                return;
            }
            expand = new HashMap();
            this.map.put(view, expand);
        } else {
            Object t = expand.get("target");
            if (t instanceof Float ? ((Float)t).floatValue() == target : value == target) {
                return;
            }
            Object a = expand.get("animator");
            if (a instanceof Animator && ((Animator)a).isRunning()) {
                ((Animator)a).cancel();
            }
        }
        Animator animator = this.create(view, value, target);
        animator.start();
        expand.put("animator", animator);
        expand.put("target", Float.valueOf(target));
    }

    public static class RotationManager
    extends PropertyManager {
        public RotationManager() {
            super(5);
        }
    }

    public static class ScaleManager
    extends PropertyManager {
        public ScaleManager() {
            super(4);
        }
    }

    public static class AlphaManager
    extends PropertyManager {
        public AlphaManager() {
            super(3);
        }
    }

    public static class YManager
    extends PropertyManager {
        public YManager() {
            super(2);
        }
    }

    public static class XManager
    extends PropertyManager {
        public XManager() {
            super(1);
        }
    }

    private static class PropertyManager
    extends BaseManager {
        public static final int X = 1;
        public static final int Y = 2;
        public static final int ALPHA = 3;
        public static final int SCALE = 4;
        public static final int ROTATION = 5;
        private int property;

        public PropertyManager(int property) {
            this.property = property;
        }

        @Override
        protected final float get(View view) {
            switch (this.property) {
                case 1: {
                    return view.getTranslationX();
                }
                case 2: {
                    return view.getTranslationY();
                }
                case 3: {
                    return view.getAlpha();
                }
                case 4: {
                    return (view.getScaleX() + view.getScaleY()) / 2.0f;
                }
                case 5: {
                    return view.getRotation();
                }
            }
            return 0.0f;
        }

        @Override
        protected final void set(View view, float value) {
            switch (this.property) {
                case 1: {
                    view.setTranslationX(value);
                    break;
                }
                case 2: {
                    view.setTranslationY(value);
                    break;
                }
                case 3: {
                    view.setAlpha(value);
                    break;
                }
                case 4: {
                    view.setScaleX(value);
                    view.setScaleY(value);
                    break;
                }
                case 5: {
                    view.setRotation(value);
                }
            }
            if (this.invalidate()) {
                view.invalidate();
            }
        }

        @Override
        protected long duration(View view, float from, float to) {
            switch (this.property) {
                case 1: {
                    return (long)(300.0f * Math.abs(from - to) / (float)view.getContext().getResources().getDisplayMetrics().widthPixels);
                }
                case 2: {
                    return (long)(300.0f * Math.abs(from - to) / (float)view.getContext().getResources().getDisplayMetrics().heightPixels);
                }
                case 3: {
                    return (long)(300.0f * Math.abs(from - to));
                }
                case 4: {
                    return (long)(300.0f * Math.abs(from - to));
                }
                case 5: {
                    return (long)(300.0f * Math.abs(from - to) / 360.0f);
                }
            }
            return 0L;
        }

        @Override
        protected TimeInterpolator interpolator(View view, float from, float to) {
            return null;
        }

        protected boolean invalidate() {
            return false;
        }
    }

    public static abstract class BaseManager
    extends AnimatorManager {
        @Override
        protected final Animator create(View view, float value, float target) {
            return new BaseAnimator(view, value, target);
        }

        protected abstract long duration(View var1, float var2, float var3);

        protected abstract TimeInterpolator interpolator(View var1, float var2, float var3);

        private class BaseAnimator
        extends ValueAnimator
        implements ValueAnimator.AnimatorUpdateListener {
            private WeakReference<View> reference;

            private BaseAnimator(View view, float from, float to) {
                this.reference = new WeakReference<View>(view);
                this.setFloatValues(new float[]{from, to});
                this.addUpdateListener(this);
                this.setDuration(BaseManager.this.duration(view, from, to));
                this.setInterpolator(BaseManager.this.interpolator(view, from, to));
            }

            public void onAnimationUpdate(ValueAnimator animation) {
                View view = (View)this.reference.get();
                if (view == null) {
                    return;
                }
                Object value = animation.getAnimatedValue();
                if (!(value instanceof Float)) {
                    return;
                }
                BaseManager.this.set(view, ((Float)value).floatValue());
            }
        }
    }
}

