/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.uikit.view;

import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewParent;

public class TouchController {
    private boolean isTouch = false;
    private int[] touchPointId = new int[5];
    private float[] touchPointX = new float[5];
    private float[] touchPointY = new float[5];
    private float downX = 0.0f;
    private float downY = 0.0f;
    private boolean doCancel = false;
    private float moveX = 0.0f;
    private float moveY = 0.0f;
    private float absX = 0.0f;
    private float absY = 0.0f;
    private float absLimit = 0.0f;
    private int judgeMode = 0;
    private int judgeState = 0;
    private boolean canParent = false;
    private boolean canChild = false;
    private boolean doIntercept = false;
    private float velocityX = 0.0f;
    private float velocityY = 0.0f;
    private VelocityTracker mVelocityTracker;
    private View mView;
    private TouchListener mTouchListener;

    public TouchController(TouchListener listener) {
        this(listener, null, false, false);
    }

    public TouchController(TouchListener listener, View view, boolean x, boolean y) {
        for (int i = 0; i < this.touchPointId.length; ++i) {
            this.touchPointId[i] = -1;
        }
        this.mTouchListener = listener;
        if (view != null) {
            this.mView = view;
            this.absLimit = 4.0f * this.mView.getContext().getResources().getDisplayMetrics().density;
            this.judgeMode = y ? (x ? 3 : 2) : (x ? 1 : 0);
        }
    }

    public boolean isTouch() {
        return this.isTouch;
    }

    public Boolean dispatchTouchEvent(MotionEvent event) {
        int i;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 1: {
                this.mVelocityTracker.computeCurrentVelocity(1);
                this.velocityX = this.mVelocityTracker.getXVelocity();
                this.velocityY = this.mVelocityTracker.getYVelocity();
            }
            case 3: {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        int action = event.getAction();
        int masked = event.getActionMasked();
        if (action == 0) {
            if (this.isTouch) {
                for (i = 0; i < this.touchPointId.length; ++i) {
                    this.touchPointId[i] = -1;
                }
                this.isTouch = false;
            }
            this.downX = event.getRawX();
            this.downY = event.getRawY();
            this.absX = 0.0f;
            this.absY = 0.0f;
            this.judgeState = 0;
            this.canParent = true;
            this.canChild = true;
            this.doIntercept = false;
        }
        this.moveX = 0.0f;
        this.moveY = 0.0f;
        if (this.judgeState > 0 && this.canChild) {
            this.canChild = false;
            this.doIntercept = true;
        }
        if (action == 0 || masked == 5) {
            int id = event.getPointerId(event.getActionIndex());
            for (int i2 = 0; i2 < this.touchPointId.length; ++i2) {
                if (this.touchPointId[i2] != -1) continue;
                this.touchPointId[i2] = id;
                this.touchPointX[i2] = this.getRawX(event, event.getActionIndex());
                this.touchPointY[i2] = this.getRawY(event, event.getActionIndex());
                this.isTouch = true;
                break;
            }
        }
        if (action == 2) {
            for (i = 0; i < this.touchPointId.length; ++i) {
                int index = -1;
                if (this.touchPointId[i] != -1) {
                    index = event.findPointerIndex(this.touchPointId[i]);
                }
                if (index == -1) continue;
                float dX = this.getRawX(event, index) - this.touchPointX[i];
                int n = i;
                this.touchPointX[n] = this.touchPointX[n] + dX;
                this.moveX += dX;
                float dY = this.getRawY(event, index) - this.touchPointY[i];
                int n2 = i;
                this.touchPointY[n2] = this.touchPointY[n2] + dY;
                this.moveY += dY;
            }
            this.absX += Math.abs(this.moveX);
            this.absY += Math.abs(this.moveY);
            if (this.judgeState == 0) {
                if (this.absX > this.absY) {
                    if (this.absX > this.absLimit) {
                        this.judgeState = this.judgeMode % 2 == 1 ? 1 : -1;
                    }
                } else if (this.absY > this.absLimit) {
                    int n = this.judgeState = this.judgeMode / 2 == 1 ? 1 : -1;
                }
            }
        }
        if (action == 1 || masked == 6) {
            boolean b = false;
            int id = event.getPointerId(event.getActionIndex());
            for (int i3 = 0; i3 < this.touchPointId.length; ++i3) {
                if (this.touchPointId[i3] == id) {
                    this.touchPointId[i3] = -1;
                }
                if (this.touchPointId[i3] == -1) continue;
                b = true;
            }
            this.isTouch = b;
        }
        if (action == 3 && this.isTouch) {
            for (i = 0; i < this.touchPointId.length; ++i) {
                this.touchPointId[i] = -1;
            }
            this.isTouch = false;
        }
        if (this.judgeState > 0 && this.canParent) {
            ViewParent parent;
            this.canParent = false;
            if (this.mView != null && (parent = this.mView.getParent()) != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
        }
        switch (event.getAction()) {
            case 0: {
                this.doCancel = !this.mTouchListener.down(this.downX, this.downY);
                break;
            }
            case 1: {
                if (this.doCancel) break;
                this.mTouchListener.up(this.velocityX, this.velocityY);
                break;
            }
            case 3: {
                if (this.doCancel) break;
                this.mTouchListener.cancel();
            }
        }
        if (this.doCancel) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 2: {
                if (!this.mTouchListener.move(this.moveX, this.moveY)) break;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public Boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.doIntercept) {
            return Boolean.TRUE;
        }
        return null;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.canChild = false;
        }
    }

    private float getRawX(MotionEvent event, int index) {
        return event.getRawX() - event.getX() + event.getX(index);
    }

    private float getRawY(MotionEvent event, int index) {
        return event.getRawY() - event.getY() + event.getY(index);
    }

    public static interface TouchListener {
        public boolean down(float var1, float var2);

        public boolean move(float var1, float var2);

        public void up(float var1, float var2);

        public void cancel();
    }
}

