/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.uikit.view;

import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.support.v7.util.DiffUtil;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public abstract class NotifyManager<D> {
    private RecyclerView mView;
    private RecyclerView.Adapter mAdapter;
    private Rect mRect = new Rect();
    private List<D> mBefore;
    private List<D> mAfter;
    private DiffUtil.Callback mCallback;
    private Boolean isAttached;
    private ScrollOrder mLazy;

    public NotifyManager(RecyclerView view, RecyclerView.Adapter adapter) {
        this.mView = view;
        this.mAdapter = adapter;
        this.mRect = new Rect();
        this.mBefore = new ArrayList<D>();
        this.mAfter = new ArrayList<D>();
        this.mCallback = new DiffUtil.Callback(){

            public int getOldListSize() {
                return NotifyManager.this.mBefore.size();
            }

            public int getNewListSize() {
                return NotifyManager.this.mAfter.size();
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                return NotifyManager.this.sameItem(NotifyManager.this.mBefore.get(oldItemPosition), NotifyManager.this.mAfter.get(newItemPosition));
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                return NotifyManager.this.sameData(NotifyManager.this.mBefore.get(oldItemPosition), NotifyManager.this.mAfter.get(newItemPosition));
            }
        };
        this.mView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                if (Boolean.TRUE.equals(NotifyManager.this.isAttached)) {
                    return;
                }
                NotifyManager.this.isAttached = Boolean.TRUE;
                if (NotifyManager.this.mLazy != null) {
                    NotifyManager.this.scrollToPositionWithOffset(((NotifyManager)NotifyManager.this).mLazy.stop, ((NotifyManager)NotifyManager.this).mLazy.position, ((NotifyManager)NotifyManager.this).mLazy.offset);
                    NotifyManager.this.mLazy.recycle();
                    NotifyManager.this.mLazy = null;
                }
            }

            public void onViewDetachedFromWindow(View v) {
                if (Boolean.FALSE.equals(NotifyManager.this.isAttached)) {
                    return;
                }
                NotifyManager.this.isAttached = Boolean.FALSE;
            }
        });
    }

    public void onPreChanged(List<D> before) {
        this.mBefore.addAll(before);
    }

    public void onChanged(List<D> after) {
        this.mAfter.addAll(after);
        if (this.mLazy != null) {
            DiffUtil.calculateDiff((DiffUtil.Callback)this.mCallback).dispatchUpdatesTo(this.mAdapter);
            this.mView.postInvalidate();
        } else {
            boolean horizontal = false;
            RecyclerView.LayoutManager manager = this.mView.getLayoutManager();
            if (manager instanceof LinearLayoutManager) {
                horizontal = ((LinearLayoutManager)manager).getOrientation() == 0;
            } else if (manager instanceof StaggeredGridLayoutManager) {
                horizontal = ((StaggeredGridLayoutManager)manager).getOrientation() == 0;
            }
            int position = -1;
            int offset = 0;
            for (int i = 0; i < this.mView.getChildCount(); ++i) {
                int p;
                View child = this.mView.getChildAt(i);
                if (child == null || (p = this.mView.getChildAdapterPosition(child)) == -1 || position != -1 && position <= p) continue;
                position = p;
                this.mView.getDecoratedBoundsWithMargins(child, this.mRect);
                offset = horizontal ? this.mRect.left - this.mView.getPaddingLeft() : this.mRect.top - this.mView.getPaddingTop();
            }
            DiffUtil.calculateDiff((DiffUtil.Callback)this.mCallback).dispatchUpdatesTo(this.mAdapter);
            this.mView.postInvalidate();
            this.scrollToPositionWithOffset(false, position, offset);
        }
        this.mBefore.clear();
        this.mAfter.clear();
    }

    public void scrollToPositionWithOffset(boolean stop, int position, int offset) {
        if (this.isAttached == null) {
            Boolean bl = this.isAttached = ViewCompat.isAttachedToWindow((View)this.mView) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (Boolean.TRUE.equals(this.isAttached)) {
            RecyclerView.Adapter adapter;
            int size;
            if (stop) {
                this.mView.stopScroll();
            }
            int n = size = (adapter = this.mView.getAdapter()) == null ? 0 : adapter.getItemCount();
            if (size <= 0 || position < 0) {
                position = 0;
                offset = 0;
            } else if (position > size - 1) {
                position = size - 1;
                offset = -1073741824;
            }
            RecyclerView.LayoutManager manager = this.mView.getLayoutManager();
            if (manager instanceof LinearLayoutManager) {
                ((LinearLayoutManager)manager).scrollToPositionWithOffset(position, offset);
            } else if (manager instanceof StaggeredGridLayoutManager) {
                ((StaggeredGridLayoutManager)manager).scrollToPositionWithOffset(position, offset);
            }
        } else if (this.mLazy == null) {
            this.mLazy = ScrollOrder.obtain();
            this.mLazy.stop = stop;
            this.mLazy.position = position;
            this.mLazy.offset = offset;
        } else {
            if (stop) {
                this.mLazy.stop = true;
            }
            this.mLazy.position = position;
            this.mLazy.offset = offset;
        }
    }

    protected abstract boolean sameItem(D var1, D var2);

    protected abstract boolean sameData(D var1, D var2);

    private static class ScrollOrder {
        private static Queue<ScrollOrder> cache = new LinkedList<ScrollOrder>();
        public boolean stop;
        public int position;
        public int offset;

        private ScrollOrder() {
        }

        public static ScrollOrder obtain() {
            return cache.size() > 0 ? cache.remove() : new ScrollOrder();
        }

        public void recycle() {
            cache.add(this);
        }
    }
}

