/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.uikit.util;

import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.Window;
import java.util.HashMap;

public class TagUtil {
    private static final boolean COVER_TAG = false;

    public static boolean put(Object host, String key, Object value) {
        View view = TagUtil.find(host);
        if (view != null) {
            Object tag = view.getTag();
            if (tag instanceof Map) {
                ((Map)tag).put(key, value);
                return true;
            }
            if (tag == null) {
                view.setTag((Object)new Map(key, value));
                return true;
            }
        }
        return false;
    }

    public static Object get(Object host, String key) {
        return TagUtil.get(host, key, null);
    }

    public static Object get(Object host, String key, Object defaultValue) {
        Object value;
        Object tag;
        View view = TagUtil.find(host);
        if (view != null && (tag = view.getTag()) instanceof Map && (value = ((Map)tag).get(key)) != null) {
            return value;
        }
        return defaultValue;
    }

    private static View find(Object object) {
        if (object instanceof View) {
            return (View)object;
        }
        if (object instanceof Window) {
            return TagUtil.find((Window)object);
        }
        if (object instanceof Activity) {
            return TagUtil.find((Activity)object);
        }
        if (object instanceof Dialog) {
            return TagUtil.find((Dialog)object);
        }
        if (object instanceof Fragment) {
            return TagUtil.find((Fragment)object);
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return TagUtil.find((android.support.v4.app.Fragment)object);
        }
        return null;
    }

    private static View find(Window window) {
        return window.getDecorView();
    }

    private static View find(Activity activity) {
        Window window = activity.getWindow();
        return window == null ? null : TagUtil.find(window);
    }

    private static View find(Dialog dialog) {
        Window window = dialog.getWindow();
        return window == null ? null : TagUtil.find(window);
    }

    private static View find(Fragment fragment) {
        if (fragment instanceof android.app.DialogFragment) {
            Dialog dialog = ((android.app.DialogFragment)fragment).getDialog();
            return dialog == null ? null : TagUtil.find(dialog);
        }
        Activity activity = fragment.getActivity();
        return activity == null ? null : TagUtil.find(activity);
    }

    private static View find(android.support.v4.app.Fragment fragment) {
        if (fragment instanceof DialogFragment) {
            Dialog dialog = ((DialogFragment)fragment).getDialog();
            return dialog == null ? null : TagUtil.find(dialog);
        }
        FragmentActivity activity = fragment.getActivity();
        return activity == null ? null : TagUtil.find((Activity)activity);
    }

    private static class Map
    extends HashMap<String, Object> {
        private Map(String key, Object value) {
            this.put(key, value);
        }
    }
}

