/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.uikit.view;

import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import com.vdian.uikit.util.RectUtil;
import java.util.LinkedList;
import java.util.Queue;

public class ViewMonitor
implements View.OnAttachStateChangeListener,
ViewTreeObserver.OnPreDrawListener {
    private static boolean doDraw = true;
    private boolean isAttached = false;
    private boolean isRaw;
    private View mView;
    private RectListener mListener;

    public static void cancelDraw() {
        doDraw = false;
    }

    public static void globalMonitor(View view, RectListener listener) {
        if (view == null || listener == null) {
            return;
        }
        view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new ViewMonitor(true, view, listener));
    }

    public static void localMonitor(View view, RectListener listener) {
        if (view == null || listener == null) {
            return;
        }
        view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new ViewMonitor(false, view, listener));
    }

    private ViewMonitor(boolean raw, View view, RectListener listener) {
        this.isRaw = raw;
        this.mView = view;
        this.mListener = listener;
        if (ViewCompat.isAttachedToWindow((View)this.mView)) {
            this.onViewAttachedToWindow(null);
        }
    }

    public void onViewAttachedToWindow(View v) {
        if (this.isAttached) {
            return;
        }
        this.isAttached = true;
        this.mView.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        if (this.mListener instanceof RectListeners) {
            ((RectListeners)this.mListener).monitor(this.isAttached);
        }
    }

    public void onViewDetachedFromWindow(View v) {
        if (!this.isAttached) {
            return;
        }
        this.isAttached = false;
        this.mView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        if (this.mListener instanceof RectListeners) {
            ((RectListeners)this.mListener).monitor(this.isAttached);
        }
    }

    public boolean onPreDraw() {
        doDraw = true;
        RectManager.release(this.mListener.handle(RectManager.request(this.isRaw, this.mView)));
        return doDraw;
    }

    public static interface RectListeners
    extends RectListener {
        public void monitor(boolean var1);
    }

    public static interface RectListener {
        public Rect handle(Rect var1);
    }

    private static class RectManager {
        private static Queue<Rect> cache = new LinkedList<Rect>();
        private static Rect origin = new Rect();

        private RectManager() {
        }

        protected static Rect request(boolean raw, View view) {
            Rect rect;
            ViewParent viewParent;
            View parent = null;
            if (!raw && (viewParent = view.getParent()) instanceof View) {
                parent = (View)viewParent;
            }
            if (parent == null) {
                rect = cache.size() > 0 ? cache.remove() : new Rect();
                RectUtil.measure(view, rect);
                return rect;
            }
            RectUtil.measure(parent, origin);
            rect = cache.size() > 0 ? cache.remove() : new Rect();
            RectUtil.measure(view, rect);
            rect.set(rect.left - RectManager.origin.left, rect.top - RectManager.origin.top, rect.right - RectManager.origin.left, rect.bottom - RectManager.origin.top);
            return rect;
        }

        protected static void release(Rect rect) {
            if (rect != null) {
                cache.add(rect);
            }
        }
    }
}

