/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.uikit.util.task;

import android.os.Handler;
import android.os.Looper;
import com.vdian.uikit.util.task.Loop;
import com.vdian.uikit.util.task.Pipeline;
import java.util.HashMap;

public abstract class Task {
    private static Handler handler = new Handler(Looper.getMainLooper());
    private static HashMap<String, Pipeline> pipelines = new HashMap();

    public static void runOnUiThread(Runnable action) {
        handler.post(action);
    }

    public void publish() {
        String key = this.getClass().getName();
        Pipeline pipeline = pipelines.get(key);
        if (pipeline == null) {
            pipeline = new MyPipeline();
            pipelines.put(key, pipeline);
        }
        pipeline.publish(this);
    }

    protected abstract void execute();

    private static class MyPipeline
    extends Loop<Task> {
        private MyPipeline() {
        }

        @Override
        public void execute(Task task) {
            task.execute();
        }
    }
}

