/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.uikit.util;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import java.util.LinkedList;
import java.util.Queue;

public class RectUtil {
    private static int[] location = new int[2];
    private static Queue<Rect> cache = new LinkedList<Rect>();

    public static Rect measure(View view) {
        return RectUtil.measure(view, new Rect(), false);
    }

    public static Rect measure(View view, Rect rect) {
        return RectUtil.measure(view, rect, false);
    }

    public static Rect measure(View view, boolean traverse) {
        return RectUtil.measure(view, new Rect(), traverse);
    }

    public static Rect measure(View view, Rect rect, boolean traverse) {
        view.getLocationOnScreen(location);
        float width = view.getWidth();
        float height = view.getHeight();
        if (traverse) {
            ViewParent parent;
            do {
                width *= view.getScaleX();
                height *= view.getScaleY();
            } while ((view = (parent = view.getParent()) instanceof View ? (View)parent : null) != null);
        }
        rect.set(location[0], location[1], location[0] + (int)width, location[1] + (int)height);
        return rect;
    }

    public static Rect obtain() {
        return cache.size() > 0 ? cache.remove() : new Rect();
    }

    public static void recycle(Rect rect) {
        cache.add(rect);
    }
}

