/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.salon;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.view.ViewCompat;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.vdian.salon.SalonView;
import com.vdian.uikit.util.RectUtil;
import com.vdian.uikit.view.TransitionController;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class SalonMaster
extends SalonView {
    private List<WeakReference<View>> mViews = new ArrayList<WeakReference<View>>();
    private boolean isShow = false;
    private float mLeft = 0.0f;
    private float mTop = 0.0f;
    private float mRight = 0.0f;
    private float mBottom = 0.0f;
    private Rect mRect = new Rect();
    private Rect yRect = new Rect();
    private ColorDrawable mBg = new ColorDrawable(Color.rgb((int)0, (int)0, (int)0));
    private SalonIndicator mIndicator;
    private SalonPopup mPopup;

    public SalonMaster(ViewGroup root) {
        super(root.getContext());
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.permitTouchEvent(false);
        this.setVisibility(4);
        this.setBackgroundDrawable((Drawable)this.mBg);
        this.mIndicator = new SalonIndicator(root.getContext());
        this.mIndicator.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addView(this.mIndicator);
        this.mPopup = new SalonPopup(root.getContext());
        this.mPopup.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addView((View)this.mPopup);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        root.addView((View)this);
    }

    @Override
    public void display(int index, List<String> urls) {
        this.display(index, urls, null);
    }

    public void display(int index, List<String> urls, List<View> views) {
        if (this.didLayout && !this.isShow) {
            this.isShow = true;
            this.mViews.clear();
            if (views != null) {
                for (View view : views) {
                    this.mViews.add(new WeakReference<View>(view));
                }
            }
            super.display(index, urls);
            this.animation(true);
            this.requestFocus();
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.bringChildToFront((View)this);
                this.requestLayout();
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean consume = false;
        switch (keyCode) {
            case 4: {
                if (this.mPopup.isShow) {
                    consume = true;
                    if (this.isTouch()) break;
                    this.mPopup.onClick((View)this.mPopup);
                    break;
                }
                if (!this.isShow) break;
                consume = true;
                if (this.isTouch() || !this.permitTouchEvent() || this.mOffset != 0.0f) break;
                this.animation(false);
            }
        }
        return consume || super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onUpdate(float index, int size) {
        this.mIndicator.display(index, size);
    }

    @Override
    protected void onClick(float x, float y) {
        if (this.mOffset != 0.0f) {
            return;
        }
        this.animation(false);
    }

    @Override
    protected void onDoubleClick(float x, float y) {
        this.doZoom = true;
        this.zoomX = x;
        this.zoomY = y;
    }

    @Override
    protected void onLongClick(float x, float y) {
        if (this.mOffset != 0.0f) {
            return;
        }
        if (this.mPopup.display(this.mUrlIndex, (String)this.mUrls.get(this.mUrlIndex), this.mExhibits[this.mChildIndex])) {
            this.permitTouchEvent(false);
            this.permitTouchEvent(true);
        }
    }

    @Override
    protected View onCreateExhibit(Context context) {
        return new SalonFrame(context, this.onCreateImage(context));
    }

    protected void onDraw(Canvas canvas) {
        canvas.clipRect(this.mLeft, this.mTop, this.mRight, this.mBottom);
        super.onDraw(canvas);
    }

    private void animation(boolean show) {
        View view;
        WeakReference<View> reference;
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        final ArrayList<View> decorations = new ArrayList<View>();
        LinkedList<SalonMaster> queue = new LinkedList<SalonMaster>();
        queue.add(this);
        while (queue.size() > 0) {
            View target = (View)queue.remove();
            if (target instanceof ViewGroup) {
                for (int i = 0; i < ((ViewGroup)target).getChildCount(); ++i) {
                    View child = ((ViewGroup)target).getChildAt(i);
                    if (child == null) continue;
                    queue.add((SalonMaster)child);
                }
            }
            if (!(target instanceof SalonDecoration)) continue;
            decorations.add(target);
        }
        float ratio = 0.0f;
        Rect rect = null;
        if (this.mUrlIndex >= 0 && this.mUrlIndex < this.mViews.size() && (reference = this.mViews.get(this.mUrlIndex)) != null && (view = (View)reference.get()) != null) {
            rect = this.getRect(view);
        }
        if (rect != null) {
            ratio = this.getRatio((String)this.mUrls.get(this.mUrlIndex));
        }
        if (ratio <= 0.0f || rect == null) {
            if (show) {
                float sScale = 1.0f;
                float eScale = 1.0f;
                float sDx = 0.0f;
                float eDx = 0.0f;
                float sDy = 0.0f;
                float eDy = 0.0f;
                this.mAnimator = new SalonView.SalonAnimation(300L, null){

                    @Override
                    protected void display(SalonView.SalonAnimation animation, float value, long time) {
                        if (value < 0.0f) {
                            value = 0.0f;
                        }
                        value = value >= 1.0f ? 1.0f : (float)(Math.cos((double)(value + 1.0f) * Math.PI) / 2.0) + 0.5f;
                        SalonMaster.this.setAlpha(value);
                        SalonMaster.this.mBg.setAlpha(255);
                        SalonMaster.this.mScales[SalonMaster.this.mChildIndex] = 1.0f * (1.0f - value) + 1.0f * value;
                        SalonMaster.this.mDxs[SalonMaster.this.mChildIndex] = 0.0f * (1.0f - value) + 0.0f * value;
                        SalonMaster.this.mDys[SalonMaster.this.mChildIndex] = 0.0f * (1.0f - value) + 0.0f * value;
                        ((SalonView.SalonExhibit)SalonMaster.this.mExhibits[SalonMaster.this.mChildIndex]).setMatrix(SalonMaster.this.mDxs[SalonMaster.this.mChildIndex], SalonMaster.this.mDys[SalonMaster.this.mChildIndex], SalonMaster.this.mScales[SalonMaster.this.mChildIndex]);
                        SalonMaster.this.mLeft = 0.0f;
                        SalonMaster.this.mTop = 0.0f;
                        SalonMaster.this.mRight = SalonMaster.this.getWidth();
                        SalonMaster.this.mBottom = SalonMaster.this.getHeight();
                        SalonMaster.this.invalidate();
                        for (View view : decorations) {
                            view.setAlpha(1.0f);
                        }
                    }

                    @Override
                    protected void onStart() {
                        SalonMaster.this.setVisibility(0);
                        super.onStart();
                    }

                    @Override
                    protected void onEnd() {
                        super.onEnd();
                        SalonMaster.this.permitTouchEvent(true);
                    }
                }.start();
            } else {
                final float sScale = this.mScales[this.mChildIndex];
                float eScale = 1.0f;
                final float sDx = this.mDxs[this.mChildIndex];
                float eDx = 0.0f;
                final float sDy = this.mDys[this.mChildIndex];
                float eDy = 0.0f;
                this.mAnimator = new SalonView.SalonAnimation(300L, null){

                    @Override
                    protected void display(SalonView.SalonAnimation animation, float value, long time) {
                        if (value < 0.0f) {
                            value = 0.0f;
                        }
                        value = value >= 1.0f ? 1.0f : (float)(Math.cos((double)(value + 1.0f) * Math.PI) / 2.0) + 0.5f;
                        SalonMaster.this.setAlpha(1.0f - value);
                        SalonMaster.this.mBg.setAlpha(255);
                        SalonMaster.this.mScales[SalonMaster.this.mChildIndex] = sScale * (1.0f - value) + 1.0f * value;
                        SalonMaster.this.mDxs[SalonMaster.this.mChildIndex] = sDx * (1.0f - value) + 0.0f * value;
                        SalonMaster.this.mDys[SalonMaster.this.mChildIndex] = sDy * (1.0f - value) + 0.0f * value;
                        ((SalonView.SalonExhibit)SalonMaster.this.mExhibits[SalonMaster.this.mChildIndex]).setMatrix(SalonMaster.this.mDxs[SalonMaster.this.mChildIndex], SalonMaster.this.mDys[SalonMaster.this.mChildIndex], SalonMaster.this.mScales[SalonMaster.this.mChildIndex]);
                        SalonMaster.this.mLeft = 0.0f;
                        SalonMaster.this.mTop = 0.0f;
                        SalonMaster.this.mRight = SalonMaster.this.getWidth();
                        SalonMaster.this.mBottom = SalonMaster.this.getHeight();
                        SalonMaster.this.invalidate();
                        for (View view : decorations) {
                            view.setAlpha(1.0f);
                        }
                    }

                    @Override
                    protected void onStart() {
                        SalonMaster.this.permitTouchEvent(false);
                        super.onStart();
                    }

                    @Override
                    protected void onEnd() {
                        super.onEnd();
                        SalonMaster.this.isShow = false;
                        SalonMaster.this.setVisibility(4);
                        for (int d = 0; d <= 1; ++d) {
                            int l = (3 + SalonMaster.this.mChildIndex - d) % 3;
                            if (SalonMaster.this.mUrlIndex - d >= 0 && SalonMaster.this.mUrlIndex - d < SalonMaster.this.mUrls.size()) {
                                ((SalonView.SalonExhibit)SalonMaster.this.mExhibits[l]).loadUrl(null);
                            }
                            if (d == 0) continue;
                            int r = (3 + SalonMaster.this.mChildIndex + d) % 3;
                            if (SalonMaster.this.mUrlIndex + d < 0 || SalonMaster.this.mUrlIndex + d >= SalonMaster.this.mUrls.size()) continue;
                            ((SalonView.SalonExhibit)SalonMaster.this.mExhibits[r]).loadUrl(null);
                        }
                    }
                }.start();
            }
        } else {
            float scale = (float)rect.width() >= ratio * (float)rect.height() ? (float)rect.width() / (ratio * (float)this.getHeight() > (float)this.getWidth() ? (float)this.getWidth() : (float)this.getHeight() * ratio) : (float)rect.height() / (ratio * (float)this.getHeight() > (float)this.getWidth() ? (float)this.getWidth() / ratio : (float)this.getHeight());
            float x = (rect.left + rect.right - this.getWidth()) / 2;
            float y = (rect.top + rect.bottom - this.getHeight()) / 2;
            if (show) {
                final float sScale = scale;
                float eScale = 1.0f;
                final float sDx = x;
                float eDx = 0.0f;
                final float sDy = y;
                float eDy = 0.0f;
                final float sLeft = rect.left;
                float eLeft = 0.0f;
                final float sTop = rect.top;
                float eTop = 0.0f;
                final float sRight = rect.right;
                final float eRight = this.getWidth();
                final float sBottom = rect.bottom;
                final float eBottom = this.getHeight();
                this.mAnimator = new SalonView.SalonAnimation(300L, null){

                    @Override
                    protected void display(SalonView.SalonAnimation animation, float value, long time) {
                        float value1 = (value - 0.0f) / 0.2f;
                        if (value1 < 0.0f) {
                            value1 = 0.0f;
                        }
                        if (value1 > 1.0f) {
                            value1 = 1.0f;
                        }
                        SalonMaster.this.setAlpha(value1);
                        float value2 = (value - 0.2f) / 0.8f;
                        if (value2 < 0.0f) {
                            value2 = 0.0f;
                        }
                        value2 = value2 >= 1.0f ? 1.0f : (float)(Math.cos((double)(value2 + 1.0f) * Math.PI) / 2.0) + 0.5f;
                        SalonMaster.this.mBg.setAlpha((int)(255.0f * value2));
                        SalonMaster.this.mScales[SalonMaster.this.mChildIndex] = sScale * (1.0f - value2) + 1.0f * value2;
                        SalonMaster.this.mDxs[SalonMaster.this.mChildIndex] = sDx * (1.0f - value2) + 0.0f * value2;
                        SalonMaster.this.mDys[SalonMaster.this.mChildIndex] = sDy * (1.0f - value2) + 0.0f * value2;
                        ((SalonView.SalonExhibit)SalonMaster.this.mExhibits[SalonMaster.this.mChildIndex]).setMatrix(SalonMaster.this.mDxs[SalonMaster.this.mChildIndex], SalonMaster.this.mDys[SalonMaster.this.mChildIndex], SalonMaster.this.mScales[SalonMaster.this.mChildIndex]);
                        float value3 = (value - 0.2f) / 0.6f;
                        if (value3 < 0.0f) {
                            value3 = 0.0f;
                        }
                        value3 = value3 >= 1.0f ? 1.0f : (float)(Math.cos((double)(value3 + 1.0f) * Math.PI) / 2.0) + 0.5f;
                        SalonMaster.this.mLeft = sLeft * (1.0f - value3) + 0.0f * value3;
                        SalonMaster.this.mTop = sTop * (1.0f - value3) + 0.0f * value3;
                        SalonMaster.this.mRight = sRight * (1.0f - value3) + eRight * value3;
                        SalonMaster.this.mBottom = sBottom * (1.0f - value3) + eBottom * value3;
                        SalonMaster.this.invalidate();
                        float value4 = (value - 0.8f) / 0.2f;
                        if (value4 < 0.0f) {
                            value4 = 0.0f;
                        }
                        if (value4 > 1.0f) {
                            value4 = 1.0f;
                        }
                        for (View view : decorations) {
                            view.setAlpha(value4);
                        }
                    }

                    @Override
                    protected void onStart() {
                        SalonMaster.this.setVisibility(0);
                        super.onStart();
                    }

                    @Override
                    protected void onEnd() {
                        super.onEnd();
                        SalonMaster.this.permitTouchEvent(true);
                    }
                }.start();
            } else {
                final float sScale = this.mScales[this.mChildIndex];
                final float eScale = scale;
                final float sDx = this.mDxs[this.mChildIndex];
                final float eDx = x;
                final float sDy = this.mDys[this.mChildIndex];
                final float eDy = y;
                float sLeft = 0.0f;
                final float eLeft = rect.left;
                float sTop = 0.0f;
                final float eTop = rect.top;
                final float sRight = this.getWidth();
                final float eRight = rect.right;
                final float sBottom = this.getHeight();
                final float eBottom = rect.bottom;
                this.mAnimator = new SalonView.SalonAnimation(300L, null){

                    @Override
                    protected void display(SalonView.SalonAnimation animation, float value, long time) {
                        float value1 = (value - 0.8f) / 0.2f;
                        if (value1 < 0.0f) {
                            value1 = 0.0f;
                        }
                        if (value1 > 1.0f) {
                            value1 = 1.0f;
                        }
                        SalonMaster.this.setAlpha(1.0f - value1);
                        float value2 = (value - 0.0f) / 0.8f;
                        if (value2 < 0.0f) {
                            value2 = 0.0f;
                        }
                        value2 = value2 >= 1.0f ? 1.0f : (float)(Math.cos((double)(value2 + 1.0f) * Math.PI) / 2.0) + 0.5f;
                        SalonMaster.this.mBg.setAlpha((int)(255.0f * (1.0f - value2)));
                        SalonMaster.this.mScales[SalonMaster.this.mChildIndex] = sScale * (1.0f - value2) + eScale * value2;
                        SalonMaster.this.mDxs[SalonMaster.this.mChildIndex] = sDx * (1.0f - value2) + eDx * value2;
                        SalonMaster.this.mDys[SalonMaster.this.mChildIndex] = sDy * (1.0f - value2) + eDy * value2;
                        ((SalonView.SalonExhibit)SalonMaster.this.mExhibits[SalonMaster.this.mChildIndex]).setMatrix(SalonMaster.this.mDxs[SalonMaster.this.mChildIndex], SalonMaster.this.mDys[SalonMaster.this.mChildIndex], SalonMaster.this.mScales[SalonMaster.this.mChildIndex]);
                        float value3 = (value - 0.2f) / 0.6f;
                        if (value3 < 0.0f) {
                            value3 = 0.0f;
                        }
                        value3 = value3 >= 1.0f ? 1.0f : (float)(Math.cos((double)(value3 + 1.0f) * Math.PI) / 2.0) + 0.5f;
                        SalonMaster.this.mLeft = 0.0f * (1.0f - value3) + eLeft * value3;
                        SalonMaster.this.mTop = 0.0f * (1.0f - value3) + eTop * value3;
                        SalonMaster.this.mRight = sRight * (1.0f - value3) + eRight * value3;
                        SalonMaster.this.mBottom = sBottom * (1.0f - value3) + eBottom * value3;
                        SalonMaster.this.invalidate();
                        float value4 = (value - 0.0f) / 0.2f;
                        if (value4 < 0.0f) {
                            value4 = 0.0f;
                        }
                        if (value4 > 1.0f) {
                            value4 = 1.0f;
                        }
                        for (View view : decorations) {
                            view.setAlpha(1.0f - value4);
                        }
                    }

                    @Override
                    protected void onStart() {
                        SalonMaster.this.permitTouchEvent(false);
                        super.onStart();
                    }

                    @Override
                    protected void onEnd() {
                        super.onEnd();
                        SalonMaster.this.isShow = false;
                        SalonMaster.this.setVisibility(4);
                        for (int d = 0; d <= 1; ++d) {
                            int l = (3 + SalonMaster.this.mChildIndex - d) % 3;
                            if (SalonMaster.this.mUrlIndex - d >= 0 && SalonMaster.this.mUrlIndex - d < SalonMaster.this.mUrls.size()) {
                                ((SalonView.SalonExhibit)SalonMaster.this.mExhibits[l]).loadUrl(null);
                            }
                            if (d == 0) continue;
                            int r = (3 + SalonMaster.this.mChildIndex + d) % 3;
                            if (SalonMaster.this.mUrlIndex + d < 0 || SalonMaster.this.mUrlIndex + d >= SalonMaster.this.mUrls.size()) continue;
                            ((SalonView.SalonExhibit)SalonMaster.this.mExhibits[r]).loadUrl(null);
                        }
                    }
                }.start();
            }
        }
    }

    protected abstract View onCreateImage(Context var1);

    protected abstract float getRatio(String var1);

    protected Rect getRect(View view) {
        if (ViewCompat.isAttachedToWindow((View)view)) {
            RectUtil.measure((View)view, (Rect)this.yRect);
            RectUtil.measure((View)this, (Rect)this.mRect);
            this.yRect.left -= this.mRect.left;
            this.yRect.right -= this.mRect.left;
            this.yRect.top -= this.mRect.top;
            this.yRect.bottom -= this.mRect.top;
            return this.yRect;
        }
        return null;
    }

    public void setPopupAdapter(PopupAdapter adapter) {
        this.mPopup.mAdapter = adapter;
    }

    public static abstract class PopupAdapter {
        private String mExit;
        private PopupInfo mInfo = new PopupInfo();

        public PopupAdapter() {
            this("\u53d6\u6d88");
        }

        public PopupAdapter(String exit) {
            this.mExit = exit;
        }

        private void reset(int index, String url, View exhibit) {
            this.mInfo.index = index;
            this.mInfo.url = url;
            this.mInfo.image = ((SalonFrame)exhibit).mImage;
        }

        private int[] create() {
            return this.onCreate(this.mInfo);
        }

        private String bind(int type) {
            return this.onBind(type, this.mInfo);
        }

        private void click(int type) {
            this.onClick(type, this.mInfo);
        }

        private String exit() {
            return this.mExit;
        }

        protected abstract int[] onCreate(PopupInfo var1);

        protected abstract String onBind(int var1, PopupInfo var2);

        protected abstract void onClick(int var1, PopupInfo var2);

        protected static class PopupInfo {
            public int index;
            public String url;
            public View image;

            protected PopupInfo() {
            }
        }
    }

    private static class SalonPopup
    extends LinearLayout
    implements TransitionController.TransitionListener,
    View.OnClickListener {
        private static final int CELL_HEIGHT = 50;
        private static final int SMALL_MARGIN = 1;
        private static final int BIG_MARGIN = 8;
        private boolean isShow = false;
        private boolean canClick = false;
        private int mHeight = 0;
        private Paint mPaint;
        private TransitionController mAnimation;
        private PopupAdapter mAdapter;

        public SalonPopup(Context context) {
            super(context);
            this.setWillNotDraw(false);
            this.setOrientation(1);
            this.setGravity(80);
            this.mPaint = new Paint();
            this.mPaint.setColor(Color.rgb((int)0, (int)0, (int)0));
            this.mAnimation = new TransitionController((TransitionController.TransitionListener)this, (View)this);
            this.mAnimation.initDisplay();
            SalonPopup.setOnClickListener((View)this, this);
        }

        public boolean display(int index, String url, View view) {
            if (!this.isShow && this.mAdapter != null) {
                this.mAdapter.reset(index, url, view);
                int[] btns = this.mAdapter.create();
                if (btns != null && btns.length > 0) {
                    this.isShow = true;
                    this.canClick = true;
                    float density = this.getContext().getResources().getDisplayMetrics().density;
                    this.mHeight = (btns.length + 1) * (int)(50.0f * density) + (btns.length - 1) * (int)(1.0f * density) + (int)(8.0f * density);
                    this.removeAllViews();
                    for (int i = 0; i <= btns.length; ++i) {
                        if (i != 0) {
                            boolean small = i < btns.length;
                            View divider = new View(this.getContext()){

                                public boolean onTouchEvent(MotionEvent event) {
                                    return true;
                                }
                            };
                            divider.setLayoutParams(new ViewGroup.LayoutParams(-1, (int)((float)(small ? 1 : 8) * density)));
                            divider.setBackgroundColor(Color.parseColor((String)(small ? "#f5e3e3e3" : "#f5ebebeb")));
                            this.addView(divider);
                        }
                        Integer type = i < btns.length ? Integer.valueOf(btns[i]) : null;
                        TextView button = new TextView(this.getContext());
                        button.setLayoutParams(new ViewGroup.LayoutParams(-1, (int)(50.0f * density)));
                        button.setGravity(17);
                        button.setTextColor(Color.parseColor((String)"#585858"));
                        button.setTextSize(18.0f);
                        button.setText((CharSequence)(type == null ? this.mAdapter.exit() : this.mAdapter.bind(type)));
                        StateListDrawable bg = new StateListDrawable();
                        bg.addState(View.PRESSED_ENABLED_STATE_SET, (Drawable)new ColorDrawable(Color.parseColor((String)"#fafafafa")));
                        bg.addState(View.EMPTY_STATE_SET, (Drawable)new ColorDrawable(Color.parseColor((String)"#ffffffff")));
                        button.setBackgroundDrawable((Drawable)bg);
                        button.setTag((Object)type);
                        button.setOnClickListener((View.OnClickListener)this);
                        this.addView((View)button);
                    }
                    this.setVisibility(0);
                    this.mAnimation.setTarget(1.0f);
                    return true;
                }
            }
            return false;
        }

        public void onClick(View v) {
            Object tag = v.getTag();
            if (this.canClick && tag instanceof Integer) {
                this.mAdapter.click((Integer)tag);
            }
            this.canClick = false;
            this.mAnimation.setTarget(0.0f);
        }

        public void computeScroll() {
            super.computeScroll();
            this.mAnimation.computeScroll();
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            canvas.drawRect(0.0f, (float)(-this.mHeight), (float)this.getWidth(), (float)(this.getHeight() - this.mHeight), this.mPaint);
        }

        public float speed(float value, float target) {
            return 0.0033333334f;
        }

        public void display(View self, float value) {
            if (this.mAnimation.getValue() == this.mAnimation.getTarget() && this.mAnimation.getValue() == 0.0f) {
                this.isShow = false;
                if (this.getVisibility() != 4) {
                    this.setVisibility(4);
                }
            }
            this.setAlpha(value == 0.0f ? 0.0f : 1.0f);
            value = (float)(Math.cos((double)(value + 1.0f) * Math.PI) / 2.0) + 0.5f;
            this.scrollTo(0, (int)((float)(-this.mHeight) * (1.0f - value)));
            this.mPaint.setAlpha((int)(127.0f * value));
            this.invalidate();
        }

        private static void setOnClickListener(final View view, final View.OnClickListener listener) {
            final float limit = 4.0f * view.getContext().getResources().getDisplayMetrics().density;
            view.setOnTouchListener(new View.OnTouchListener(){
                float downX = 0.0f;
                float downY = 0.0f;
                boolean canClick = false;

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            this.downX = event.getX();
                            this.downY = event.getY();
                            this.canClick = true;
                            break;
                        }
                        case 2: {
                            if (!this.canClick || !(Math.abs(event.getX() - this.downX) > limit) && !(Math.abs(event.getY() - this.downY) > limit)) break;
                            this.canClick = false;
                            break;
                        }
                        case 1: {
                            if (!this.canClick) break;
                            listener.onClick(view);
                            break;
                        }
                        default: {
                            this.canClick = false;
                        }
                    }
                    return true;
                }
            });
        }
    }

    private static class SalonIndicator
    extends View
    implements SalonDecoration {
        private static final float CIRCLE_RADIUS = 2.8f;
        private static final float CIRCLE_MARGIN = 14.0f;
        private static final float SLIDER_RADIUS = 3.4f;
        private static final float STROKE_WIDTH = 1.0f;
        private static final float BORDER_PADDING = 36.0f;
        private int mSize = 0;
        private int mIndex = -1;
        private float mProgress = -1.0f;
        private Paint sPaint = new Paint(1);
        private Paint lPaint;

        public SalonIndicator(Context context) {
            super(context);
            this.sPaint.setColor(Color.rgb((int)255, (int)255, (int)255));
            this.lPaint = new Paint(1);
            this.lPaint.setColor(Color.argb((int)100, (int)255, (int)255, (int)255));
        }

        public void display(float index, int size) {
            int oSize = this.mSize;
            int oIndex = this.mIndex;
            float oProgress = this.mProgress;
            this.mSize = size;
            this.mIndex = size > 0 ? Math.max(0, Math.min(size - 1, (int)(index + 0.5f))) : -1;
            float f = this.mProgress = size > 1 ? Math.max(0.0f, Math.min(1.0f, index / (float)(size - 1))) : -1.0f;
            if (this.mSize != oSize || this.mIndex != oIndex) {
                this.invalidate();
            } else if (this.overflow() && this.mProgress != oProgress) {
                this.invalidate();
            }
        }

        private boolean overflow() {
            return ((float)(this.mSize - 1) * 14.0f + 2.8f) * this.getContext().getResources().getDisplayMetrics().density > 0.618f * (float)this.getContext().getResources().getDisplayMetrics().widthPixels;
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            if (this.mSize > 1) {
                float density = this.getContext().getResources().getDisplayMetrics().density;
                if (!this.overflow()) {
                    for (int i = 0; i < this.mSize; ++i) {
                        float cx = (float)(this.getWidth() / 2) - (float)(this.mSize - 1) * 14.0f * density / 2.0f + (float)i * 14.0f * density;
                        float cy = (float)this.getHeight() - 36.0f * density;
                        canvas.drawCircle(cx, cy, 2.8f * density, i == this.mIndex ? this.sPaint : this.lPaint);
                    }
                } else {
                    float w = (float)this.getWidth() - 36.0f * density;
                    float h = 1.0f * density;
                    float l = (float)(this.getWidth() / 2) - w / 2.0f;
                    float t = (float)this.getHeight() - 36.0f * density - h / 2.0f;
                    canvas.drawRect(l, t, l + w, t + h, this.lPaint);
                    canvas.drawCircle(l + w * this.mProgress, t + h / 2.0f, 3.4f * density, this.sPaint);
                }
            }
        }
    }

    private static class SalonFrame
    extends RelativeLayout
    implements SalonView.SalonExhibit {
        private View mImage;
        private LoadView mLoad;
        private FailView mFail;
        private Matrix mMatrix = new Matrix();

        public SalonFrame(Context context, View image) {
            super(context);
            this.setWillNotDraw(false);
            this.mImage = image;
            this.mImage.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.addView(this.mImage);
            this.mLoad = new LoadView(context);
            this.mLoad.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.addView(this.mLoad);
            this.mFail = new FailView(context);
            this.mFail.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.addView(this.mFail);
        }

        @Override
        public void loadUrl(String url) {
            ((SalonImage)this.mImage).loadUrl(url);
            if (url == null || url.equals("")) {
                this.mLoad.display(false);
                this.mFail.display(false);
            } else {
                this.mLoad.display(true);
                this.mFail.display(true);
            }
        }

        @Override
        public float getRatio() {
            return ((SalonImage)this.mImage).getRatio();
        }

        @Override
        public void setMatrix(float dx, float dy, float scale) {
            this.mMatrix.reset();
            this.mMatrix.setScale(scale, scale, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            this.mMatrix.postTranslate(dx, dy);
            this.invalidate();
        }

        protected void onDraw(Canvas canvas) {
            canvas.concat(this.mMatrix);
            super.onDraw(canvas);
        }

        private class FailView
        extends View
        implements SalonDecoration,
        TransitionController.TransitionListener {
            private static final float STROKE_WIDTH = 1.5f;
            private static final float CIRCLE_RADIUS = 14.0f;
            private Paint sPaint;
            private Paint lPaint;
            private TransitionController mAnimation;

            public FailView(Context context) {
                super(context);
                this.sPaint = new Paint(1);
                this.sPaint.setColor(Color.rgb((int)255, (int)255, (int)255));
                this.sPaint.setStyle(Paint.Style.STROKE);
                this.sPaint.setStrokeWidth(1.5f * this.getContext().getResources().getDisplayMetrics().density);
                this.sPaint.setTypeface(Typeface.SERIF);
                this.sPaint.setTextAlign(Paint.Align.CENTER);
                this.sPaint.setTextSize(14.0f * this.getContext().getResources().getDisplayMetrics().density);
                this.lPaint = new Paint(1);
                this.lPaint.setColor(Color.argb((int)158, (int)0, (int)0, (int)0));
                this.lPaint.setStyle(Paint.Style.STROKE);
                this.lPaint.setStrokeWidth(1.5f * this.getContext().getResources().getDisplayMetrics().density);
                this.lPaint.setTypeface(Typeface.SERIF);
                this.lPaint.setTextAlign(Paint.Align.CENTER);
                this.lPaint.setTextSize(14.0f * this.getContext().getResources().getDisplayMetrics().density);
                this.mAnimation = new TransitionController((TransitionController.TransitionListener)this, (View)this);
            }

            public void display(boolean show) {
                if (!show) {
                    this.mAnimation.setValue(0.0f);
                } else {
                    this.mAnimation.setValue(0.0f);
                    this.mAnimation.setTarget(1.0f);
                }
            }

            public void computeScroll() {
                super.computeScroll();
                this.mAnimation.computeScroll();
            }

            protected void onDraw(Canvas canvas) {
                float value;
                super.onDraw(canvas);
                if (SalonFrame.this.getRatio() == -1.0f && (value = this.mAnimation.getValue()) > 0.309f) {
                    canvas.translate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
                    float radius = 14.0f * this.getContext().getResources().getDisplayMetrics().density;
                    float lvalue = Math.max(0.0f, Math.min(1.0f, (value - 0.809f) / 0.191f));
                    if (lvalue != 0.0f) {
                        canvas.save(1);
                        canvas.translate(0.618f * (lvalue *= 1.5f * this.getContext().getResources().getDisplayMetrics().density / 0.618f), lvalue);
                        canvas.drawCircle(0.0f, 0.0f, radius, this.lPaint);
                        canvas.drawText("!", 0.0f, -(this.lPaint.getFontMetrics().top + this.lPaint.getFontMetrics().bottom) / 2.0f, this.lPaint);
                        canvas.restore();
                    }
                    float svalue = Math.max(0.0f, Math.min(1.0f, (value - 0.309f) / 0.5f));
                    this.sPaint.setAlpha((int)(255.0f * svalue));
                    canvas.scale(svalue + 0.618f * (1.0f - svalue), svalue + 0.618f * (1.0f - svalue));
                    canvas.drawCircle(0.0f, 0.0f, radius, this.sPaint);
                    canvas.drawText("!", 0.0f, -(this.sPaint.getFontMetrics().top + this.sPaint.getFontMetrics().bottom) / 2.0f, this.sPaint);
                }
            }

            public float speed(float value, float target) {
                if (SalonFrame.this.getRatio() == 0.0f) {
                    return 0.0f;
                }
                return 0.0027777778f;
            }

            public void display(View self, float value) {
                this.invalidate();
            }
        }

        private class LoadView
        extends View
        implements SalonDecoration,
        TransitionController.TransitionListener {
            private static final float STROKE_WIDTH = 1.5f;
            private static final float CIRCLE_RADIUS = 14.0f;
            private float mProgress;
            private float mRotation;
            private Paint sPaint;
            private Paint lPaint;
            private RectF mRectF;
            private Matrix mMatrix;
            private TransitionController mAnimation;

            public LoadView(Context context) {
                super(context);
                this.mProgress = 0.0f;
                this.mRotation = 0.0f;
                this.sPaint = new Paint(1);
                this.sPaint.setColor(Color.rgb((int)255, (int)255, (int)255));
                this.sPaint.setStyle(Paint.Style.STROKE);
                this.sPaint.setStrokeWidth(1.5f * this.getContext().getResources().getDisplayMetrics().density);
                this.lPaint = new Paint(1);
                this.lPaint.setColor(Color.rgb((int)0, (int)0, (int)0));
                this.lPaint.setStyle(Paint.Style.STROKE);
                this.lPaint.setStrokeWidth(1.5f * this.getContext().getResources().getDisplayMetrics().density);
                this.mRectF = new RectF();
                this.mMatrix = new Matrix();
                this.mAnimation = new TransitionController(this, this){

                    protected long reduce(long time) {
                        LoadView.this.mProgress = LoadView.this.mProgress + (float)time / 2000.0f;
                        while (LoadView.this.mProgress < 0.0f) {
                            LoadView.this.mProgress = LoadView.this.mProgress + 1.0f;
                        }
                        while (LoadView.this.mProgress >= 1.0f) {
                            LoadView.this.mProgress = LoadView.this.mProgress - 1.0f;
                        }
                        LoadView.this.mRotation = LoadView.this.mRotation + 360.0f * ((float)time / 1236.0f);
                        while (LoadView.this.mRotation < 0.0f) {
                            LoadView.this.mRotation = LoadView.this.mRotation + 360.0f;
                        }
                        while (LoadView.this.mRotation >= 360.0f) {
                            LoadView.this.mRotation = LoadView.this.mRotation - 360.0f;
                        }
                        return super.reduce(time);
                    }
                };
            }

            public void display(boolean show) {
                if (!show) {
                    this.mAnimation.setValue(0.0f);
                } else {
                    this.mAnimation.setValue(1.0f);
                    this.mAnimation.setTarget(0.0f);
                }
            }

            public void computeScroll() {
                super.computeScroll();
                this.mAnimation.computeScroll();
            }

            protected void onDraw(Canvas canvas) {
                super.onDraw(canvas);
                float value = this.mAnimation.getValue();
                if (value > 0.0f) {
                    float progress;
                    this.mMatrix.reset();
                    this.mMatrix.setScale(value + 0.618f * (1.0f - value), value + 0.618f * (1.0f - value), (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
                    this.mMatrix.postRotate(this.mRotation, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
                    canvas.concat(this.mMatrix);
                    float radius = 14.0f * this.getContext().getResources().getDisplayMetrics().density;
                    this.mRectF.left = (float)(this.getWidth() / 2) - radius;
                    this.mRectF.top = (float)(this.getHeight() / 2) - radius;
                    this.mRectF.right = this.mRectF.left + 2.0f * radius;
                    this.mRectF.bottom = this.mRectF.top + 2.0f * radius;
                    this.sPaint.setAlpha((int)(255.0f * value));
                    this.lPaint.setAlpha((int)(158.0f * value));
                    float f = progress = this.mProgress < 0.618f ? this.mProgress / 0.618f : (1.0f - this.mProgress) / 0.38200003f;
                    if (progress < 0.0f) {
                        progress = 0.0f;
                    }
                    progress = progress >= 1.0f ? 1.0f : (float)(Math.cos((double)(progress + 1.0f) * Math.PI) / 2.0) + 0.5f;
                    canvas.drawArc(this.mRectF, 0.0f, 360.0f * progress, false, this.sPaint);
                    canvas.drawArc(this.mRectF, 0.0f, 360.0f * (progress - 1.0f), false, this.lPaint);
                }
            }

            public float speed(float value, float target) {
                if (SalonFrame.this.getRatio() == 0.0f) {
                    return 0.0f;
                }
                return 0.0055555557f;
            }

            public void display(View self, float value) {
                this.invalidate();
            }
        }
    }

    public static interface SalonImage {
        public static final float RATIO_LOAD = 0.0f;
        public static final float RATIO_FAIL = -1.0f;

        public void loadUrl(String var1);

        public float getRatio();
    }

    public static interface SalonDecoration {
    }
}

